/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class FibVCB
extends FJTask {
    static int sequentialThreshold = 1;
    volatile int number = 0;
    final FibVCB parent;
    int callbacksExpected = 0;
    volatile int callbacksReceived = 0;

    public static void main(String[] args) {
        try {
            int num;
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                num = Integer.parseInt(args[1]);
                if (args.length > 2) {
                    sequentialThreshold = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java FibVCB <threads> <number> [<sequntialThreshold>]");
                return;
            }
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            FibVCB f = new FibVCB(num, null);
            g.invoke(f);
            g.stats();
            long result = f.getAnswer();
            System.out.println("FibVCB: Size: " + num + " Answer: " + result);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    FibVCB(int n, FibVCB p) {
        this.number = n;
        this.parent = p;
    }

    synchronized void addResult(int n) {
        this.number += n;
        ++this.callbacksReceived;
    }

    synchronized int getAnswer() {
        if (!this.isDone()) {
            throw new Error("Not yet computed");
        }
        return this.number;
    }

    public void run() {
        int n = this.number;
        if (n > 1) {
            if (n <= sequentialThreshold) {
                this.number = FibVCB.seqFib(n);
            } else {
                this.number = 0;
                this.callbacksExpected = 2;
                new FibVCB(n - 1, this).fork();
                new FibVCB(n - 2, this).fork();
                while (this.callbacksReceived < this.callbacksExpected) {
                    FJTask.yield();
                }
            }
        }
        if (this.parent != null) {
            this.parent.addResult(this.number);
        }
    }

    static int seqFib(int n) {
        if (n <= 1) {
            return n;
        }
        return FibVCB.seqFib(n - 1) + FibVCB.seqFib(n - 2);
    }
}

