/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.RemoveDuplicatesEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = -7572252564167491022L;
    static JMenuItem[] NONE = new JMenuItem[0];
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;

    private static Node[] nodes(Lookup lookup) {
        Collection c = lookup != null ? lookup.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FileSystemAction.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)).allInstances() : Collections.EMPTY_LIST;
        return c.toArray(new Node[0]);
    }

    static JMenuItem[] createMenu(boolean popUp, Lookup lookup) {
        Node[] n = FileSystemAction.nodes(lookup);
        if (n == null) {
            n = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        HashMap<FileSystem, OrderedSet> fsSet = new HashMap<FileSystem, OrderedSet>();
        if (n != null) {
            int i = 0;
            while (i < n.length) {
                DataObject obj = (DataObject)n[i].getCookie(class$org$openide$loaders$DataObject == null ? FileSystemAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                while (obj instanceof DataShadow) {
                    obj = ((DataShadow)obj).getOriginal();
                }
                if (obj != null) {
                    try {
                        FileSystem fs = obj.getPrimaryFile().getFileSystem();
                        Set foSet = (Set)fsSet.get(fs);
                        if (foSet == null) {
                            foSet = new OrderedSet();
                            fsSet.put(fs, (OrderedSet)foSet);
                        }
                        foSet.addAll(obj.files());
                    }
                    catch (FileStateInvalidException ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (fsSet.size() == 0 || fsSet.size() > 1) {
                return FileSystemAction.createMenu(EmptyEnumeration.EMPTY, popUp, lookup);
            }
            Iterator entrySetIt = fsSet.entrySet().iterator();
            QueueEnumeration result = new QueueEnumeration();
            while (entrySetIt.hasNext()) {
                Map.Entry entry = entrySetIt.next();
                FileSystem fs = (FileSystem)entry.getKey();
                Set foSet = (Set)entry.getValue();
                LinkedList backupList = new LinkedList();
                Iterator itBackup = foSet.iterator();
                while (itBackup.hasNext()) {
                    backupList.add(itBackup.next());
                }
                if (foSet == null) continue;
                Iterator it = backupList.iterator();
                while (it.hasNext()) {
                    FileObject fo = (FileObject)it.next();
                    try {
                        if (fo.getFileSystem() == fs) continue;
                        it.remove();
                    }
                    catch (FileStateInvalidException ex) {
                        it.remove();
                    }
                }
                OrderedSet backSet = new OrderedSet();
                backSet.addAll(backupList);
                result.put(fs.getActions(backSet));
            }
            return FileSystemAction.createMenu(result, popUp, lookup);
        }
        return NONE;
    }

    static JMenuItem[] createMenu(Enumeration en, boolean popUp, Lookup lookup) {
        en = new RemoveDuplicatesEnumeration(en);
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        while (en.hasMoreElements()) {
            Action a = (Action)en.nextElement();
            if (lookup != null && a instanceof ContextAwareAction) {
                a = ((ContextAwareAction)a).createContextAwareInstance(lookup);
            }
            boolean enabled = false;
            try {
                enabled = a.isEnabled();
            }
            catch (RuntimeException e) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate(e, 0, "Guilty action: " + a.getClass().getName(), null, null, null);
                em.notify(e);
            }
            if (!enabled) continue;
            JMenuItem item = null;
            if (popUp) {
                if (a instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)((Object)a)).getPopupPresenter();
                }
            } else if (a instanceof Presenter.Menu) {
                item = ((Presenter.Menu)((Object)a)).getMenuPresenter();
            }
            if (item == null) continue;
            items.add(item);
        }
        JMenuItem[] array = new JMenuItem[items.size()];
        items.toArray(array);
        return array;
    }

    public JMenuItem getMenuPresenter() {
        return new Menu(false, null);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu(true, null);
    }

    public String getName() {
        return NbBundle.getMessage(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FileSystemAction.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction, "ACT_FileSystemAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FileSystemAction.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(actionContext);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup {
        private Lookup lookup;

        public DelegateAction(Lookup lookup) {
            this.lookup = lookup;
        }

        public JMenuItem getMenuPresenter() {
            return new Menu(false, this.lookup);
        }

        public JMenuItem getPopupPresenter() {
            return new Menu(true, this.lookup);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class OrderedSet
    extends AbstractSet {
        private QueueEnumeration queue = new QueueEnumeration();
        Object[] objects = null;

        public boolean addAll(Collection coll) {
            this.queue.put(coll);
            return true;
        }

        private Object[] getObjects() {
            if (this.objects == null) {
                AlterEnumeration altered = new AlterEnumeration(this, this.queue){
                    private final /* synthetic */ OrderedSet this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object alter(Object obj) {
                        return Collections.enumeration((Collection)obj);
                    }
                };
                SequenceEnumeration sequenced = new SequenceEnumeration(altered);
                RemoveDuplicatesEnumeration result = new RemoveDuplicatesEnumeration(sequenced);
                ArrayList objectList = new ArrayList();
                int i = 0;
                while (result.hasMoreElements()) {
                    objectList.add(result.nextElement());
                    ++i;
                }
                this.objects = objectList.toArray();
            }
            return this.objects;
        }

        public Iterator iterator() {
            int size = this.getObjects().length;
            return new Iterator(this, size){
                int i;
                private final /* synthetic */ int val$size;
                private final /* synthetic */ OrderedSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$size = val$size;
                    this.i = 0;
                }

                public boolean hasNext() {
                    return this.i < this.val$size;
                }

                public Object next() {
                    return this.this$0.objects[this.i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove is not supported.");
                }
            };
        }

        public int size() {
            return this.getObjects().length;
        }
    }

    private static class Menu
    extends JInlineMenu
    implements PropertyChangeListener {
        private boolean popup;
        private JMenuItem[] last = NONE;
        private Lookup lookup;
        static final long serialVersionUID = 2650151487189209766L;
        boolean needsChange = false;

        Menu(boolean popup, Lookup lookup) {
            this.popup = popup;
            this.lookup = lookup;
            this.changeMenuItems(FileSystemAction.createMenu(popup, lookup));
            if (lookup == null) {
                TopComponent.Registry r = WindowManager.getDefault().getRegistry();
                r.addPropertyChangeListener(WeakListener.propertyChange(this, r));
            }
        }

        synchronized void changeMenuItems(JMenuItem[] items) {
            this.removeListeners(this.last);
            this.addListeners(items);
            this.last = items;
            this.setMenuItems(items);
        }

        private void addListeners(JMenuItem[] items) {
            int len = items.length;
            int i = 0;
            while (i < len) {
                items[i].addPropertyChangeListener(this);
                ++i;
            }
        }

        private void removeListeners(JMenuItem[] items) {
            int len = items.length;
            int i = 0;
            while (i < len) {
                items[i].removePropertyChangeListener(this);
                ++i;
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(FileSystemAction.createMenu(this.popup, this.lookup));
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if (name == null || name.equals("enabled") || name.equals("activatedNodes")) {
                this.needsChange = true;
            }
        }
    }
}

