/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.Any;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.CodeSet;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientProtocol;
import org.openorb.net.RebindChannelException;
import org.openorb.net.ServerManager;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.WeakValueHashMap;

public class IIOPClientProtocol
implements ClientProtocol {
    private ClientManager m_client_manager;
    private ORB m_orb;
    private Codec m_codec;
    private IIOPServerProtocol m_server_protocol = null;
    private ServerManager m_server_manager = null;
    private Map m_channels = new WeakValueHashMap();
    private CodeSetComponentInfo m_codeset_component_info;
    private TransportClientInitializer m_transport_client_init;
    private ServiceContext m_bidir_service_ctxt;
    private Logger m_logger;

    public IIOPClientProtocol(ClientManager clientManager, CDRCodecFactory codec_factory, CodeSetComponentInfo codesetInfo, TransportClientInitializer tpInit, ListenPoint[] biDirListenPoints) {
        try {
            this.m_codec = codec_factory.create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding ex) {
            this.getLogger().error("Could not find codec", (Throwable)ex);
        }
        this.m_client_manager = clientManager;
        this.m_orb = this.m_client_manager.orb();
        this.m_codeset_component_info = codesetInfo;
        this.m_transport_client_init = tpInit;
        if (biDirListenPoints != null) {
            this.m_bidir_service_ctxt = null;
            try {
                BiDirIIOPServiceContext scd = new BiDirIIOPServiceContext(biDirListenPoints);
                Any any = this.m_orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, scd);
                byte[] data = this.m_codec.encode_value(any);
                if (data != null) {
                    this.m_bidir_service_ctxt = new ServiceContext(5, data);
                }
            }
            catch (UserException ex) {
                this.getLogger().error("UserException occured during init of IIOPClientProtocol.", (Throwable)ex);
                throw ExceptionTool.initCause(new INITIALIZE("UserException occured during init of IIOPClientProtocol (" + ex + ")"), (Throwable)ex);
            }
        }
    }

    public void setServerProtocol(IIOPServerProtocol protocol) {
        this.m_server_protocol = protocol;
        this.m_server_manager = protocol.getServerManager();
    }

    public Codec getCodec() {
        return this.m_codec;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public ClientManager getClientManager() {
        return this.m_client_manager;
    }

    public Address[] createAddresses(IORAddressingInfo address) {
        return this.m_transport_client_init.establishTransports(IIOPAddress.get_addresses(this.m_codec, address.ior, address.selected_profile_index, this.getLogger()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBinding createBinding(Address addr) {
        ClientBinding binding;
        if (!(addr instanceof IIOPAddress)) {
            return null;
        }
        IIOPAddress address = (IIOPAddress)addr;
        Map map = this.m_channels;
        synchronized (map) {
            try {
                TransportAssociationHolder tpAssc = new TransportAssociationHolder();
                IIOPClientChannel channel = this.findCreateChannel(address, null, tpAssc);
                binding = this.m_server_manager == null || this.m_server_protocol == null || !this.m_server_protocol.servesAddress(address.get_hostname(), address.get_port()) ? new ClientBinding(address, channel, tpAssc.getValue()) : new ClientBinding(address, channel, tpAssc.getValue(), this.m_server_manager);
            }
            catch (SystemException ex) {
                binding = new ClientBinding(address, ex);
            }
        }
        return binding;
    }

    protected IIOPClientChannel findCreateChannel(IIOPAddress address, IIOPClientChannel replace, TransportAssociationHolder tpAssc) {
        InetAddress host = address.get_host();
        if (host == null) {
            throw new COMM_FAILURE("Host not found", 1146056971, CompletionStatus.COMPLETED_NO);
        }
        LookupKey key = new LookupKey(address);
        IIOPClientChannel channel = (IIOPClientChannel)this.m_channels.get(key);
        if (channel == null || replace == channel) {
            int tcsw;
            int tcsc;
            if (address.get_port() == 0) {
                throw new NO_PERMISSION("Port number published in IOR is 0.", 1146056984, CompletionStatus.COMPLETED_NO);
            }
            CodeSetComponentInfo ci = address.getCodesetComponentInfo();
            if (ci == null) {
                tcsc = 0;
                tcsw = 0;
            } else {
                tcsc = IIOPClientProtocol.selectCodeset(this.m_codeset_component_info.ForCharData, ci.ForCharData, true);
                tcsw = IIOPClientProtocol.selectCodeset(this.m_codeset_component_info.ForWcharData, ci.ForWcharData, false);
            }
            Transport transport = address.createTransport();
            transport.establishAssociation(address, tpAssc);
            channel = new IIOPClientChannel(this, transport, this.m_server_protocol, tcsc, tcsw);
            this.m_channels.put(new HostPortPair(host, address.get_port(), tcsc, tcsw, transport), channel);
        } else {
            tpAssc.setValue(key.getValue());
        }
        return channel;
    }

    private static boolean checkCodeset(int tcs, CodeSetComponent comp) {
        if (tcs == 0x5010001 || tcs == 65801) {
            return true;
        }
        if (comp.native_code_set != tcs) {
            int i = 0;
            while (i < comp.conversion_code_sets.length) {
                if (comp.conversion_code_sets[i] == tcs) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private static int selectCodeset(CodeSetComponent local, CodeSetComponent server, boolean singleByte) {
        int fallback;
        if (local.native_code_set == server.native_code_set) {
            return local.native_code_set;
        }
        int i = 0;
        while (i < local.conversion_code_sets.length) {
            if (server.native_code_set == local.conversion_code_sets[i]) {
                return server.native_code_set;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < server.conversion_code_sets.length) {
            if (local.native_code_set == server.conversion_code_sets[i2]) {
                return local.native_code_set;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < server.conversion_code_sets.length) {
            int j = 0;
            while (j < local.conversion_code_sets.length) {
                if (server.conversion_code_sets[i3] == local.conversion_code_sets[j]) {
                    return server.conversion_code_sets[i3];
                }
                ++j;
            }
            ++i3;
        }
        int n = fallback = singleByte ? 0x5010001 : 65801;
        if (CodeSet.compatible(local.native_code_set, server.native_code_set)) {
            return fallback;
        }
        int i4 = 0;
        while (i4 < local.conversion_code_sets.length) {
            if (CodeSet.compatible(server.native_code_set, local.conversion_code_sets[i4])) {
                return fallback;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < server.conversion_code_sets.length) {
            if (CodeSet.compatible(local.native_code_set, server.conversion_code_sets[i5])) {
                return fallback;
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < server.conversion_code_sets.length) {
            int j = 0;
            while (j < local.conversion_code_sets.length) {
                if (CodeSet.compatible(server.conversion_code_sets[i6], local.conversion_code_sets[j])) {
                    return fallback;
                }
                ++j;
            }
            ++i6;
        }
        throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebindBidirDelegate(IIOPClientChannel deleg, IIOPAddress addr) throws RebindChannelException {
        IIOPClientChannel channel;
        TransportAssociationHolder tpAssc = new TransportAssociationHolder();
        Map map = this.m_channels;
        synchronized (map) {
            channel = this.findCreateChannel(addr, deleg, tpAssc);
        }
        throw new RebindChannelException(channel, tpAssc.getValue());
    }

    ServiceContext getBiDirSC() {
        return this.m_bidir_service_ctxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIOPClientChannel createBidirDelegate(IIOPServerChannel parent, ListenPoint[] listen_points) {
        IIOPClientChannel deleg;
        Map map = this.m_channels;
        synchronized (map) {
            HostPortPair[] keys = new HostPortPair[listen_points.length];
            int j = 0;
            int i = 0;
            while (i < listen_points.length) {
                block17: {
                    InetAddress addr;
                    try {
                        addr = InetAddress.getByName(listen_points[i].host);
                    }
                    catch (UnknownHostException ex) {
                        break block17;
                    }
                    HostPortPair key = new HostPortPair(addr, listen_points[i].port & 0xFFFF, parent.getTCSC(), parent.getTCSW(), null);
                    IIOPClientChannel chan = (IIOPClientChannel)this.m_channels.get(key);
                    if (chan != null) {
                        switch (chan.state()) {
                            case 0x11000000: {
                                return null;
                            }
                            case 0x12000000: {
                                if (!chan.isDelegated()) {
                                    return null;
                                }
                            }
                            case 0x13000000: {
                                chan = null;
                            }
                        }
                    }
                    if (chan == null) {
                        keys[j++] = new HostPortPair(addr, listen_points[i].port & 0xFFFF, parent.getTCSC(), parent.getTCSW(), parent.getSocketQueue().getTransport());
                    }
                }
                ++i;
            }
            if (j == 0) {
                return null;
            }
            deleg = new IIOPClientChannel(this, parent);
            int i2 = 0;
            while (i2 < j) {
                if (keys[i2] != null) {
                    this.m_channels.put(keys[i2], deleg);
                }
                ++i2;
            }
        }
        return deleg;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.orb()).getLogger();
        }
        return this.m_logger;
    }

    private static class HostPortPair
    extends TransportAssociationHolder {
        private int m_hash;
        private InetAddress m_host;
        private int m_port;
        private int m_tcsc = -1;
        private int m_tcsw = -1;
        private Transport m_transport;

        public HostPortPair(InetAddress host, int port, int tcsc, int tcsw, Transport transport) {
            this.m_host = host;
            this.m_port = port;
            this.m_hash = host.hashCode() ^ port;
            this.m_tcsc = tcsc;
            this.m_tcsw = tcsw;
            this.m_transport = transport;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LookupKey) {
                return obj.equals(this);
            }
            HostPortPair hp2 = (HostPortPair)obj;
            if (this.m_transport != null && hp2.m_transport != null) {
                return this == hp2;
            }
            return hp2.m_hash == this.m_hash && hp2.m_port == this.m_port && hp2.m_host.equals(this.m_host) && this.m_tcsc == hp2.m_tcsc && this.m_tcsw == hp2.m_tcsw;
        }
    }

    private static class LookupKey
    extends TransportAssociationHolder {
        private int m_hash;
        private InetAddress m_host;
        private int m_port;
        private CodeSetComponentInfo m_codeset_component_info;
        private IIOPAddress m_address;

        LookupKey(IIOPAddress addr) {
            this.m_host = addr.get_host();
            this.m_port = addr.get_port();
            this.m_hash = this.m_host.hashCode() ^ this.m_port;
            this.m_address = addr;
            this.m_codeset_component_info = addr.getCodesetComponentInfo();
        }

        public int hashCode() {
            return this.m_hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HostPortPair)) {
                return false;
            }
            HostPortPair hp2 = (HostPortPair)obj;
            if (hp2.m_hash != this.m_hash || hp2.m_port != this.m_port || !hp2.m_host.equals(this.m_host)) {
                return false;
            }
            if (this.m_address == null) {
                return true;
            }
            if (!(this.m_codeset_component_info == null || IIOPClientProtocol.checkCodeset(hp2.m_tcsc, this.m_codeset_component_info.ForCharData) && IIOPClientProtocol.checkCodeset(hp2.m_tcsw, this.m_codeset_component_info.ForWcharData))) {
                return false;
            }
            return hp2.m_transport.establishAssociation(this.m_address, this);
        }
    }
}

