/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration)
 *    and Cosylab 2002, All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package com.cosylab.logging;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.event.MenuEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.AbstractList;
import java.util.List;
import java.util.Vector;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.DataOutputStream;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.filechooser.FileFilter;

import com.cosylab.logging.engine.LogEntry;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.InvalidFilterConstraintException;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.adapters.JAXPDOMAdapter;
import org.jdom.JDOMException;

import com.cosylab.gui.components.r2.SmartTextArea;

/**
 * This type was generated by a SmartGuide.
 * 
 * Defines a JFrame Application LoggingClient for displaying event logs 
 * received through the CORBA protocol for the purpose of monitoring and 
 * reviewing of the logs. It contains of a JScrollPane ivjLogTable for the 
 * logs and a LogEntryTable ivjScrollPaneTable for displaying the status 
 * as well as a JPanel ivjJFrameContentPane. Multiple listeners handle 
 * user's input. 
 * Based on the current code and our understanding of it one could describe
 * the information flow as follows. User's input triggers events which are 
 * caught by the listeners attached to each one of the available GUI object
 * representations defined in the LoggingClient class. 
 * Independent of that there are messages available at the logging system 
 * generated by the other services running in the framework. These messages are
 * parsed by the ACSStructuredPushConsumer class using the SAX parser and are
 * then passed on using the LogTableDataModel's appendLog method for outputing
 * the logs to the log table. 
 * In particular, we are interested in the saving and loading of files to be 
 * implemented by the LoggingClient. While saveFile and loadFromFile are defined 
 * in LogTabledataModel, the LogImportTask file makes use of the 
 * the LogTabledataModel's appendLog method as well. The use of the DocumentBuilderFactory 
 * in the LogImportTask defines a way for transforming a DOM tree into XML. 
 * 
 * An important issue is the format of the Log Entry Message produced by the Logging 
 * Service. Certain characters ('<', '>', '&', ''', '"') need to be escaped 
 * because they delineate markup data from character data and cause the following exception 
 * in ACSLogParser class: 
 * org.xml.sax.SAXParseException: The content beginning with '<'
 * is not legal markup. 
 * One solution is replacing the character with the appropriate html substitute &lt;.
 * Another solution is keeping it in a CDATA section: <[!CDATA[the log entry message]]>.
 */
public class LoggingClient extends JFrame {
private JMenuItem ivjNewMenuItem = null; // Connect
		private JMenuItem ivjLoadMenuItem = null; // Load
  private JMenuItem ivjSaveFileMenuItem = null; // Save File As
   private JMenuItem ivjClearAllMenuItem = null; // Clear All
private JMenuItem ivjExitMenuItem = null; // Exit

	private JMenuItem ivjFiltersMenuItem = null; // Filters...
	
	/**
	 * The menu item to lad filters
	 */
	private JMenuItem loadFiltersMenuItem = null; /** The menu item to save the filters */ 	private JMenuItem saveFiltersMenuItem = null;
	
	/**
	 * The menu item to save the filters with a new name */
	private JMenuItem saveAsFiltersMenuItem = null;
	
	/**
	 * The menu item to edit the filters
	 */
	private JMenuItem editFiltersMenuItem = null;
	
	/**
	 * The name of the last save/load filter file
	 * (to implement the save as option)
	 */
	private String filterFileName = null;
	
	private JMenuItem ivjFieldsMenuItem = null; // Fields...
	private JMenu ivjGroupMenu = null; // Group By
	private JMenu ivjSortMenu = null; // Sort By

	private JSeparator ivjJSeparator1 = null;
	private JSeparator ivjJSeparator2 = null;

	private JMenu ivjFileMenu = null; // File
	private JMenu ivjViewMenu = null; // View

	private JLabel ivjFilterStatus = null; // Not filtered
	private JLabel ivjInfoStatus = null; // Additional info

	private JToggleButton ivjJToggleButton1 = null; // Suspend

	private JMenuBar ivjLoggingClientJMenuBar = null;

	private JPanel ivjJPanel1 = null;
	private JPanel ivjJPanel2 = null;
	private JPanel ivjJPanel3 = null;
	private JPanel ivjJPanel4 = null;

	private JScrollPane ivjJScrollPane1 = null;
	private JScrollPane ivjJScrollPane2 = null;

	private JSplitPane ivjJSplitPane1 = null;
	private JSplitPane ivjJSplitPane2 = null;

	private JScrollPane ivjLogTable = null;
	private LogEntryTable ivjScrollPaneTable = null;

	private SmartTextArea ivjStatusArea = null;

	private JPanel ivjJFrameContentPane = null;

	IvjEventHandler ivjEventHandler = new IvjEventHandler();

	private boolean ivjConnPtoSort = false;
	private boolean ivjConnPtoGroup = false;
	private boolean ivjConnPtoLCMod = false;

	private com.cosylab.logging.client.DomTree ivjDomTree = null;

	private LCEngine ivjLCEngine = null;
	private LogTableDataModel ivjLCModel1 = null;
	private LCRemoteResponseCallbackBean ivjLCRemoteResponseCallback = null;

class IvjEventHandler 	implements java.awt.event.ActionListener, java.awt.event.ItemListener,java.awt.event.WindowListener,java.beans.PropertyChangeListener,
			javax.swing.event.MenuListener
	{public void actionPerformed(java.awt.event.ActionEvent e)
		{if (e.getSource() == LoggingClient.this.getNewMenuItem())				connNew(e);

			if (e.getSource() == LoggingClient.this.getLoadMenuItem())
				connLoad(e);
			if (e.getSource() == LoggingClient.this.getLoadMenuItem())
		connLoad2(e);
	if (e.getSource() == LoggingClient.this.getSaveFileMenuItem())
				connSaveFile(e);

if (e.getSource() == LoggingClient.this.getSaveFileMenuItem())
		connSaveFile2(e);

			if (e.getSource() == LoggingClient.this.getClearAllMenuItem())
							connClearAll(e);

			if (e.getSource() == LoggingClient.this.getClearAllMenuItem())
				connClearAll2(e);

if (e.getSource() == LoggingClient.this.getExitMenuItem())
				connExit(e);	if (e.getSource() == LoggingClient.this.getFieldsMenuItem())
				connFields(e);

			if (e.getSource() == LoggingClient.this.editFiltersMenuItem)
				connFilters(e);
			
			if (e.getSource() == LoggingClient.this.loadFiltersMenuItem)
				loadFilters();
			
			if (e.getSource() == LoggingClient.this.saveFiltersMenuItem) {
				if (filterFileName!=null)
					if (filterFileName.length()>0) 
						saveFilters(filterFileName);
}
	
if (e.getSource() == LoggingClient.this.saveAsFiltersMenuItem) {saveAsFilters();
			}};

		public void itemStateChanged(java.awt.event.ItemEvent e)
		{

			if (e.getSource() == LoggingClient.this.getJToggleButton1())
				connSuspend();
		};

	public void propertyChange(java.beans.PropertyChangeEvent evt)	{	if (evt.getSource() == LoggingClient.this.getScrollPaneTable()
				&& (evt.getPropertyName().equals("SortMenu")))
				connPtoP4SetTarget();			if (evt.getSource() == LoggingClient.this.getScrollPaneTable()
				&& (evt.getPropertyName().equals("GroupMenu")))
				connPtoP5SetTarget();
			if (evt.getSource() == LoggingClient.this.getScrollPaneTable()
		&& (evt.getPropertyName().equals("filterString")))
	connFilter(evt);

				if (evt.getSource() == LoggingClient.this.getScrollPaneTable()
		&& (evt.getPropertyName().equals("extraInfo")))
										connDomInfo(evt);

			if (evt.getSource() == LoggingClient.this.getScrollPaneTable()
				&& (evt.getPropertyName().equals("LCModel")))
				connLCMod();
		};
		public void windowActivated(java.awt.event.WindowEvent e)
			{		};

		public void windowClosed(java.awt.event.WindowEvent e)
		{
		}
;

		public void windowClosing(java.awt.event.WindowEvent e)
		{

			if (e.getSource() == LoggingClient.this)
				connLCEngDisconnect(e);
		};

		public void windowDeactivated(java.awt.event.WindowEvent e)
		{
		};

		public void windowDeiconified(java.awt.event.WindowEvent e)
		{
		};

		public void windowIconified(java.awt.event.WindowEvent e)
		{
		};

		public void windowOpened(java.awt.event.WindowEvent e)
		{
		};
		
		
		public void menuCanceled(MenuEvent menuE) {
		};
		
		public void menuSelected(MenuEvent menuE) {
// Check if Save and Save As menu items are selectable
			saveAsFiltersMenuItem.setEnabled(true);
			if (ivjLCModel1.getFilters().length==0) {
	saveFiltersMenuItem.setEnabled(false);	saveAsFiltersMenuItem.setEnabled(false);} else if(filterFileName==null) {
					saveFiltersMenuItem.setEnabled(false);
			} else if (filterFileName.length()==0) {	saveFiltersMenuItem.setEnabled(false);			} else {				saveFiltersMenuItem.setEnabled(true);
			}
		}	public void menuDeselected(MenuEvent menuE) {
		}
	};
	
	/**
	 * The filter to load save filters as xml files
	 * The filter checks for the extension .xml in the name
	 * 
	 * @author acaproni
	 */
	private class xmlFileFilter extends FileFilter {
		public boolean accept(File f) {
			// Check if the name has the extension .xml at the end and is readable
			boolean pass = f.isFile() && f.getName().toUpperCase().endsWith(".XML") && f.canRead();
			// Check if the file is a directory
			pass = pass || f.isDirectory();
			// Check if f is a hidden file
			pass = pass && !f.isHidden();
			return pass; 
		}
		
		public String getDescription() {
			return "xml file";
		}
	}/**	 * LoggingClient constructor comment.
	 */
	public LoggingClient()
	{
	



	super();
		initialize();
}

	/**
	 * LoggingClient constructor comment.
	 * @param title java.lang.String
	 */
	public LoggingClient(String title)
	{
		super(title);
	}
	/**
	 * Connects to the remote system
	 * as soon as the item "New" is clicked.
	 * @param arg1 java.awt.event.ActionEvent
	 */

	private void connNew(java.awt.event.ActionEvent arg1)
	{
		try
		{

			getLCEngine().connect();

		}
		catch (java.lang.Throwable ivjExc)
		{

			handleException(ivjExc);
		}
	}
	/**
	 * Returns the SaveFileMenuItem property value.
	 * @return javax.swing.JMenuItem
	 */
private javax.swing.JMenuItem getSaveFileMenuItem()
{
if (ivjSaveFileMenuItem == null)
{
try
{
ivjSaveFileMenuItem = new javax.swing.JMenuItem();
ivjSaveFileMenuItem.setName("SaveFileMenuItem");
ivjSaveFileMenuItem.setText("Save File As");
}catch (java.lang.Throwable ivjExc)
{
handleException(ivjExc);}
}
return ivjSaveFileMenuItem;
}

/**
  * Returns the LoadMenuItem property value.
   * @return javax.swing.JMenuItem
    */

private javax.swing.JMenuItem getLoadMenuItem()
 {
  if (ivjLoadMenuItem == null)
   {
    try
       { 
        ivjLoadMenuItem = new javax.swing.JMenuItem();
         ivjLoadMenuItem.setName("ivjLoadMenuItem");
          ivjLoadMenuItem.setText("Load");
           }
            catch (java.lang.Throwable ivjExc)
             {
              handleException(ivjExc);
               }
                }
                 return ivjLoadMenuItem;
                  }

private void saveFilters(String fileName) { // Check if the name terminate with xml
if (!fileName.toUpperCase().endsWith(".XML")) {fileName=fileName+".xml";} File f = new File(fileName); try {saveFilters(f);} catch (IOException e) {System.err.println("Error opening "+fileName);}}
	
}

