#ifndef _COUNTER_CONSUMER_H
#define _COUNTER_CONSUMER_H
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) Associated Universities Inc., 2002 
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: CounterConsumerImpl.h,v 1.3 2008/10/07 09:41:42 cparedes Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* eallaert  2008-01-31  initial version
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <baci.h>
//This example is unique because it is derived from CharacteristicComponent's
///superclass, ACSComponent.
#include <acscomponentImpl.h>

///This is the CORBA stub client header for ACSErrTypeCommon.idl where the 
///definition of the CORBA exception is found.
#include <ACSErrTypeCommon.h>

/**
 *  The empty CORBA servant interface, POA_COUNTER::CounterConsumer,
 *  is obtained from this header file and is automatically generated from 
 *  COUNTER's Interface Definition File (i.e., contNcTest_IF.idl) 
 *  by CORBA.
 */
#include <contNcTest_IFS.h>
#include <acsncSimpleConsumer.h>


/**
 * All components should inherit from CharacteristicComponentImpl or it's 
 * superclass, ACSComponentImpl, to remain  compatiable with ACS tools such 
 * as objexp (i.e., a GUI used to manipulate components).  This class also 
 * derives from POA_COUNTER::CounterConsumer which is a class automatically 
 * generated by CORBA from COUNTER's IDL file.
 * @version "@(#) $Id: CounterConsumerImpl.h,v 1.3 2008/10/07 09:41:42 cparedes Exp $"
 */
class CounterConsumerImpl: public virtual acscomponent::ACSComponentImpl,     //Component superclass
		  public POA_COUNTER::CounterConsumer    //CORBA servant stub
{    
  public:
    /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. Developers need
     * not be concerned with what a PortableServer does...just pass it to the superclass's
     * constructor.
     * @param name component's name. All components have a name associated with them so other 
     * components and clients can access them.
     */
    CounterConsumerImpl(
	       const ACE_CString& name,
	       maci::ContainerServices * containerServices);
    
    /**
     * Destructor
     */
    virtual ~CounterConsumerImpl();
    
    /* --------------------- [ CORBA interface ] ----------------------*/    
    /**
     * Implementation of IDL sendBlocks().
     * @throw ACSErrTypeCommon::CouldntPerformActionEx
     * @htmlonly
       <br><hr>
       @endhtmlonly
     */     
	virtual void getBlocks();
    /*
     * @throw ACSErrTypeCommon::CouldntPerformActionEx
     */
	virtual CORBA::Long waitTillDone();

	
	
  private:
	  int m_eventCount;
	  bool contFlag;
	  static void counterDataHandler(COUNTER::statusBlockEvent s, void *p);
	  nc::SimpleConsumer<COUNTER::statusBlockEvent> *m_CounterConsumer_p;
};
/*\@}*/
/*\@}*/

#endif /*!_COUNTER_CONSUMER_H*/



