'''
The Acspy package contains 90% of all ACS Python code. The subpackages
here contain APIs to:
- connect to components
- connect to standard CORBA services
- create components
- access notification channels
- access the ACS logging service
- etc

Basically everything that can be found in the C++ and Java APIs
can also be found here. The big exception to this is there no
XML support at the moment.
'''
__revision__ = "$Id: __init__.py,v 1.4 2012/03/07 17:42:14 acaproni Exp $"

import os
import string
from AcsutilPy import FindFile



# The Acspy python package is splitted in 2 ACS modules and this might cause 
# problems in the case the first part (from acspycommon) is in the $INTROOT
# and the other part is in the local folder.
#
# To fix this problem we need to add to Acspy.__path__ the folder where
# the missing part of Acspy is installed.

# The folder where Acspy is installed
pkgFolder=__path__[0]

# Check if Acspy packages generated by acspycommon are in the module (in pkgFolder)
files=os.listdir(pkgFolder)
if files.count('Common')==0:
    dir=FindFile.findFile("lib/python/site-packages/Acspy/Common")
    if dir[0]!='' and dir[3]:
        pathDir=string.rstrip(dir[0], '/Common')
        __path__.append(pathDir)
