/*
 * $Id: YesNoEditor.java,v 1.4 2002/09/09 08:09:19 lionel Exp $
 *
 * $Date: 2002/09/09 08:09:19 $
 * $Revision: 1.4 $
 * $Author: lionel $
 *
 * Copyright CERN, All Rights Reserved.
 */
package gpcourse;

/**
 * Editor that interprets a boolean as yes or no choice.
 * @version $Revision: 1.4 $  $Date: 2002/09/09 08:09:19 $
 * @author Vito Baggiolini
 */
public class YesNoEditor extends java.beans.PropertyEditorSupport  {
    
    /** the tags recognized by this editor */
    private static final String YES = "yes";
    private static final String NO = "no";
    
    
    /**
     * Sets the boolean property from a String.
     * This method interprets the string and converts it into a boolean
     */
    public void setAsText(String text) throws IllegalArgumentException {
        if (YES.equalsIgnoreCase(text)) {
            setValue(new Boolean(true));
        } else if (NO.equalsIgnoreCase(text)){
            setValue(new Boolean(false));
        } else {
            throw new IllegalArgumentException("not a recognized Yes/No string: " + text);
        }
    }
    
    /**
     * return the boolean property as Text.
     */
    public String getAsText() {
      return "";
    }
}