/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.actions.DisplayToolbarsAction;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.toolbars.ToolbarDnDListener;
import org.netbeans.core.windows.toolbars.ToolbarLayout;
import org.netbeans.core.windows.toolbars.ToolbarPanel;
import org.netbeans.core.windows.toolbars.ToolbarRow;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class ToolbarConfiguration
implements ToolbarPool.Configuration,
PropertyChangeListener {
    protected static final String TOOLBAR_DTD_WEB = "http://www.netbeans.org/dtds/toolbar.dtd";
    protected static final String TOOLBAR_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD toolbar//EN";
    protected static final Class TOOLBAR_PROCESSOR_CLASS = class$org$netbeans$core$windows$toolbars$ToolbarProcessor == null ? (class$org$netbeans$core$windows$toolbars$ToolbarProcessor = ToolbarConfiguration.class$("org.netbeans.core.windows.toolbars.ToolbarProcessor")) : class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    protected static final String TOOLBAR_ICON_BASE = "/org/netbeans/core/windows/toolbars/xmlToolbars";
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.core.windows.toolbars");
    private volatile long lastReload;
    protected static final String EXT_XML = "xml";
    protected static final String TAG_CONFIG = "Configuration";
    protected static final String TAG_ROW = "Row";
    protected static final String TAG_TOOLBAR = "Toolbar";
    protected static final String ATT_TOOLBAR_NAME = "name";
    protected static final String ATT_TOOLBAR_POSITION = "position";
    protected static final String ATT_TOOLBAR_VISIBLE = "visible";
    private static ToolbarPanel toolbarPanel;
    private static WeakHashMap confs2Names;
    private ToolbarLayout toolbarLayout;
    private ToolbarDnDListener toolbarListener;
    private WeakHashMap allToolbars;
    private Vector toolbarRows;
    private HashMap invisibleToolbars;
    private WeakHashMap waitingToolbars;
    private String configName;
    private String configDisplayName;
    private int prefWidth;
    PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarConfiguration;
    static /* synthetic */ Class class$org$netbeans$core$actions$DisplayToolbarsAction;

    public ToolbarConfiguration(String name, String displayName) {
        this.configName = name;
        this.configDisplayName = displayName;
        this.initInstance();
        confs2Names.put(this, name);
    }

    public ToolbarConfiguration(XMLDataObject xml) throws IOException {
        this(xml.getNodeDelegate().getName(), xml.getNodeDelegate().getDisplayName());
        this.readConfig(xml);
    }

    private void readConfig(XMLDataObject xml) throws IOException {
        Parser parser = XMLDataObject.createParser();
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        HandlerBase handler = new HandlerBase(){
            private ToolbarRow currentRow = null;

            public void startElement(String name, AttributeList amap) throws SAXException {
                if (ToolbarConfiguration.TAG_ROW.equals(name)) {
                    this.currentRow = new ToolbarRow(ToolbarConfiguration.this);
                    ToolbarConfiguration.this.addRow(this.currentRow);
                } else if (this.currentRow != null && ToolbarConfiguration.TAG_TOOLBAR.equals(name)) {
                    String visStr;
                    String tbname = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_NAME);
                    if (tbname == null || tbname.equals("")) {
                        return;
                    }
                    String posStr = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_POSITION);
                    Integer pos = null;
                    if (posStr != null) {
                        pos = new Integer(posStr);
                    }
                    Boolean vis = (visStr = amap.getValue(ToolbarConfiguration.ATT_TOOLBAR_VISIBLE)) != null ? Boolean.valueOf(visStr) : Boolean.TRUE;
                    ToolbarConfiguration.this.addToolbar(this.currentRow, ToolbarConfiguration.this.checkToolbarConstraints(tbname, pos, vis));
                }
            }

            public void endElement(String name) throws SAXException {
                if (ToolbarConfiguration.TAG_ROW.equals(name)) {
                    this.currentRow = null;
                }
            }
        };
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(xml.getPrimaryFile().getInputStream()));
        }
        catch (Exception saxe) {
            IOException ex = new IOException(saxe.toString());
            ErrorManager.getDefault().annotate((Throwable)ex, (Throwable)saxe);
            throw ex;
        }
        this.checkToolbarRows();
    }

    private void initInstance() {
        this.allToolbars = new WeakHashMap();
        this.waitingToolbars = new WeakHashMap();
        this.toolbarRows = new Vector();
        this.invisibleToolbars = new HashMap();
        this.toolbarListener = new ToolbarDnDListener(this);
    }

    static final String getBundleString(String bundleStr) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$toolbars$ToolbarConfiguration == null ? (class$org$netbeans$core$windows$toolbars$ToolbarConfiguration = ToolbarConfiguration.class$("org.netbeans.core.windows.toolbars.ToolbarConfiguration")) : class$org$netbeans$core$windows$toolbars$ToolbarConfiguration), (String)bundleStr);
    }

    public static final ToolbarConfiguration findConfiguration(String name) {
        Map.Entry curEntry = null;
        Iterator iter = confs2Names.entrySet().iterator();
        while (iter.hasNext()) {
            curEntry = iter.next();
            if (!name.equals((String)curEntry.getValue())) continue;
            return (ToolbarConfiguration)curEntry.getKey();
        }
        return null;
    }

    void addToolbar(ToolbarRow row, ToolbarConstraints tc) {
        if (tc == null) {
            return;
        }
        if (tc.isVisible()) {
            row.addToolbar(tc);
        } else {
            int rI = row == null ? this.toolbarRows.size() : this.toolbarRows.indexOf(row);
            this.invisibleToolbars.put(tc, new Integer(rI));
        }
        this.allToolbars.put(tc.getName(), tc);
    }

    ToolbarConstraints removeToolbar(String name) {
        ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.remove(name);
        if (tc.destroy()) {
            this.checkToolbarRows();
        }
        return tc;
    }

    void addRow(ToolbarRow row) {
        this.addRow(row, this.toolbarRows.size());
    }

    void addRow(ToolbarRow row, int index) {
        ToolbarRow prev = null;
        ToolbarRow next = null;
        try {
            prev = (ToolbarRow)this.toolbarRows.elementAt(index - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            next = (ToolbarRow)this.toolbarRows.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (prev != null) {
            prev.setNextRow(row);
        }
        row.setPrevRow(prev);
        row.setNextRow(next);
        if (next != null) {
            next.setPrevRow(row);
        }
        this.toolbarRows.insertElementAt(row, index);
        this.updateBounds(row);
    }

    void removeRow(ToolbarRow row) {
        ToolbarRow prev = row.getPrevRow();
        ToolbarRow next = row.getNextRow();
        if (prev != null) {
            prev.setNextRow(next);
        }
        if (next != null) {
            next.setPrevRow(prev);
        }
        this.toolbarRows.removeElement(row);
        this.updateBounds(next);
        this.revalidateWindow();
    }

    void updateBounds(ToolbarRow row) {
        while (row != null) {
            row.updateBounds();
            row = row.getNextRow();
        }
    }

    private static final ToolbarPool toolbarPool() {
        return ToolbarPool.getDefault();
    }

    void revalidateWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolbarConfiguration.this.doRevalidateWindow();
            }
        });
    }

    private void doRevalidateWindow() {
        ToolbarConfiguration.toolbarPanel().revalidate();
        Window w = SwingUtilities.windowForComponent((Component)ToolbarConfiguration.toolbarPool());
        if (w != null) {
            w.validate();
        }
    }

    int rowIndex(ToolbarRow row) {
        return this.toolbarRows.indexOf(row);
    }

    void updatePrefWidth() {
        Iterator it = ((AbstractList)this.toolbarRows).iterator();
        this.prefWidth = 0;
        while (it.hasNext()) {
            this.prefWidth = Math.max(this.prefWidth, ((ToolbarRow)it.next()).getPrefWidth());
        }
    }

    int getPrefWidth() {
        return this.prefWidth;
    }

    int getPrefHeight() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        ToolbarRow lastRow = (ToolbarRow)this.toolbarRows.lastElement();
        return this.getRowVertLocation(lastRow) + lastRow.getPreferredHeight();
    }

    void checkToolbarRows() {
        Object[] rows = this.toolbarRows.toArray();
        int i = rows.length - 1;
        while (i >= 0) {
            ToolbarRow row = (ToolbarRow)rows[i];
            if (row.isEmpty()) {
                this.removeRow(row);
            }
            --i;
        }
    }

    int getRowCount() {
        return this.toolbarRows.size();
    }

    ToolbarConstraints getToolbarConstraints(String name) {
        return (ToolbarConstraints)this.allToolbars.get(name);
    }

    ToolbarConstraints checkToolbarConstraints(String name, Integer position, Boolean visible) {
        ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(name);
        if (tc == null) {
            tc = new ToolbarConstraints(this, name, position, visible);
        } else {
            tc.checkNextPosition(position, visible);
        }
        return tc;
    }

    boolean checkConfigurationOver() {
        String name;
        boolean change = false;
        Object[] waNas = ((AbstractMap)this.waitingToolbars).keySet().toArray();
        Object[] names = ((AbstractMap)this.allToolbars).keySet().toArray();
        int i = 0;
        while (i < waNas.length) {
            name = (String)waNas[i];
            if (ToolbarConfiguration.toolbarPool().findToolbar(name) != null) {
                ToolbarConstraints tc = (ToolbarConstraints)this.waitingToolbars.remove(name);
                this.allToolbars.put(name, tc);
                this.addInvisible(tc);
                change = true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < names.length) {
            name = (String)names[i2];
            if (ToolbarConfiguration.toolbarPool().findToolbar(name) == null) {
                ToolbarConstraints tc = this.removeToolbar(name);
                this.waitingToolbars.put(name, tc);
                this.invisibleToolbars.put(tc, new Integer(tc.rowIndex()));
                change = true;
            }
            ++i2;
        }
        return change;
    }

    void removeVisible(ToolbarConstraints tc) {
        this.invisibleToolbars.put(tc, new Integer(tc.rowIndex()));
        if (tc.destroy()) {
            this.checkToolbarRows();
        }
        tc.setVisible(false);
    }

    void addInvisible(ToolbarConstraints tc) {
        int rC = this.toolbarRows.size();
        int pos = (Integer)this.invisibleToolbars.remove(tc);
        tc.setVisible(true);
        int i = pos;
        while (i < pos + tc.getRowCount()) {
            this.getRow(i).addToolbar(tc, tc.getPosition());
            ++i;
        }
        if (rC != this.toolbarRows.size()) {
            this.revalidateWindow();
        }
    }

    ToolbarRow getRow(int rI) {
        ToolbarRow row;
        int s = this.toolbarRows.size();
        if (rI < 0) {
            row = new ToolbarRow(this);
            this.addRow(row, 0);
        } else if (rI >= s) {
            row = new ToolbarRow(this);
            this.addRow(row);
        } else {
            row = (ToolbarRow)this.toolbarRows.elementAt(rI);
        }
        return row;
    }

    ToolbarRow createLastRow() {
        return this.getRow(this.toolbarRows.size());
    }

    void reactivatePanel(boolean someBarRemoved, boolean writeAtAll) {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] tbs = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow newRow = null;
        boolean someBarAdded = false;
        int i = 0;
        while (i < tbs.length) {
            Toolbar tb = tbs[i];
            String name = tb.getName();
            ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(name);
            if (tc == null) {
                if (newRow == null) {
                    newRow = this.createLastRow();
                }
                tc = new ToolbarConstraints(this, name, null, Boolean.TRUE);
                this.addToolbar(newRow, tc);
                someBarAdded = true;
            }
            ToolbarConfiguration.toolbarPanel().add((Component)tb, tc);
            ++i;
        }
        this.revalidateWindow();
        if (!writeAtAll || someBarRemoved || someBarAdded) {
            // empty if block
        }
    }

    boolean isImportantActivateComponent() {
        Toolbar[] toolbars;
        Object[] names = ((AbstractMap)this.allToolbars).keySet().toArray();
        if (names.length != (toolbars = ToolbarConfiguration.toolbarPool().getToolbars()).length) {
            return true;
        }
        return !this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration());
    }

    void reflectChanges() {
        try {
            this.writeDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Component activate() {
        return this.activate(this.isImportantActivateComponent(), true);
    }

    private Component activate(boolean isImportant, boolean writeAtAll) {
        ToolbarConfiguration.toolbarPool().setToolbarsListener((Toolbar.DnDListener)this.toolbarListener);
        boolean someBarRemoved = this.checkConfigurationOver();
        if (isImportant || someBarRemoved) {
            if (this.toolbarLayout == null) {
                this.toolbarLayout = new ToolbarLayout(this);
            }
            ToolbarConfiguration.toolbarPanel().setLayout(this.toolbarLayout);
            this.reactivatePanel(someBarRemoved, writeAtAll);
        }
        return ToolbarConfiguration.toolbarPanel();
    }

    public String getName() {
        return this.configName;
    }

    public String getDisplayName() {
        return this.configDisplayName;
    }

    public JPopupMenu getContextMenu() {
        JMenuItem mi;
        JPopupMenuPlus menu = new JPopupMenuPlus();
        Iterator<Object> it = Arrays.asList(ToolbarPool.getDefault().getToolbars()).iterator();
        while (it.hasNext()) {
            final Toolbar tb = it.next();
            final ToolbarConstraints tc = (ToolbarConstraints)this.allToolbars.get(tb.getName());
            JCheckBoxMenuItem mi2 = new JCheckBoxMenuItem(tb.getDisplayName(), tc.isVisible());
            mi2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ToolbarConfiguration.this.setToolbarVisible(tb, !tc.isVisible());
                }
            });
            menu.add(mi2);
        }
        menu.add(new JPopupMenu.Separator());
        it = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
        ButtonGroup bg = new ButtonGroup();
        String current = ToolbarPool.getDefault().getConfiguration();
        while (it.hasNext()) {
            final String name = (String)it.next();
            mi = new JRadioButtonMenuItem(ToolbarConfiguration.findConfiguration(name).getDisplayName(), name.compareTo(current) == 0);
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WorkspaceImpl curWs = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
                    curWs.setToolbarConfigName(name);
                }
            });
            bg.add(mi);
            menu.add(mi);
        }
        menu.add(new JPopupMenu.Separator());
        JMenuItem menuItem = new JMenuItem(((DisplayToolbarsAction)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$DisplayToolbarsAction == null ? (class$org$netbeans$core$actions$DisplayToolbarsAction = ToolbarConfiguration.class$("org.netbeans.core.actions.DisplayToolbarsAction")) : class$org$netbeans$core$actions$DisplayToolbarsAction), (boolean)true)).getName());
        menuItem.addActionListener(new ActionListener(){
            static /* synthetic */ Class class$org$netbeans$core$actions$DisplayToolbarsAction;

            public void actionPerformed(ActionEvent event) {
                ((DisplayToolbarsAction)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$DisplayToolbarsAction == null ? (class$org$netbeans$core$actions$DisplayToolbarsAction = 6.class$("org.netbeans.core.actions.DisplayToolbarsAction")) : class$org$netbeans$core$actions$DisplayToolbarsAction), (boolean)true)).performAction();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        menu.add(menuItem);
        mi = new JMenuItem(ToolbarConfiguration.getBundleString("PROP_saveAs"));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s;
                NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(ToolbarConfiguration.getBundleString("PROP_saveLabel"), ToolbarConfiguration.getBundleString("PROP_saveDialog"));
                il.setInputText(ToolbarConfiguration.getBundleString("PROP_saveName"));
                Object ok = DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
                if (ok == NotifyDescriptor.OK_OPTION && (s = il.getInputText()).length() != 0) {
                    try {
                        String newName = il.getInputText();
                        if (ToolbarConfiguration.this.tryWriteDocument(newName)) {
                            WorkspaceImpl curWs = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
                            curWs.setToolbarConfigName(newName);
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
        menu.add(mi);
        return menu;
    }

    public void setToolbarVisible(Toolbar tb, boolean b) {
        ToolbarConstraints tc = this.getToolbarConstraints(tb.getName());
        if (b) {
            this.addInvisible(tc);
        } else {
            this.removeVisible(tc);
        }
        tb.setVisible(b);
        this.reflectChanges();
        this.firePropertyChange();
    }

    public boolean isToolbarVisible(Toolbar tb) {
        ToolbarConstraints tc = this.getToolbarConstraints(tb.getName());
        return tc.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private void firePropertyChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("constraints", null, null);
        }
    }

    boolean tryWriteDocument(String cn) throws IOException {
        FileObject tbFO = NbPlaces.getDefault().toolbars().getPrimaryFile();
        FileObject newFO = tbFO.getFileObject(cn, EXT_XML);
        if (Utilities.isWindows() && newFO == null) {
            FileObject[] children = tbFO.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].getExt().equals(EXT_XML) && cn.toLowerCase().equals(children[i].getName().toLowerCase())) {
                    newFO = children[i];
                    cn = children[i].getName();
                }
                ++i;
            }
        }
        if (newFO != null) {
            NotifyDescriptor.Confirmation replaceD = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(ToolbarConfiguration.getBundleString("MSG_replaceConfiguration"), cn), 2, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)replaceD);
            if (replaceD.getValue() != NotifyDescriptor.OK_OPTION) {
                return false;
            }
        }
        this.writeDocument(cn);
        return true;
    }

    public void writeDocument() throws IOException {
        this.writeDocument(this.configName);
    }

    private void writeDocument(final String cn) throws IOException {
        ERR.log("writeDocument: " + cn);
        WritableToolbarConfiguration wtc = new WritableToolbarConfiguration(this.toolbarRows, this.invisibleToolbars);
        final StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>\n\n");
        sb.append("<!DOCTYPE ").append(TAG_CONFIG).append(" PUBLIC \"").append(TOOLBAR_DTD_PUBLIC_ID).append("\" \"http://www.netbeans.org/dtds/toolbar.dtd\">\n\n").append(wtc.toString());
        final FileObject tbFO = NbPlaces.getDefault().toolbars().getPrimaryFile();
        FileSystem tbFS = tbFO.getFileSystem();
        tbFS.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileLock lock = null;
                OutputStream os = null;
                FileObject xmlFO = tbFO.getFileObject(cn, ToolbarConfiguration.EXT_XML);
                if (xmlFO == null) {
                    xmlFO = tbFO.createData(cn, ToolbarConfiguration.EXT_XML);
                }
                try {
                    lock = xmlFO.lock();
                    os = xmlFO.getOutputStream(lock);
                    OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
                    writer.write(sb.toString());
                    ((Writer)writer).close();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                    ERR.log("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                    if (os != null) {
                        os.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    throw throwable;
                }
                ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                ERR.log("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                if (os != null) {
                    os.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        });
        ERR.log("writeDocument finished");
    }

    private static final synchronized ToolbarPanel toolbarPanel() {
        if (toolbarPanel == null) {
            toolbarPanel = new ToolbarPanel();
        }
        return toolbarPanel;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (!"document".equals(ev.getPropertyName())) {
            return;
        }
        this.updateConfiguration((XMLDataObject)ev.getSource());
    }

    void updateConfiguration(final XMLDataObject xmlDataObject) {
        long mod = xmlDataObject.getPrimaryFile().lastModified().getTime();
        ERR.log("Checking modified: " + this.lastReload);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ToolbarConfiguration.this.initInstance();
                    ToolbarConfiguration.this.readConfig(xmlDataObject);
                    ToolbarConfiguration.this.checkConfigurationOver();
                    if (ToolbarConfiguration.this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration())) {
                        ERR.log("Activating the configuration");
                        ToolbarConfiguration.this.activate(true, false);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        });
    }

    int getRowVertLocation(ToolbarRow row) {
        int index = this.rowIndex(row);
        int vertLocation = index * 1;
        Iterator iter = ((AbstractList)this.toolbarRows).iterator();
        int i = 0;
        while (i < index) {
            vertLocation += ((ToolbarRow)iter.next()).getPreferredHeight();
            ++i;
        }
        return vertLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        confs2Names = new WeakHashMap(10);
    }

    class WritableToolbarConfiguration {
        Vector rows;

        public WritableToolbarConfiguration(Vector rs, Map iv) {
            this.initRows(rs);
            this.initInvisible(iv);
            this.removeEmptyRows();
        }

        void initRows(Vector rs) {
            this.rows = new Vector();
            Iterator it = ((AbstractList)rs).iterator();
            while (it.hasNext()) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow((ToolbarRow)it.next()));
            }
        }

        void initInvisible(Map iv) {
            Iterator it = iv.keySet().iterator();
            while (it.hasNext()) {
                int row;
                ToolbarConstraints tc = (ToolbarConstraints)it.next();
                int i = row = ((Integer)iv.get(tc)).intValue();
                while (i < row + tc.getRowCount()) {
                    this.getRow(i).addToolbar(tc);
                    ++i;
                }
            }
        }

        void removeEmptyRows() {
            int i = this.rows.size() - 1;
            while (i >= 0) {
                ToolbarRow.WritableToolbarRow row = (ToolbarRow.WritableToolbarRow)this.rows.elementAt(i);
                if (row.isEmpty()) {
                    this.rows.removeElement(row);
                }
                --i;
            }
        }

        ToolbarRow.WritableToolbarRow getRow(int r) {
            try {
                return (ToolbarRow.WritableToolbarRow)this.rows.elementAt(r);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow());
                return this.getRow(r);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            Iterator it = ((AbstractList)this.rows).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
            }
            sb.append("</").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            return sb.toString();
        }
    }
}

