/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.io.IOException;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.TCRefDO;
import org.netbeans.core.windows.layers.WindowManagerData;
import org.netbeans.core.windows.layers.WorkspaceData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WSLoader
extends MultiFileLoader {
    public static final String WINDOWMANAGER_EXT = "wswmgr";
    public static final String WORKSPACE_EXT = "wswksp";
    public static final String MODE_EXT = "wsmode";
    public static final String TCREF_EXT = "wstcref";
    private static final long serialVersionUID = -1896202984894986349L;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$WSLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public WSLoader() {
        this("org.netbeans.core.windows.layers.WindowManagerData");
    }

    public WSLoader(String representationClassName) {
        super(representationClassName);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WSLoader == null ? (class$org$netbeans$core$windows$layers$WSLoader = WSLoader.class$("org.netbeans.core.windows.layers.WSLoader")) : class$org$netbeans$core$windows$layers$WSLoader), (String)"PROP_WSLoader_Name");
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        if (primaryFile.isFolder()) {
            return new FileEntry.Folder(obj, primaryFile);
        }
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj, secondaryFile);
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        if (primaryFile.hasExt(TCREF_EXT)) {
            return new TCRefDO(primaryFile, this);
        }
        FileObject siblink = primaryFile.getParent().getFileObject(primaryFile.getNameExt(), MODE_EXT);
        if (siblink != null) {
            return new ModeData(primaryFile, siblink, this);
        }
        siblink = primaryFile.getParent().getFileObject(primaryFile.getNameExt(), WORKSPACE_EXT);
        if (siblink != null) {
            return new WorkspaceData(primaryFile, siblink, this);
        }
        if (primaryFile.getParent().getFileObject(primaryFile.getName(), WINDOWMANAGER_EXT) != null) {
            return new WindowManagerData(primaryFile, this);
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        FileObject windowmanagerFolder;
        FileObject workspaceFolder;
        FileObject modeFolder;
        try {
            FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
            if (fo.getFileSystem() != sfs) {
                return null;
            }
        }
        catch (FileStateInvalidException e) {
            return null;
        }
        if (fo.hasExt(TCREF_EXT)) {
            return fo;
        }
        FileObject parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        if (fo.hasExt(MODE_EXT) && (modeFolder = parent.getFileObject(fo.getName())) != null && modeFolder.isFolder()) {
            return modeFolder;
        }
        if (fo.isFolder() && parent.getFileObject(fo.getNameExt(), MODE_EXT) != null) {
            return fo;
        }
        if (fo.hasExt(WORKSPACE_EXT) && (workspaceFolder = parent.getFileObject(fo.getName())) != null && workspaceFolder.isFolder()) {
            return workspaceFolder;
        }
        if (fo.isFolder() && parent.getFileObject(fo.getNameExt(), WORKSPACE_EXT) != null) {
            return fo;
        }
        if (fo.hasExt(WINDOWMANAGER_EXT) && (windowmanagerFolder = parent.getFileObject(fo.getName())) != null && windowmanagerFolder.isFolder()) {
            return windowmanagerFolder;
        }
        if (fo.isFolder() && parent.getFileObject(fo.getNameExt(), WINDOWMANAGER_EXT) != null) {
            return fo;
        }
        return null;
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = WSLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = WSLoader.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = WSLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = WSLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = WSLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = WSLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = WSLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = WSLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = WSLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), SystemAction.get((Class)(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = WSLoader.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = WSLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = WSLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

