/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

final class NbURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private Lookup.Result r = null;
    private URLStreamHandlerFactory[] handlers = null;
    static /* synthetic */ Class class$java$net$URLStreamHandlerFactory;

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandlerFactory[] _handlers;
        if (protocol.equals("jar") || protocol.equals("file") || protocol.equals("http") || protocol.equals("resource")) {
            return null;
        }
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            if (this.r == null) {
                this.r = Lookup.getDefault().lookup(new Lookup.Template(class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = NbURLStreamHandlerFactory.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory));
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            _handlers = (URLStreamHandlerFactory[])this.handlers.clone();
        }
        int i = 0;
        while (i < _handlers.length) {
            URLStreamHandler h = _handlers[i].createURLStreamHandler(protocol);
            if (h != null) {
                return h;
            }
            ++i;
        }
        return null;
    }

    public void resultChanged(LookupEvent ev) {
        Collection c = this.r.allInstances();
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            this.handlers = c.toArray(new URLStreamHandlerFactory[c.size()]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class NbResourceStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
        public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

        public URLConnection openConnection(URL u) throws IOException {
            if (u.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
                return new Connection(u, false);
            }
            if (u.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
                return new Connection(u, true);
            }
            throw new IOException("Bad protocol: " + u.getProtocol());
        }

        private static class Connection
        extends URLConnection {
            private final boolean localized;
            private URLConnection real;
            private IOException exception = null;
            static /* synthetic */ Class class$java$lang$ClassLoader;
            static /* synthetic */ Class class$org$netbeans$core$NbURLStreamHandlerFactory;

            public Connection(URL u, boolean localized) {
                super(u);
                this.localized = localized;
            }

            public synchronized void connect() throws IOException {
                if (this.exception != null) {
                    IOException e = this.exception;
                    this.exception = null;
                    throw e;
                }
                if (!this.connected) {
                    URL target;
                    String resource = this.url.getFile();
                    if (resource.startsWith("/")) {
                        resource = resource.substring(1);
                    }
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Connection.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    if (this.localized) {
                        String basename;
                        String ext;
                        int index = resource.lastIndexOf(46);
                        if (index != -1) {
                            ext = resource.substring(index + 1);
                            basename = resource.substring(0, index).replace('/', '.');
                        } else {
                            ext = null;
                            basename = resource.replace('/', '.');
                        }
                        try {
                            target = NbBundle.getLocalizedFile((String)basename, (String)ext, (Locale)Locale.getDefault(), (ClassLoader)loader);
                        }
                        catch (MissingResourceException mre) {
                            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(NbBundle.getMessage((Class)(class$org$netbeans$core$NbURLStreamHandlerFactory == null ? (class$org$netbeans$core$NbURLStreamHandlerFactory = Connection.class$("org.netbeans.core.NbURLStreamHandlerFactory")) : class$org$netbeans$core$NbURLStreamHandlerFactory), (String)"EXC_nbres_cannot_connect", (Object)this.url)), (Throwable)mre);
                        }
                    } else {
                        target = loader.getResource(resource);
                        if (target == null) {
                            throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$core$NbURLStreamHandlerFactory == null ? (class$org$netbeans$core$NbURLStreamHandlerFactory = Connection.class$("org.netbeans.core.NbURLStreamHandlerFactory")) : class$org$netbeans$core$NbURLStreamHandlerFactory), (String)"EXC_nbres_cannot_connect", (Object)this.url));
                        }
                    }
                    this.real = target.openConnection();
                    this.real.connect();
                    this.connected = true;
                }
            }

            private void tryToConnect() {
                if (this.connected || this.exception != null) {
                    return;
                }
                try {
                    this.connect();
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }

            public String getHeaderField(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(n);
                }
                return null;
            }

            public String getHeaderFieldKey(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderFieldKey(n);
                }
                return null;
            }

            public String getHeaderField(String key) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(key);
                }
                return null;
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.real.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.real.getOutputStream();
            }

            public String getContentType() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentType();
                }
                return "application/octet-stream";
            }

            public int getContentLength() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentLength();
                }
                return 0;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    public static final class Standard
    implements URLStreamHandlerFactory {
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("nbfs")) {
                return FileUtil.nbfsURLStreamHandler();
            }
            if (protocol.equals("nbres") || protocol.equals("nbresloc")) {
                return new NbResourceStreamHandler();
            }
            return null;
        }
    }
}

