/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.CoronaDialog;
import org.netbeans.core.DataSystem;
import org.netbeans.core.awt.ButtonBar;
import org.netbeans.core.awt.ButtonBarButton;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class FileSelector
extends CoronaDialog
implements PropertyChangeListener {
    static final long serialVersionUID = 6524404012203099065L;
    private ExplorerManager manager;
    private BeanTreeView tree;
    private Node[] nodes;
    boolean cancelFlag;
    private boolean accepted;
    private ButtonBarButton okButton;
    private ButtonBarButton cancelButton;
    private NodeAcceptor acceptor;
    static /* synthetic */ Class class$org$netbeans$core$FileSelector;

    FileSelector(String title, String rootLabel, Node root, NodeAcceptor acceptor, Component top) {
        super((Frame)null);
        this.acceptor = acceptor;
        ExplorerPanel ep = new ExplorerPanel();
        this.getCustomPane().setLayout(new BorderLayout());
        this.getCustomPane().add((Component)ep, "Center");
        this.manager = ep.getExplorerManager();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileSelector.this.cancelFlag = true;
                ((Component)FileSelector.this).setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelector.this.buttonPressed(1);
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector));
        this.okButton = new ButtonBarButton(bundle.getString("CTL_FileSelectorOkButton"));
        this.cancelButton = new ButtonBarButton(bundle.getString("CTL_FileSelectorCancelButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription("ACSD_FileSelectorOkButton");
        this.cancelButton.getAccessibleContext().setAccessibleDescription("ACSD_FileSelectorCancelButton");
        this.getButtonBar().setButtons(new ButtonBarButton[0], new ButtonBarButton[]{this.okButton, this.cancelButton});
        this.getRootPane().setDefaultButton(this.okButton);
        this.setTitle(title);
        this.manager.setRootContext(root);
        ep.setLayout(new BorderLayout(0, 5));
        ep.setBorder(new EmptyBorder(12, 12, 0, 11));
        try {
            Node[] roots;
            if (root instanceof DataSystem && (roots = root.getChildren().getNodes()).length > 0) {
                final JComboBox<Node> combo = new JComboBox<Node>(roots);
                combo.setRenderer(new FileSelectRenderer());
                combo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Node o = (Node)combo.getSelectedItem();
                        FileSelector.this.manager.setRootContext(o);
                    }
                });
                combo.getAccessibleContext().setAccessibleDescription("ACSD_FileSelectorComboBox");
                this.manager.setSelectedNodes(new Node[]{roots[0]});
                JPanel comboPanel = new JPanel();
                comboPanel.setLayout(new BorderLayout(5, 0));
                JLabel label = new JLabel(rootLabel.replace('&', ' '));
                label.setDisplayedMnemonic(rootLabel.charAt(rootLabel.indexOf(38) + 1));
                label.setLabelFor(combo);
                comboPanel.add((Component)label, "West");
                comboPanel.add(combo, "Center");
                ep.add((Component)comboPanel, "North");
            } else {
                this.manager.setSelectedNodes(new Node[]{root});
                JLabel label = new JLabel(rootLabel.replace('&', ' '));
                ep.add((Component)label, "North");
            }
        }
        catch (PropertyVetoException pve) {
            throw new IllegalStateException(pve.getMessage());
        }
        this.tree = new BeanTreeView();
        this.tree.setPopupAllowed(false);
        this.tree.setDefaultActionAllowed(false);
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSN_FileSelectorTreeView"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSD_FileSelectorDialog"));
        ep.add((Component)this.tree, "Center");
        if (top != null) {
            ep.add(top, "South");
        }
        this.cancelFlag = false;
        this.accepted = true;
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.center();
        if (top != null) {
            top.requestFocus();
        }
        if (acceptor.acceptNodes(this.manager.getSelectedNodes())) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("selectedNodes")) {
            if (this.acceptor.acceptNodes(this.manager.getSelectedNodes())) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = Math.max(dim.height, Utilities.getUsableScreenBounds().height / 2);
        return dim;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    void enableButton() {
        this.accepted = true;
        this.okButton.setEnabled(true);
    }

    void disableButton() {
        this.accepted = false;
        this.okButton.setEnabled(false);
    }

    protected void buttonPressed(ButtonBar.ButtonBarEvent evt) {
        int index = this.getButtonBar().getButtonIndex(evt.getButton());
        this.buttonPressed(index);
    }

    private void buttonPressed(int index) {
        switch (index) {
            case 0: {
                if (this.accepted) {
                    this.nodes = this.manager.getSelectedNodes();
                    break;
                }
                return;
            }
            case 1: {
                this.cancelFlag = true;
            }
        }
        this.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FileSelectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -7071698027341621636L;
        protected static Border hasFocusBorder;
        protected static Border noFocusBorder;

        public FileSelectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
            hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof Node)) {
                return this;
            }
            Node node = (Node)value;
            ImageIcon icon = new ImageIcon(node.getIcon(1));
            this.setIcon(icon);
            this.setText(node.getDisplayName());
            if (isSelected) {
                super.setBackground(UIManager.getColor("List.selectionBackground"));
                super.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                super.setBackground(list.getBackground());
                super.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

