/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.NameDynAnyPair;
import org.omg.DynamicAny.NameValuePair;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.dynany.DynAnyImpl;
import org.openorb.CORBA.typecode.TypeCodeBase;

class DynStructImpl
extends DynAnyImpl
implements DynStruct {
    private int m_current;
    private DynAny[] m_members;
    private final TypeCode m_baseType;

    public DynStructImpl(DynAnyFactory factory, ORB orb, TypeCode type) {
        super(factory, orb);
        this.m_type = type;
        this.m_baseType = ((TypeCodeBase)this.m_type)._base_type();
        this.m_members = this.create_dyn_any_graph(type);
        if (this.m_members.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
    }

    public void assign(DynAny dyn_any) throws TypeMismatch {
        if (!dyn_any.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        this.m_members = ((DynStructImpl)dyn_any).copy_dyn_any_graph(((DynStructImpl)dyn_any).m_members);
    }

    public void from_any(org.omg.CORBA.Any value) throws InvalidValue, TypeMismatch {
        if (!value.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        InputStream stream = value.create_input_stream();
        this.stream_to_dyn_any_graph(this.m_members, stream);
    }

    public org.omg.CORBA.Any to_any() {
        org.omg.CORBA.Any any = this.m_orb.create_any();
        any.type(this.m_type);
        OutputStream stream = any.create_output_stream();
        this.dyn_any_graph_to_stream(this.m_members, stream);
        return any;
    }

    public void destroy() {
        this.m_members = null;
        System.gc();
    }

    public DynAny copy() {
        DynStructImpl dyn_st = new DynStructImpl(this.m_factory, this.m_orb, this.m_type);
        try {
            dyn_st.assign(this);
        }
        catch (TypeMismatch ex) {
            this.handleTypeMismatchException(ex);
        }
        return dyn_st;
    }

    public DynAny current_component() throws TypeMismatch {
        if (this.m_members.length == 0) {
            throw new TypeMismatch();
        }
        if (this.m_current == -1) {
            return null;
        }
        return this.m_members[this.m_current];
    }

    public boolean next() {
        ++this.m_current;
        if (this.m_current < this.m_members.length) {
            if (this.m_members[this.m_current] != null) {
                this.m_any = (Any)this.m_members[this.m_current].to_any();
            }
            return true;
        }
        this.invalidateCurrent();
        return false;
    }

    public boolean seek(int index) {
        if (index < 0) {
            this.invalidateCurrent();
            return false;
        }
        if (index < this.m_members.length) {
            this.m_current = index;
            if (this.m_members[this.m_current] != null) {
                this.m_any = (Any)this.m_members[this.m_current].to_any();
            }
            return true;
        }
        this.invalidateCurrent();
        return false;
    }

    public void rewind() {
        this.seek(0);
    }

    public int component_count() {
        return this.m_members.length;
    }

    public String current_member_name() throws InvalidValue, TypeMismatch {
        if (this.m_current < 0 || this.m_current >= this.m_members.length) {
            throw new InvalidValue();
        }
        try {
            return this.m_baseType.member_name(this.m_current);
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
        throw new IllegalStateException();
    }

    public TCKind current_member_kind() throws InvalidValue, TypeMismatch {
        if (this.m_current < 0 || this.m_current >= this.m_members.length) {
            throw new InvalidValue();
        }
        try {
            return this.m_baseType.member_type(this.m_current).kind();
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
        throw new IllegalStateException();
    }

    public NameValuePair[] get_members() {
        NameValuePair[] list = new NameValuePair[this.m_members.length];
        try {
            int i = 0;
            while (i < this.m_members.length) {
                list[i] = new NameValuePair();
                list[i].id = this.m_baseType.member_name(i);
                list[i].value = this.m_members[i].to_any();
                ++i;
            }
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
        return list;
    }

    public void set_members(NameValuePair[] value) throws InvalidValue, TypeMismatch {
        if (value.length != this.m_members.length) {
            throw new InvalidValue();
        }
        if (value.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
        try {
            int i = 0;
            while (i < this.m_baseType.member_count()) {
                if (value[i].id.equals("") ? !value[i].value.type().equivalent(this.m_baseType.member_type(i)) : !this.m_baseType.member_name(i).equals(value[i].id)) {
                    throw new TypeMismatch();
                }
                this.m_members[i].from_any(value[i].value);
                ++i;
            }
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
    }

    public NameDynAnyPair[] get_members_as_dyn_any() {
        NameDynAnyPair[] list = new NameDynAnyPair[this.m_members.length];
        try {
            int i = 0;
            while (i < this.m_members.length) {
                list[i] = new NameDynAnyPair();
                list[i].id = this.m_baseType.member_name(i);
                list[i].value = this.m_members[i];
                ++i;
            }
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
        return list;
    }

    public void set_members_as_dyn_any(NameDynAnyPair[] value) throws TypeMismatch, InvalidValue {
        if (value.length != this.m_members.length) {
            throw new InvalidValue();
        }
        if (value.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
        try {
            int i = 0;
            while (i < this.m_baseType.member_count()) {
                if (value[i].id.equals("") ? !value[i].value.type().equivalent(this.m_baseType.member_type(i)) : !this.m_baseType.member_name(i).equals(value[i].id)) {
                    throw new TypeMismatch();
                }
                this.m_members[i] = value[i].value;
                ++i;
            }
        }
        catch (BadKind ex) {
            this.handleBadKindException(ex);
        }
        catch (Bounds ex) {
            this.handleBoundsException(ex);
        }
    }

    private void invalidateCurrent() {
        this.m_current = -1;
        this.m_any = null;
    }

    private final void handleBadKindException(BadKind e) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("BadKind", (Throwable)e);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }

    private final void handleBoundsException(Bounds e) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Bounds", (Throwable)e);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }

    private final void handleTypeMismatchException(TypeMismatch e) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("TypeMismatch", (Throwable)e);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }
}

