/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowContextDefaultImpl;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.internal.core.MWEPlugin;
import org.eclipse.emf.mwe.internal.core.Workflow;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowFactory;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowRunner {
    private static final String PARAM = "p";
    private static final String MONITOR = "m";
    private static final String ANT = "a";
    private static final String CMDL = "c";
    private WorkflowContextDefaultImpl wfContext = new WorkflowContextDefaultImpl();
    private ProgressMonitor monitor;
    private static final Log logger = LogFactory.getLog(WorkflowRunner.class);
    private Map<String, String> params;
    private Workflow workflow;

    public static void main(String[] args) {
        URL wfUrl;
        Method method;
        new Object();
        Options options = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"className,moreArgs");
        OptionBuilder.withDescription((String)"the name of a class that implements ProgressMonitor. More arguments can be appended that will be injected to the monitor, if it has a init(String[] args) method.");
        OptionBuilder.withLongOpt((String)"monitorClass");
        OptionBuilder.withValueSeparator((char)',');
        options.addOption(OptionBuilder.create((String)MONITOR));
        OptionBuilder.withLongOpt((String)"ant");
        OptionBuilder.withDescription((String)"must be set when using in Ant context");
        options.addOption(OptionBuilder.create((String)ANT));
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withDescription((String)"external property that is handled as workflow property");
        OptionBuilder.hasArgs();
        Option paramOption = OptionBuilder.create((String)PARAM);
        paramOption.setLongOpt("param");
        options.addOption(paramOption);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"className");
        OptionBuilder.withDescription((String)"the name of a class that implements a public method 'public void processCmdLine(String[] cmdLineArgs, Map paramsToUseInWorkflow, WorkflowContext ctx)'.");
        OptionBuilder.withLongOpt((String)"cmdLineProcessor");
        options.addOption(OptionBuilder.create((String)CMDL));
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Parsing arguments failed.  Reason: " + exp.getMessage());
            WorkflowRunner.wrongCall(options);
            return;
        }
        WorkflowRunner runner = new WorkflowRunner();
        HashMap<String, String> params = new HashMap();
        String wfFile = null;
        String[] monitorOptValues = line.getOptionValues(MONITOR);
        if (line.hasOption(CMDL)) {
            try {
                ArrayList<String> unprocessedArgs = new ArrayList<String>();
                int i = 0;
                while (i < args.length) {
                    String arg = args[i];
                    if (arg.equals("-c") || arg.equals("--cmdLineProcessor")) {
                        ++i;
                    } else if (arg.equals("-m") || arg.equals("--monitorClass")) {
                        i += monitorOptValues.length;
                    } else if (arg.endsWith(".oaw") || arg.endsWith(".mwe")) {
                        if (wfFile != null) {
                            System.err.println("Workflow file already defined as '" + wfFile + "'!");
                            System.exit(1);
                        }
                        wfFile = arg;
                    } else {
                        unprocessedArgs.add(arg);
                    }
                    ++i;
                }
                Class<?> cmdLineProcessor = ResourceLoaderFactory.createResourceLoader().loadClass(line.getOptionValue(CMDL));
                if (cmdLineProcessor == null) {
                    System.err.println("cannot find class '" + line.getOptionValue(CMDL) + "' for command line processing.");
                    System.exit(1);
                    return;
                }
                method = cmdLineProcessor.getMethod("processCmdLine", String[].class, Map.class, WorkflowContext.class);
                method.invoke(cmdLineProcessor.newInstance(), unprocessedArgs.toArray(new String[0]), params, runner.getContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            params = WorkflowRunner.resolveParams(line.getOptionValues(PARAM));
            wfFile = line.getArgs()[0];
        }
        if (wfFile == null || !wfFile.endsWith(".oaw") && !wfFile.endsWith(".mwe")) {
            WorkflowRunner.wrongCall(options);
            return;
        }
        ProgressMonitor monitor = null;
        if (monitorOptValues != null) {
            try {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(monitorOptValues[0]);
                if (clazz == null) {
                    throw new ClassNotFoundException("Didn't find class " + monitorOptValues[0]);
                }
                monitor = (ProgressMonitor)clazz.newInstance();
                method = monitor.getClass().getMethod("init", String[].class);
                if (method != null) {
                    method.invoke((Object)monitor, new Object[]{monitorOptValues});
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (line.hasOption(ANT)) {
                    System.exit(1);
                }
                return;
            }
        }
        int index = 0;
        do {
            if ((wfUrl = ResourceLoaderFactory.createResourceLoader().getResource(wfFile)) != null || (index = wfFile.indexOf(47)) < 0) continue;
            wfFile = wfFile.substring(index + 1);
        } while (wfUrl == null && index >= 0);
        if (wfUrl == null) {
            logger.error((Object)("can't find the workflow file '" + line.getArgs()[0] + "' in the current class path"));
            if (line.hasOption(ANT)) {
                System.exit(1);
            }
            return;
        }
        boolean success = runner.run(wfFile, monitor, params, null);
        if (!success && line.hasOption(ANT)) {
            System.exit(1);
        }
    }

    private static Map<String, String> resolveParams(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (args == null) {
            return params;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] string = element.split("=", 2);
            if (string.length != 2) {
                throw new IllegalArgumentException("wrong param syntax (-pkey=value). was : " + element);
            }
            params.put(string[0], string[1]);
            ++n2;
        }
        return params;
    }

    private static void wrongCall(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + WorkflowRunner.class.getName() + " some_workflow_file.mwe [options]\nor\njava " + WorkflowRunner.class.getName() + " some_workflow_file.oaw [options]\n", options);
        System.exit(0);
    }

    public boolean run(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams, Map<String, ?> externalSlotContents) {
        boolean configOK = this.prepare(workFlowFile, theMonitor, theParams);
        IssuesImpl issues = new IssuesImpl();
        if (configOK) {
            return this.executeWorkflow(externalSlotContents, issues);
        }
        return false;
    }

    public boolean prepare(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams) {
        IssuesImpl issues;
        block10: {
            if (workFlowFile == null) {
                throw new NullPointerException("workflowFile is null");
            }
            this.monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
            this.params = theParams;
            logger.info((Object)"--------------------------------------------------------------------------------------");
            logger.info((Object)("EMF Modeling Workflow Engine " + this.getVersion()));
            logger.info((Object)"(c) 2005-2009 openarchitectureware.org and contributors");
            logger.info((Object)"--------------------------------------------------------------------------------------");
            logger.info((Object)("running workflow: " + workFlowFile));
            logger.info((Object)"");
            if (logger.isDebugEnabled() && !this.params.isEmpty()) {
                logger.debug((Object)("Params:" + this.params.toString()));
            }
            issues = new IssuesImpl();
            try {
                WorkflowFactory factory = new WorkflowFactory();
                try {
                    this.workflow = factory.parseInitAndCreate(workFlowFile, this.params, this.getConverters(), issues);
                }
                catch (IllegalArgumentException illegalArg) {
                    if (illegalArg.getMessage().startsWith("Couldn't load file")) {
                        throw new ConfigurationException(illegalArg.getMessage());
                    }
                    throw illegalArg;
                }
                this.logIssues(logger, issues);
                if (!issues.hasErrors()) break block10;
                logger.error((Object)"Workflow interrupted because of configuration errors.");
                return false;
            }
            catch (ConfigurationException ex) {
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                this.logIssues(logger, issues);
                return false;
            }
        }
        if (this.workflow != null) {
            this.workflow.checkConfiguration(issues);
        }
        this.logIssues(logger, issues);
        if (issues.hasErrors()) {
            logger.error((Object)"Workflow interrupted because of configuration errors.");
            return false;
        }
        return true;
    }

    private Map<Class<?>, Converter> getConverters() {
        Map<Class<?>, Converter> result = this.getCustomConverters();
        Map<Class<?>, Converter> defaults = WorkflowFactory.getDefaultConverter();
        if (result == null) {
            result = defaults;
        } else {
            for (Map.Entry<Class<?>, Converter> record : defaults.entrySet()) {
                if (result.containsKey(record.getKey())) continue;
                result.put(record.getKey(), record.getValue());
            }
        }
        return result;
    }

    protected Map<Class<?>, Converter> getCustomConverters() {
        return null;
    }

    public boolean executeWorkflow(Map<?, ?> externalSlotContents, Issues issues) {
        try {
            this.wfContext = new WorkflowContextDefaultImpl();
            this.addExternalSlotContents(externalSlotContents);
            long time = System.currentTimeMillis();
            this.monitor.started(this.workflow, this.wfContext);
            this.workflow.invoke(this.wfContext, this.monitor, issues);
            this.monitor.finished(this.workflow, this.wfContext);
            long duration = System.currentTimeMillis() - time;
            logger.info((Object)("workflow completed in " + duration + "ms!"));
            return issues.getErrors().length <= 0;
            {
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().indexOf("Interrupt") > -1) {
                logger.error((Object)("Workflow interrupted. Reason: " + e.getMessage()));
            } else {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.logIssues(logger, issues);
        }
        return false;
    }

    private void addExternalSlotContents(Map<?, ?> slotContents) {
        if (slotContents == null) {
            return;
        }
        for (Object name : slotContents.keySet()) {
            String key = (String)name;
            this.wfContext.set(key, slotContents.get(key));
        }
    }

    private void logIssues(Log logger, Issues issues) {
        MWEDiagnostic[] issueArray;
        MWEDiagnostic[] mWEDiagnosticArray = issueArray = issues.getIssues();
        int n = issueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWEDiagnostic issue = mWEDiagnosticArray[n2];
            if (issue.getSeverity() == 4) {
                logger.error((Object)((Object)((Object)issue)).toString());
            }
            if (issue.getSeverity() == 2) {
                logger.warn((Object)((Object)((Object)issue)).toString());
            }
            if (issue.getSeverity() == 1) {
                logger.info((Object)((Object)((Object)issue)).toString());
            }
            ++n2;
        }
    }

    public WorkflowContext getContext() {
        return this.wfContext;
    }

    private String getVersion() {
        try {
            URL url = new URL(MWEPlugin.INSTANCE.getBaseURL() + "META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            String version = manifest.getMainAttributes().getValue("Bundle-Version");
            int lastPoint = version.lastIndexOf(46);
            return String.valueOf(version.substring(0, lastPoint)) + ", Build " + version.substring(lastPoint + 1);
        }
        catch (Exception e) {
            logger.warn((Object)"Couldn't compute version of mwe.core bundle.", (Throwable)e);
            return "unkown version";
        }
    }
}

