/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;

public class WaitableBoolean
extends SynchronizedBoolean {
    public WaitableBoolean(boolean initialValue) {
        super(initialValue);
    }

    public WaitableBoolean(boolean initialValue, Object lock) {
        super(initialValue, lock);
    }

    public boolean set(boolean newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(newValue);
        }
    }

    public boolean commit(boolean assumedValue, boolean newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            return success;
        }
    }

    public boolean complement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.complement();
        }
    }

    public boolean and(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.and(b);
        }
    }

    public boolean or(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.or(b);
        }
    }

    public boolean xor(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.xor(b);
        }
    }

    public void whenFalse(Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenTrue(Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!this.value_) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenEqual(boolean c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(boolean c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

