/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.util.Date;
import org.prevayler.AlarmClock;

public class SystemClock
implements AlarmClock {
    private Date time;
    private long millis;
    private boolean isPaused = true;

    public SystemClock() {
        this.set(new Date(Long.MIN_VALUE));
    }

    public synchronized Date time() {
        if (this.isPaused) {
            return this.time;
        }
        long l = this.currentTimeMillis();
        if (l != this.millis) {
            this.set(new Date(l));
        }
        return this.time;
    }

    synchronized void pause() {
        if (this.isPaused) {
            throw new IllegalStateException("AlarmClock was already paused.");
        }
        this.time();
        this.isPaused = true;
    }

    synchronized void resume() {
        if (!this.isPaused) {
            throw new IllegalStateException("AlarmClock was not paused.");
        }
        this.isPaused = false;
    }

    synchronized void recover(long l) {
        if (!this.isPaused) {
            throw new IllegalStateException("AlarmClock must be paused for recovering.");
        }
        if (l == this.millis) {
            return;
        }
        if (l < this.millis) {
            throw new IllegalArgumentException("AlarmClock's time cannot be set backwards.");
        }
        if (l > this.currentTimeMillis()) {
            throw new IllegalArgumentException("AlarmClock's time cannot be set after the current time.");
        }
        this.set(new Date(l));
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private void set(Date date) {
        this.time = date;
        this.millis = date.getTime();
    }
}

