/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.EventDataConstants;
import org.w3c.dom.Element;

public abstract class AbstractEventData
implements EventDataConstants {
    private JFCTestCase m_testCase;
    private Point m_referencePoint;
    private Point m_screenLocation;
    private boolean m_valid;
    private int m_modifiers;
    private int m_position;
    private long m_sleepTime;

    public final void setTestCase(JFCTestCase testCase) {
        this.m_testCase = testCase;
    }

    public final JFCTestCase getTestCase() {
        return this.m_testCase;
    }

    public abstract Component getComponent();

    public int getDefaultPosition() {
        return 0;
    }

    public long getDefaultSleepTime() {
        return 300L;
    }

    public final Point getLocationOnScreen() {
        return this.m_screenLocation;
    }

    public final boolean isMetaChar(int keyCode) {
        switch (keyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public void setModifiers(int modifiers) {
        this.m_modifiers = modifiers;
    }

    public final int getModifiers() {
        return this.m_modifiers;
    }

    public abstract int getDefaultModifiers();

    public void setPosition(int position) {
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setReferencePoint(Point referencePoint) {
        this.m_referencePoint = referencePoint;
    }

    public Point getReferencePoint() {
        return this.m_referencePoint;
    }

    public Component getRoot() {
        return this.getRoot(this.getComponent());
    }

    public Component getRoot(Component c) {
        Component applet = null;
        for (Component p = c; p != null; p = p.getParent()) {
            if (p instanceof Window || !p.isLightweight()) {
                return p;
            }
            if (!(p instanceof Applet)) continue;
            applet = p;
        }
        return applet;
    }

    public void setSleepTime(long sleepTime) {
        this.m_sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.m_sleepTime;
    }

    public abstract boolean consume(AWTEvent var1);

    public final void setValid(boolean valid) {
        this.m_valid = valid;
    }

    public final boolean isValid() {
        return this.m_valid;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractEventData)) {
            return false;
        }
        AbstractEventData data = (AbstractEventData)o;
        return data.isValid() == this.isValid() && data.getComponent() == this.getComponent() && data.getModifiers() == this.getModifiers() && data.getPosition() == this.getPosition() && data.getReferencePoint() == this.getReferencePoint();
    }

    public int hashCode() {
        Component comp = this.getComponent();
        if (comp != null) {
            return comp.hashCode();
        }
        return 1;
    }

    public void populate(Element e) {
        Point p;
        String txt;
        if (this.getPosition() != this.getDefaultPosition()) {
            String position;
            switch (this.getPosition()) {
                case 1: {
                    position = "north";
                    break;
                }
                case 5: {
                    position = "south";
                    break;
                }
                case 3: {
                    position = "east";
                    break;
                }
                case 7: {
                    position = "west";
                    break;
                }
                case 8: {
                    position = "northwest";
                    break;
                }
                case 2: {
                    position = "northeast";
                    break;
                }
                case 6: {
                    position = "southwest";
                    break;
                }
                case 4: {
                    position = "southeast";
                    break;
                }
                case 0: {
                    position = "center";
                    break;
                }
                case 12: {
                    position = "custom";
                    break;
                }
                case 13: {
                    position = "percent";
                    break;
                }
                case 14: {
                    position = "offset";
                    break;
                }
                default: {
                    position = "" + this.getPosition();
                }
            }
            e.setAttribute("position", position);
        }
        if (this.getModifiers() != this.getDefaultModifiers() && (txt = this.getModifierText()) != null && txt.length() > 0) {
            e.setAttribute("modifiers", txt);
        }
        if (this.getSleepTime() != this.getDefaultSleepTime()) {
            e.setAttribute("sleeptime", "" + this.getSleepTime());
        }
        if ((p = this.getReferencePoint()) != null) {
            e.setAttribute("reference", "" + p.x + "," + p.y);
        }
    }

    public boolean prepareComponent() {
        JComponent c;
        Rectangle vis;
        if (!this.isValidForProcessing(this.getComponent())) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        Rectangle compRect = this.getComponent().getBounds();
        if (testCase != null) {
            testCase.flushAWT();
        }
        Point p = this.calculatePoint(compRect);
        if (this.getComponent() instanceof JComponent && !(vis = (c = (JComponent)this.getComponent()).getVisibleRect()).contains(p)) {
            Rectangle newView = new Rectangle(p.x - vis.width / 2, p.y - vis.height / 2, vis.width, vis.height);
            c.scrollRectToVisible(newView);
        }
        Point screen = this.getComponent().getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(this.getClass().getName());
        if (!this.isValid()) {
            buf.append(" invalid");
            return buf.toString();
        }
        buf.append(" testCase: " + (Object)((Object)this.getTestCase()));
        buf.append(" modifiers: " + this.getModifierText());
        buf.append(" sleepTime: " + this.m_sleepTime);
        buf.append(" position:" + EventDataConstants.POSITIONSTRINGS[this.m_position]);
        buf.append(" refPoint: " + this.m_referencePoint);
        buf.append(" screenLoc: " + this.m_screenLocation);
        buf.append(" component: " + this.getComponent());
        return buf.toString();
    }

    protected final void setLocationOnScreen(Point screenLocation) {
        this.m_screenLocation = screenLocation;
    }

    protected boolean isValidForProcessing(Component comp) {
        return comp != null && comp.isShowing();
    }

    protected final Point calculatePoint(Rectangle rect) {
        if (this.m_position == 12) {
            return new Point(rect.x + this.m_referencePoint.x, rect.y + this.m_referencePoint.y);
        }
        int x = 0;
        int y = 0;
        if (this.m_position == 13) {
            x = rect.x + rect.width * this.m_referencePoint.x / 100;
            y = rect.y + rect.height * this.m_referencePoint.y / 100;
        } else {
            y = this.m_position == 1 || this.m_position == 8 || this.m_position == 2 ? rect.y : (this.m_position == 5 || this.m_position == 6 || this.m_position == 4 ? rect.y + rect.height : rect.y + rect.height / 2);
            x = this.m_position == 7 || this.m_position == 8 || this.m_position == 6 ? rect.x : (this.m_position == 3 || this.m_position == 2 || this.m_position == 4 ? rect.x + rect.width : rect.x + rect.width / 2);
        }
        return new Point(x, y);
    }

    protected boolean canConsume(AWTEvent ae) {
        if (!this.isValid()) {
            return true;
        }
        return ae.getSource().equals(this.getComponent());
    }

    abstract String getModifierText();
}

