/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IExpressionBool;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Result;
import java.util.Map;

class OpBoolEQ
implements IExpressionBool {
    private final IExpression lhs_;
    private final IExpression rhs_;

    public OpBoolEQ(IExpression lhs, IExpression rhs) {
        this.lhs_ = lhs;
        this.rhs_ = rhs;
    }

    public Object eval(Map identifiers) {
        Object oLhs = this.lhs_.eval(identifiers);
        if (!(oLhs instanceof Boolean)) {
            return Result.RESULT_UNKNOWN;
        }
        boolean lhs = (Boolean)oLhs;
        Object oRhs = this.rhs_.eval(identifiers);
        if (!(oRhs instanceof Boolean)) {
            return Result.RESULT_UNKNOWN;
        }
        boolean rhs = (Boolean)oRhs;
        if (lhs == rhs) {
            return Result.RESULT_TRUE;
        }
        return Result.RESULT_FALSE;
    }

    public Object eval(IValueProvider provider, Object corr) {
        Object oLhs = this.lhs_.eval(provider, corr);
        if (!(oLhs instanceof Boolean)) {
            return Result.RESULT_UNKNOWN;
        }
        boolean lhs = (Boolean)oLhs;
        Object oRhs = this.rhs_.eval(provider, corr);
        if (!(oRhs instanceof Boolean)) {
            return Result.RESULT_UNKNOWN;
        }
        boolean rhs = (Boolean)oRhs;
        if (lhs == rhs) {
            return Result.RESULT_TRUE;
        }
        return Result.RESULT_FALSE;
    }

    public String toString() {
        return this.lhs_.toString() + " = " + this.rhs_.toString();
    }
}

