/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IExpressionNumeric;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.NumericValue;
import com.codestreet.selector.parser.Result;
import java.util.Map;

class OpBETWEEN
implements IExpressionNumeric {
    private final IExpression val_;
    private final IExpression lower_;
    private final IExpression upper_;

    public OpBETWEEN(IExpression val, IExpression lower, IExpression upper) {
        this.val_ = val;
        this.lower_ = lower;
        this.upper_ = upper;
    }

    public Object eval(Map identifiers) {
        Object oVal = this.val_.eval(identifiers);
        Object oLower = this.lower_.eval(identifiers);
        Object oUpper = this.lower_.eval(identifiers);
        return this.eval(oVal, oLower, oUpper);
    }

    public Object eval(IValueProvider provider, Object corr) {
        Object oVal = this.val_.eval(provider, corr);
        Object oLower = this.lower_.eval(provider, corr);
        Object oUpper = this.lower_.eval(provider, corr);
        return this.eval(oVal, oLower, oUpper);
    }

    private Object eval(Object oVal, Object oLower, Object oUpper) {
        double lower;
        if (!(oVal instanceof NumericValue && oLower instanceof NumericValue && oUpper instanceof NumericValue)) {
            return Result.RESULT_UNKNOWN;
        }
        double val = ((NumericValue)oVal).doubleValue();
        if (val < (lower = ((NumericValue)oLower).doubleValue())) {
            return Result.RESULT_FALSE;
        }
        double upper = ((NumericValue)oUpper).doubleValue();
        return val <= upper ? Result.RESULT_TRUE : Result.RESULT_FALSE;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.val_.toString() + " BETWEEN ");
        buf.append(this.lower_.toString()).append(" AND ").append(this.upper_.toString());
        return buf.toString();
    }
}

