/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public abstract class Profiler {
    private static long s_begin;
    private static long[] s_sums;
    private static long[] s_sumsq;
    private static int s_upto;
    private static int s_count;
    private static boolean s_active;

    public static void reset(int points) {
        s_sums = new long[points];
        s_sumsq = new long[points];
        s_upto = 0;
        s_count = 0;
        s_active = true;
        s_begin = System.currentTimeMillis();
    }

    public static void point() {
        if (!s_active) {
            return;
        }
        long total = System.currentTimeMillis() - s_begin;
        int n = s_upto;
        s_sums[n] = s_sums[n] + total;
        int n2 = s_upto++;
        s_sumsq[n2] = s_sumsq[n2] + total * total;
        s_begin = System.currentTimeMillis();
    }

    public static int next() {
        Profiler.point();
        int ret = s_upto;
        ++s_count;
        s_upto = 0;
        s_begin = System.currentTimeMillis();
        return ret;
    }

    public static double[] means() {
        double[] means = new double[s_sums.length];
        int i = 0;
        while (i < means.length) {
            means[i] = (double)s_sums[i] / (double)s_count;
            ++i;
        }
        s_active = false;
        return means;
    }

    public static double[] stddev() {
        double[] stdev = new double[s_sums.length];
        double n = s_count;
        int i = 0;
        while (i < stdev.length) {
            stdev[i] = Math.sqrt((n * (double)s_sumsq[i] - (double)s_sums[i] * (double)s_sums[i]) / (n * n));
            ++i;
        }
        s_active = false;
        return stdev;
    }

    static {
        s_active = false;
    }
}

