/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.openorb.util.ExceptionTool;

public abstract class NamingUtils {
    private static final NameComponent[] EMPTY_NAME = new NameComponent[0];

    public static String encodeRFC2396(String str) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                switch (c) {
                    case '!': 
                    case '$': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '?': 
                    case '@': 
                    case '_': 
                    case '~': {
                        break;
                    }
                    default: {
                        sb.append(str.substring(start, i));
                        byte[] tmp = str.substring(i, i + 1).getBytes("UTF-8");
                        int j = 0;
                        while (j < tmp.length) {
                            sb.append('%');
                            if ((tmp[j] & 0xF0) < 160) {
                                sb.append((tmp[j] & 0xF0) >> 4);
                            } else {
                                sb.append((char)(65 + ((tmp[j] & 0x50) >> 4)));
                            }
                            if ((tmp[j] & 0xF) < 10) {
                                sb.append(tmp[j] & 0xF);
                            } else {
                                sb.append((char)(65 + (tmp[j] & 5)));
                            }
                            ++j;
                        }
                        start = i + 1;
                    }
                }
            }
            ++i;
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String decodeRFC2396(String enc) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int i = 0;
        while (i < enc.length()) {
            if (sb.charAt(i) == '%') {
                sb.append(enc.substring(start, i));
                int count = 1;
                while (sb.charAt(i + 2 * count) == '%') {
                    ++count;
                }
                byte[] buf = new byte[count];
                int j = 0;
                while (j < count) {
                    buf[i] = Byte.parseByte(enc.substring(i + 2 * j + 1, i + 2 * j + 2), 16);
                    ++j;
                }
                sb.append(new String(buf, "UTF-16"));
                i += count * 3 - 1;
            }
            ++i;
        }
        sb.append(enc.substring(start));
        return sb.toString();
    }

    private static boolean checkAddress(String addr) {
        int start;
        int end = addr.length();
        do {
            int host;
            int proto;
            if ((start = addr.lastIndexOf(",", end)) < 0) {
                start = 0;
            }
            if ((proto = addr.indexOf(":", start)) < 0 || proto > end) {
                return false;
            }
            int vers = addr.indexOf("@", proto);
            if (vers > 0 && vers < end) {
                int major = addr.indexOf(".", proto);
                if (major < 0 || major > vers) {
                    return false;
                }
                try {
                    Integer.parseInt(addr.substring(proto + 1, major));
                    Integer.parseInt(addr.substring(major + 1, vers));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            } else {
                vers = proto;
            }
            if ((host = addr.indexOf(":", vers + 1)) > 0 && host < end) {
                try {
                    Integer.parseInt(addr.substring(host + 1, end));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            } else {
                host = end;
            }
            end = start;
        } while (start > 0);
        return true;
    }

    public static void deepBind(NamingContext context, String name, Object obj) throws InvalidName, NotFound, CannotProceed, AlreadyBound {
        NamingUtils.deepBind(context, NamingUtils.to_name(name), obj);
    }

    public static void deepBind(NamingContext context, NameComponent[] name, Object obj) throws InvalidName, NotFound, CannotProceed, AlreadyBound {
        NameComponent[] ctxName = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ctxName, 0, ctxName.length);
        NamingContext sub = NamingUtils.resolveOrCreateContext(context, ctxName);
        sub.bind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    public static void deepRebind(NamingContext context, String name, Object obj) throws InvalidName, NotFound, CannotProceed {
        NamingUtils.deepRebind(context, NamingUtils.to_name(name), obj);
    }

    public static void deepRebind(NamingContext context, NameComponent[] name, Object obj) throws InvalidName, NotFound, CannotProceed {
        NameComponent[] ctxName = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ctxName, 0, ctxName.length);
        NamingContext sub = NamingUtils.resolveOrCreateContext(context, ctxName);
        sub.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    /*
     * Unable to fully structure code
     */
    public static NamingContext resolveOrCreateContext(NamingContext context, NameComponent[] name) throws InvalidName, NotFound, CannotProceed {
        block11: {
            try {
                obj = context.resolve(name);
                break block11;
            }
            catch (NotFound ex) {
                switch (ex.why.value()) {
                    case 1: 
                    case 2: {
                        throw ex;
                    }
                }
                bname = new NameComponent[name.length - ex.rest_of_name.length];
                System.arraycopy(name, 0, bname, 0, bname.length);
                base = context;
                if (bname.length > 0) {
                    base = NamingContextHelper.narrow(context.resolve(bname));
                }
                i = 0;
                ** while (i < ex.rest_of_name.length)
            }
lbl-1000:
            // 1 sources

            {
                next = new NameComponent[]{ex.rest_of_name[i]};
                try {
                    base = base.bind_new_context(next);
                }
                catch (AlreadyBound ex1) {
                    base = NamingContextHelper.narrow(base.resolve(next));
                }
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            return base;
        }
        try {
            return NamingContextHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            throw (NotFound)ExceptionTool.initCause(new NotFound(NotFoundReason.not_context, new NameComponent[]{name[name.length - 1]}), (Throwable)ex);
        }
    }

    public static NameComponent[] to_name(String sn) throws InvalidName {
        if (sn.length() == 0) {
            throw new InvalidName();
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        boolean id = true;
        StringBuffer buf = null;
        int i = 0;
        while (i < sn.length()) {
            switch (sn.charAt(i)) {
                case '\\': {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(sn.substring(start, i));
                    start = ++i;
                    break;
                }
                case '/': {
                    if (buf != null) {
                        list.add(buf.append(sn.substring(start, i)).toString());
                    } else {
                        list.add(sn.substring(start, i));
                    }
                    if (id) {
                        if (i == start && buf == null) {
                            throw new InvalidName();
                        }
                        list.add("");
                    } else {
                        id = true;
                    }
                    buf = null;
                    start = i + 1;
                    break;
                }
                case '.': {
                    if (!id) {
                        throw new InvalidName();
                    }
                    if (buf != null) {
                        list.add(buf.append(sn.substring(start, i)).toString());
                        buf = null;
                    } else {
                        list.add(sn.substring(start, i));
                    }
                    id = false;
                    start = i + 1;
                }
            }
            ++i;
        }
        if (buf != null) {
            list.add(buf.append(sn.substring(start)).toString());
        } else {
            list.add(sn.substring(start));
        }
        if (id) {
            if (start == sn.length() && buf == null) {
                throw new InvalidName();
            }
            list.add("");
        }
        NameComponent[] name = new NameComponent[list.size() / 2];
        Iterator itt = list.iterator();
        int i2 = 0;
        while (i2 < list.size()) {
            name[i2 / 2] = new NameComponent((String)itt.next(), (String)itt.next());
            i2 += 2;
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    public static String to_string(NameComponent[] n) throws InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        buf = new StringBuffer();
        i = 0;
        while (i < n.length) {
            block13: {
                block12: {
                    if (n[i].id != null && n[i].id.length() != 0) break block12;
                    buf.append('.');
                    if (n[i].kind != null && n[i].kind.length() != 0) ** GOTO lbl34
                    buf.append('/');
                    break block13;
                }
                start = 0;
                j = 0;
                while (j < n[i].id.length()) {
                    switch (n[i].id.charAt(j)) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            buf.append(n[i].id.substring(start, j));
                            buf.append('\\');
                            start = j;
                        }
                    }
                    ++j;
                }
                buf.append(n[i].id.substring(start));
                if (n[i].kind == null || n[i].kind.length() == 0) {
                    buf.append('/');
                } else {
                    buf.append('.');
lbl34:
                    // 2 sources

                    start = 0;
                    j = 0;
                    while (j < n[i].kind.length()) {
                        switch (n[i].kind.charAt(j)) {
                            case '.': 
                            case '/': 
                            case '\\': {
                                buf.append(n[i].kind.substring(start, j));
                                buf.append('\\');
                                start = j;
                            }
                        }
                        ++j;
                    }
                    buf.append(n[i].kind.substring(start));
                    buf.append('/');
                }
            }
            ++i;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (!NamingUtils.checkAddress(addr)) {
            throw new InvalidAddress();
        }
        NamingUtils.to_name(sn);
        String url = null;
        try {
            url = "corbaname:" + addr + "#" + NamingUtils.encodeRFC2396(sn);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        return url;
    }

    public static NameComponent[] parent(NameComponent[] name) {
        if (name.length <= 1) {
            return EMPTY_NAME;
        }
        NameComponent[] ret = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, ret, 0, ret.length);
        return ret;
    }

    public static String parent(String name) {
        try {
            return NamingUtils.to_string(NamingUtils.parent(NamingUtils.to_name(name)));
        }
        catch (Exception ex) {
            return "";
        }
    }
}

