/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class IndexedPropertySupport
extends Node.IndexedProperty {
    protected Object instance;
    private Method setter;
    private Method getter;
    private Method indexedSetter;
    private Method indexedGetter;

    public IndexedPropertySupport(Object instance, Class valueType, Class elementType, Method getter, Method setter, Method indexedGetter, Method indexedSetter) {
        super(valueType, elementType);
        this.instance = instance;
        this.setter = setter;
        this.getter = getter;
        this.indexedSetter = indexedSetter;
        this.indexedGetter = indexedGetter;
    }

    public final void setDisplayName(String s) {
        super.setDisplayName(s);
    }

    public final void setName(String s) {
        super.setName(s);
    }

    public final void setShortDescription(String s) {
        super.setShortDescription(s);
    }

    public boolean canRead() {
        return this.getter != null;
    }

    public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canRead()) {
            throw new IllegalAccessException();
        }
        Object validInstance = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
        return this.getter.invoke(validInstance, new Object[0]);
    }

    public boolean canWrite() {
        return this.setter != null;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canWrite()) {
            throw new IllegalAccessException();
        }
        Object validInstance = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
        if (val != null && this.setter.getParameterTypes()[0].getComponentType().isPrimitive() && !val.getClass().getComponentType().isPrimitive()) {
            val = Utilities.toPrimitiveArray((Object[])val);
        }
        this.setter.invoke(validInstance, val);
    }

    public boolean canIndexedRead() {
        return this.indexedGetter != null;
    }

    public Object getIndexedValue(int index) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedRead()) {
            throw new IllegalAccessException();
        }
        Object validInstance = Beans.getInstanceOf(this.instance, this.indexedGetter.getDeclaringClass());
        return this.indexedGetter.invoke(validInstance, new Integer(index));
    }

    public boolean canIndexedWrite() {
        return this.indexedSetter != null;
    }

    public void setIndexedValue(int index, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedWrite()) {
            throw new IllegalAccessException();
        }
        Object validInstance = Beans.getInstanceOf(this.instance, this.indexedSetter.getDeclaringClass());
        this.indexedSetter.invoke(validInstance, new Integer(index), val);
    }
}

