/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class OpenSupport
extends CloneableOpenSupport {
    protected MultiDataObject.Entry entry;
    static /* synthetic */ Class class$org$openide$loaders$OpenSupport;

    public OpenSupport(MultiDataObject.Entry entry) {
        this(entry, new Env(entry.getDataObject()));
    }

    protected OpenSupport(MultiDataObject.Entry entry, Env env) {
        super(env);
        this.entry = entry;
    }

    protected String messageOpening() {
        MultiDataObject obj = this.entry.getDataObject();
        return NbBundle.getMessage(class$org$openide$loaders$OpenSupport == null ? (class$org$openide$loaders$OpenSupport = OpenSupport.class$("org.openide.loaders.OpenSupport")) : class$org$openide$loaders$OpenSupport, "CTL_ObjectOpen", obj.getName(), obj.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(class$org$openide$loaders$OpenSupport == null ? (class$org$openide$loaders$OpenSupport = OpenSupport.class$("org.openide.loaders.OpenSupport")) : class$org$openide$loaders$OpenSupport, "CTL_ObjectOpened");
    }

    final CloneableTopComponent.Ref allEditors() {
        return this.allEditors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Listener
    extends CloneableTopComponent.Ref {
        static final long serialVersionUID = -1934890789745432531L;
        private MultiDataObject.Entry entry;
        static /* synthetic */ Class class$org$openide$loaders$OpenSupport;

        Listener() {
        }

        public Object readResolve() {
            MultiDataObject obj = this.entry.getDataObject();
            OpenSupport os = (OpenSupport)((Object)((DataObject)obj).getCookie(class$org$openide$loaders$OpenSupport == null ? (class$org$openide$loaders$OpenSupport = Listener.class$("org.openide.loaders.OpenSupport")) : class$org$openide$loaders$OpenSupport));
            if (os == null) {
                return this;
            }
            return os.allEditors();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class FileSystemNameListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private final Set environments = new WeakSet(30);

        public void add(Env env) {
            Set set = this.environments;
            synchronized (set) {
                this.environments.add(env);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("systemName".equals(evt.getPropertyName())) {
                HashSet envs;
                Set set = this.environments;
                synchronized (set) {
                    envs = new HashSet(this.environments);
                }
                Iterator it = envs.iterator();
                while (it.hasNext()) {
                    Env env = (Env)it.next();
                    env.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("systemName".equals(evt.getPropertyName())) {
                HashSet envs;
                Set set = this.environments;
                synchronized (set) {
                    envs = new HashSet(this.environments);
                }
                Iterator it = envs.iterator();
                while (it.hasNext()) {
                    Env env = (Env)it.next();
                    env.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }
    }

    public static class Env
    implements CloneableOpenSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -1934890789745432531L;
        private DataObject obj;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        private static final Map fsListenerMap = new WeakHashMap(30);
        private static final Object LOCK_SUPPORT = new Object();
        static /* synthetic */ Class class$org$openide$windows$CloneableOpenSupport;

        public Env(DataObject obj) {
            this.obj = obj;
            this.init();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.init();
        }

        private void init() {
            FileSystemNameListener fsListener;
            FileSystem fs;
            this.obj.addPropertyChangeListener(WeakListener.propertyChange(this, this.obj));
            try {
                fs = this.obj.getPrimaryFile().getFileSystem();
            }
            catch (FileStateInvalidException fsie) {
                IllegalStateException ise = new IllegalStateException("FileSystem is invalid for " + this.obj.getPrimaryFile() + "!");
                ErrorManager.getDefault().annotate((Throwable)ise, fsie);
                throw ise;
            }
            boolean initListening = false;
            Map map = fsListenerMap;
            synchronized (map) {
                Reference fsListenerRef = (Reference)fsListenerMap.get(fs);
                FileSystemNameListener fileSystemNameListener = fsListener = fsListenerRef == null ? null : (FileSystemNameListener)fsListenerRef.get();
                if (fsListener == null) {
                    fsListener = new FileSystemNameListener();
                    fsListenerMap.put(fs, new WeakReference<FileSystemNameListener>(fsListener));
                    initListening = true;
                }
            }
            if (initListening) {
                fs.addPropertyChangeListener(fsListener);
                fs.addVetoableChangeListener(fsListener);
            }
            fsListener.add(this);
        }

        protected final DataObject getDataObject() {
            return this.obj;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop().addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            this.veto().addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            this.veto().removeVetoableChangeListener(l);
        }

        public boolean isValid() {
            return this.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.getDataObject().isModified();
        }

        public void markModified() throws IOException {
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)((Object)this.getDataObject().getCookie(class$org$openide$windows$CloneableOpenSupport == null ? (class$org$openide$windows$CloneableOpenSupport = Env.class$("org.openide.windows.CloneableOpenSupport")) : class$org$openide$windows$CloneableOpenSupport));
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("modified".equals(ev.getPropertyName())) {
                if (this.getDataObject().isModified()) {
                    this.getDataObject().addVetoableChangeListener(this);
                } else {
                    this.getDataObject().removeVetoableChangeListener(this);
                }
            }
            this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            this.fireVetoableChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }

        protected void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        protected void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
            this.veto().fireVetoableChange(name, oldValue, newValue);
        }

        private PropertyChangeSupport prop() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
                PropertyChangeSupport propertyChangeSupport = this.propSupp;
                return propertyChangeSupport;
            }
        }

        private VetoableChangeSupport veto() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.vetoSupp == null) {
                    this.vetoSupp = new VetoableChangeSupport(this);
                }
                VetoableChangeSupport vetoableChangeSupport = this.vetoSupp;
                return vetoableChangeSupport;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

