/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class DefaultDataObject
extends MultiDataObject {
    static final long serialVersionUID = -4936309935667095746L;
    static /* synthetic */ Class class$org$openide$loaders$DefaultDataObject;

    DefaultDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    protected Node createNodeDelegate() {
        DataNode dn = new DataNode(this, Children.LEAF);
        dn.setShortDescription(NbBundle.getMessage(class$org$openide$loaders$DefaultDataObject == null ? (class$org$openide$loaders$DefaultDataObject = DefaultDataObject.class$("org.openide.loaders.DefaultDataObject")) : class$org$openide$loaders$DefaultDataObject, "HINT_DefaultDataObject"));
        return dn;
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$loaders$DefaultDataObject == null ? (class$org$openide$loaders$DefaultDataObject = DefaultDataObject.class$("org.openide.loaders.DefaultDataObject")) : class$org$openide$loaders$DefaultDataObject);
    }

    protected FileObject handleRename(String name) throws IOException {
        FileLock lock = this.getPrimaryFile().lock();
        int pos = name.lastIndexOf(46);
        try {
            if (pos < 0) {
                this.getPrimaryFile().rename(lock, name, null);
            } else if (pos == 0) {
                this.getPrimaryFile().rename(lock, name, this.getPrimaryFile().getExt());
            } else if (!name.equals(this.getPrimaryFile().getNameExt())) {
                this.getPrimaryFile().rename(lock, name.substring(0, pos), name.substring(pos + 1, name.length()));
                DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(this.getPrimaryFile())));
            }
            Object var5_4 = null;
            lock.releaseLock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.releaseLock();
            throw throwable;
        }
        return this.getPrimaryFile();
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name != null && name.endsWith("." + this.getPrimaryFile().getExt())) {
            name = name.substring(0, name.lastIndexOf("." + this.getPrimaryFile().getExt()));
        }
        return super.handleCreateFromTemplate(df, name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

