/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

final class BrokenDataShadow
extends MultiDataObject {
    private String origFSName;
    private String origFOName;
    private static Set allDataShadows;
    private static ReferenceQueue rqueue;
    private static final long serialVersionUID = -3046981691235483810L;
    static /* synthetic */ Class class$org$openide$loaders$BrokenDataShadow;

    public BrokenDataShadow(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        try {
            BufferedReader ois = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            this.origFOName = ois.readLine();
            this.origFSName = ois.readLine();
            ois.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    private static Set getDataShadowsSet() {
        if (allDataShadows == null) {
            Class clazz = class$org$openide$loaders$BrokenDataShadow == null ? (class$org$openide$loaders$BrokenDataShadow = BrokenDataShadow.class$("org.openide.loaders.BrokenDataShadow")) : class$org$openide$loaders$BrokenDataShadow;
            synchronized (clazz) {
                if (allDataShadows == null) {
                    allDataShadows = new HashSet();
                }
            }
        }
        return allDataShadows;
    }

    private static ReferenceQueue getRqueue() {
        if (rqueue == null) {
            Class clazz = class$org$openide$loaders$BrokenDataShadow == null ? (class$org$openide$loaders$BrokenDataShadow = BrokenDataShadow.class$("org.openide.loaders.BrokenDataShadow")) : class$org$openide$loaders$BrokenDataShadow;
            synchronized (clazz) {
                if (rqueue == null) {
                    rqueue = new ReferenceQueue();
                }
            }
        }
        return rqueue;
    }

    private static void checkQueue() {
        if (rqueue == null) {
            return;
        }
        Reference ref = rqueue.poll();
        while (ref != null) {
            BrokenDataShadow.getDataShadowsSet().remove(ref);
            ref = rqueue.poll();
        }
    }

    private static synchronized void enqueueBrokenDataShadow(BrokenDataShadow ds) {
        BrokenDataShadow.checkQueue();
        BrokenDataShadow.getDataShadowsSet().add(DataShadow.createReference(ds, BrokenDataShadow.getRqueue()));
    }

    private static synchronized List getAllDataShadows() {
        Set allShadows = allDataShadows;
        if (allShadows == null || allShadows.isEmpty()) {
            return null;
        }
        ArrayList ret = new ArrayList(allShadows.size());
        Iterator it = allShadows.iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            Object shadow = ref.get();
            if (shadow == null) continue;
            ret.add(shadow);
        }
        return ret;
    }

    static void checkValidity(EventObject ev) {
        List all = BrokenDataShadow.getAllDataShadows();
        if (all == null) {
            return;
        }
        int size = all.size();
        int i = 0;
        while (i < size) {
            Object obj = all.get(i);
            ((BrokenDataShadow)obj).refresh();
            ++i;
        }
    }

    private BrokenDataShadow(FileObject fo) throws DataObjectExistsException {
        this(fo, DataLoaderPool.getShadowLoader());
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public void refresh() {
        try {
            if (DataShadow.checkOriginal(this.origFOName, this.origFSName, this.getPrimaryFile().getFileSystem()) != null) {
                this.setValid(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/resources/brokenShadow";
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

        public BrokenShadowNode(BrokenDataShadow par) {
            super(par, Children.LEAF);
            this.setIconBase(ICON_NAME);
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(DataObject.getString("FMT_brokenShadowName"));
            }
            return format.format(this.createArguments());
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BrokenShadowNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = BrokenShadowNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BrokenShadowNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BrokenShadowNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BrokenShadowNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BrokenShadowNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] sets = super.getPropertySets();
            Sheet s = new Sheet();
            int i = 0;
            while (i < sets.length) {
                Sheet.Set ss = new Sheet.Set();
                ss.put(sets[i].getProperties());
                ss.setName(sets[i].getName());
                ss.setDisplayName(sets[i].getDisplayName());
                ss.setShortDescription(sets[i].getShortDescription());
                this.modifySheetSet(ss);
                s.put(ss);
                ++i;
            }
            return s;
        }

        private void modifySheetSet(Sheet.Set ss) {
            Node.Property p = ss.remove("name");
            if (p != null) {
                p = new PropertySupport.Name(this);
                ss.put(p);
                p = new Name();
                ss.put(p);
                p = new FileSystemProperty();
                ss.put(p);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private final class FileSystemProperty
        extends PropertySupport.ReadOnly {
            static /* synthetic */ Class class$java$lang$String;

            public FileSystemProperty() {
                super("BrokenLinkFileSystem", class$java$lang$String == null ? (class$java$lang$String = FileSystemProperty.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowFileSystem"), DataObject.getString("HINT_brokenShadowFileSystem"));
            }

            public Object getValue() {
                BrokenDataShadow bds = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return bds.origFSName;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            static /* synthetic */ Class class$java$lang$String;

            public Name() {
                super("BrokenLink", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowOriginalName"), DataObject.getString("HINT_brokenShadowOriginalName"));
            }

            public Object getValue() {
                BrokenDataShadow bds = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return bds.origFOName;
            }

            public void setValue(Object val) {
            }

            public boolean canWrite() {
                return false;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

