/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.util.RequestProcessor;

final class RefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private static RequestProcessor REFRESHER = new RequestProcessor("FS refresher");
    private Reference system;
    private Enumeration en;
    private int refreshTime;
    private RequestProcessor.Task task;

    public RefreshRequest(AbstractFileSystem fs, int ms) {
        this.system = new WeakReference<AbstractFileSystem>(fs);
        this.refreshTime = ms;
        this.task = REFRESHER.post(this, ms, 1);
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        RefreshRequest refreshRequest2;
        RequestProcessor.Task t;
        int ms;
        RefreshRequest refreshRequest = this;
        synchronized (refreshRequest) {
            ms = this.refreshTime;
            if (ms <= 0) {
                return;
            }
            t = this.task;
        }
        try {
            this.task = null;
            this.doLoop(ms);
            Object var6_5 = null;
            refreshRequest2 = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            RefreshRequest refreshRequest3 = this;
            synchronized (refreshRequest3) {
                this.task = t;
                this.notifyAll();
            }
            if (this.system != null && this.system.get() != null) {
                t.schedule(ms);
                throw throwable;
            } else {
                this.refreshTime = 0;
            }
            throw throwable;
        }
        synchronized (refreshRequest2) {
            this.task = t;
            this.notifyAll();
        }
        if (this.system != null && this.system.get() != null) {
            t.schedule(ms);
            return;
        }
        this.refreshTime = 0;
    }

    private void doLoop(int ms) {
        AbstractFileSystem system = (AbstractFileSystem)this.system.get();
        if (system == null) {
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = RefreshRequest.existingFolders(system);
        }
        int i = 0;
        while (i < 30 && this.en.hasMoreElements()) {
            AbstractFolder fo = (AbstractFolder)this.en.nextElement();
            if (fo != null && (!fo.isFolder() || fo.isInitialized())) {
                fo.refresh();
            }
            if (this.refreshTime <= 0) {
                return;
            }
            ++i;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration existingFolders(AbstractFileSystem fs) {
        return fs.existingFileObjects(fs.getAbstractRoot());
    }

    public String toString() {
        AbstractFileSystem fs = (AbstractFileSystem)this.system.get();
        return "RefreshRequest for " + (fs == null ? "gone FS" : fs.getSystemName());
    }
}

