/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalBorders;
import org.openide.ErrorManager;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.util.Task;
import org.openide.util.actions.Presenter;

public class Toolbar
extends JToolBar {
    public static final int BASIC_HEIGHT = 34;
    static int HEIGHT_TOLERANCE = 5;
    static int TOP = 2;
    static int LEFT = 3;
    static int BOTTOM = 2;
    static int RIGHT = 3;
    static int RESIDUAL_WIDTH = 16;
    private boolean floatable;
    private DnDListener listener;
    private ToolbarMouseListener mouseListener;
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    static final long serialVersionUID = 5011742660516204764L;

    public Toolbar() {
        this("");
    }

    public Toolbar(String name) {
        this(name, name, false);
    }

    public Toolbar(String name, String displayName) {
        this(name, displayName, false);
    }

    public Toolbar(String name, boolean f) {
        this(name, name, f);
    }

    Toolbar(DataFolder folder, boolean f) {
        this.backingFolder = folder;
        this.initAll(folder.getName(), f);
    }

    private void doInitialize() {
        if (this.processor == null && this.isVisible()) {
            this.processor = new Folder();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.doInitialize();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.doInitialize();
    }

    public Toolbar(String name, String displayName, boolean f) {
        this.setDisplayName(displayName);
        this.initAll(name, f);
    }

    private void initAll(String name, boolean f) {
        this.floatable = f;
        this.mouseListener = null;
        this.setName(name);
        this.setFloatable(false);
        Border b = UIManager.getBorder("ToolBar.border");
        if (b == null || b instanceof MetalBorders.ToolBarBorder) {
            b = BorderFactory.createEtchedBorder(1);
        }
        this.setBorder(new CompoundBorder(b, new EmptyBorder(TOP, LEFT, BOTTOM, RIGHT)));
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.addGrip();
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public void removeAll() {
        super.removeAll();
        this.addGrip();
    }

    void addGrip() {
        if (this.floatable) {
            JPanel dragarea;
            String lAndF = UIManager.getLookAndFeel().getName();
            JPanel jPanel = dragarea = lAndF.equals("Windows") ? new ToolbarGrip() : new ToolbarBump();
            if (this.mouseListener == null) {
                this.mouseListener = new ToolbarMouseListener();
            }
            dragarea.addMouseListener(this.mouseListener);
            dragarea.addMouseMotionListener(this.mouseListener);
            this.add(dragarea);
            this.addSeparator(new Dimension(4, 1));
        }
    }

    public static int rowCount(int height) {
        return 1 + height / (34 + HEIGHT_TOLERANCE);
    }

    public void setDnDListener(DnDListener l) {
        this.listener = l;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            if (!this.backingFolder.isValid()) {
                return this.backingFolder.getName();
            }
            return this.backingFolder.getNodeDelegate().getDisplayName();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected void fireDragToolbar(int dx, int dy, int type) {
        if (this.listener != null) {
            this.listener.dragToolbar(new DnDEvent(this, this.getName(), dx, dy, type));
        }
    }

    protected void fireDropToolbar(int dx, int dy, int type) {
        if (this.listener != null) {
            this.listener.dropToolbar(new DnDEvent(this, this.getName(), dx, dy, type));
        }
    }

    final synchronized MouseInputListener mouseDelegate() {
        if (this.mouseListener == null) {
            this.mouseListener = new ToolbarMouseListener();
        }
        return this.mouseListener;
    }

    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String name, int dx, int dy, int type) {
            super(toolbar);
            this.name = name;
            this.dx = dx;
            this.dy = dy;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    private final class ToolbarGrip
    extends JPanel {
        static final int HGAP = 1;
        static final int VGAP = 1;
        static final int STEP = 1;
        static final int WIDTH = 2;
        int columns;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315276L;

        public ToolbarGrip() {
            this(2);
        }

        public ToolbarGrip(int col) {
            this.columns = col;
            int width = (col - 1) * 1 + col * 2 + 2;
            this.dim = new Dimension(width, width);
            this.max = new Dimension(width, Integer.MAX_VALUE);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setToolTipText(Toolbar.this.getName());
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int top = 1;
            int bottom = size.height - 1 - 1;
            int height = bottom - top;
            g.setColor(this.getBackground());
            int i = 0;
            int x = 1;
            while (i < this.columns) {
                g.draw3DRect(x, top, 2, height, true);
                ++i;
                x += 3;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarBump
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 0;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarBump() {
            int width = 6;
            this.dim = new Dimension(width, width);
            this.max = new Dimension(width, Integer.MAX_VALUE);
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int height = size.height - 0;
            g.setColor(this.getBackground());
            int x = 0;
            while (x + 1 < size.width) {
                int y = 2;
                while (y + 1 < height) {
                    g.setColor(this.getBackground().brighter());
                    g.drawLine(x, y, x, y);
                    if (x + 5 < size.width && y + 5 < height) {
                        g.drawLine(x + 2, y + 2, x + 2, y + 2);
                    }
                    g.setColor(this.getBackground().darker().darker());
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    if (x + 5 < size.width && y + 5 < height) {
                        g.drawLine(x + 3, y + 3, x + 3, y + 3);
                    }
                    y += 4;
                }
                x += 4;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    final class Folder
    extends FolderInstance {
        static /* synthetic */ Class class$java$awt$Component;
        static /* synthetic */ Class class$org$openide$util$actions$Presenter$Toolbar;
        static /* synthetic */ Class class$javax$swing$Action;

        public Folder() {
            super(Toolbar.this.backingFolder);
            this.recreate();
        }

        public String instanceName() {
            return Toolbar.this.getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return Toolbar.this.getClass();
        }

        protected InstanceCookie acceptDataObject(DataObject dob) {
            InstanceCookie ic = super.acceptDataObject(dob);
            if (ic == null) {
                JButton button = ExecBridge.createButton(dob);
                return button != null ? new InstanceSupport.Instance(button) : null;
            }
            return ic;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class c;
            InstanceCookie.Of of;
            boolean is = cookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)cookie).instanceOf(class$java$awt$Component == null ? (class$java$awt$Component = Folder.class$("java.awt.Component")) : class$java$awt$Component) || of.instanceOf(class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = Folder.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar) || of.instanceOf(class$javax$swing$Action == null ? (class$javax$swing$Action = Folder.class$("javax.swing.Action")) : class$javax$swing$Action) : (class$java$awt$Component == null ? (class$java$awt$Component = Folder.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(c = cookie.instanceClass()) || (class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = Folder.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar).isAssignableFrom(c) || (class$javax$swing$Action == null ? (class$javax$swing$Action = Folder.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(c);
            return is ? cookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return null;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            Toolbar.this.removeAll();
            int i = 0;
            while (i < cookies.length) {
                try {
                    Object obj = cookies[i].instanceCreate();
                    if (obj instanceof Presenter.Toolbar) {
                        obj = ((Presenter.Toolbar)obj).getToolbarPresenter();
                    }
                    if (obj instanceof Component) {
                        if (obj instanceof JComponent && "Fixed".equals(((JComponent)obj).getClientProperty("Toolbar"))) {
                            Toolbar.this.floatable = false;
                            Toolbar.this.removeAll();
                            Toolbar.this.setBorder(null);
                        }
                        Toolbar.this.add((Component)obj);
                    } else if (obj instanceof Action) {
                        Action a = (Action)obj;
                        JButton b = new JButton();
                        Actions.connect((AbstractButton)b, a);
                        Toolbar.this.add(b);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, ex);
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, ex);
                }
                ++i;
            }
            Toolbar.this.invalidate();
            Container parent = Toolbar.this.getParent();
            while (parent != null && !(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                parent.validate();
                parent.repaint();
            }
            return Toolbar.this;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class ToolbarMouseListener
    extends MouseInputAdapter {
        private boolean dragging = false;
        private Point startPoint = null;

        ToolbarMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.startPoint = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragging) {
                int dx = Toolbar.this.getX() + e.getX() - this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : e.getX() - this.startPoint.x;
                Toolbar.this.fireDropToolbar(dx, e.getY() - this.startPoint.y, 1);
                this.dragging = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            int m = e.getModifiers();
            int type = 1;
            if (e.isControlDown()) {
                type = 3;
            } else if ((m & 8) != 0 || (m & 4) != 0) {
                type = 2;
            }
            if (this.startPoint == null) {
                this.startPoint = new Point(e.getX(), e.getY());
            }
            int dx = Toolbar.this.getX() + e.getX() + this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? (Toolbar.this.getX() >= Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH - Toolbar.this.getX()) : e.getX() - this.startPoint.x;
            Toolbar.this.fireDragToolbar(dx, e.getY() - this.startPoint.y, type);
            this.dragging = true;
        }
    }
}

