/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.io;

/**
 * Small scrap of data.
 * This is a simple struct (no behaviour) for a small piece of
 * data received from a fragmented GIOP message.
 *
 * @author Chris Wood
 * @version $Revision: 1.6 $ $Date: 2002/06/28 08:59:05 $ 
 */
class Scrap
{
    /** Default size of a scrap's buffer. */
    public static final int DEFAULT_SCRAP = 2048;

    /** Normal internal scrap. */
    public static final int MODE_NORMAL = 0x00;
    /** A scrap that shares buffer space with a buffer further down the list. */
    public static final int MODE_SHARED = 0x01;
    /** The scrap's buffer space is readonly. Clone it to make it read-write. */
    public static final int MODE_READONLY = 0x03;

    public byte [] fBuffer;
    public int fOffset;
    public int fLength;
    public int fPosition;
    
    /** The mode of this scrap. See MODE_* constants in this class. */
    public int fMode;

    /** Next scrap instance in the list. */
    public Scrap fNext = null;
};
