/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.orb;

import java.util.Iterator;
import org.openorb.CORBA.kernel.Configurator;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.CORBA.kernel.Property;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * This class provides a default configurator.
 * 
 * @author Jerome Daniel
 * @version $Revision: 1.6 $ $Date: 2002/08/21 08:19:24 $ 
 */

public class DefaultConfigurator implements org.openorb.compiler.Configurator
{
    public void updateInfo( java.util.Vector includeList, java.util.Vector importLink )
    {
        Configurator cfg = new Configurator( new String[ 0 ], null, org.openorb.util.Trace.getLogger() );

        Properties props = cfg.getProperties();

        // get directories for file includes
        Iterator itt = props.properties( "compiler.idl" );

        while ( itt.hasNext() )
        {
            Property prop = ( Property ) itt.next();

            try
            {
                includeList.addElement( prop.getURLValue() );
            }
            catch ( org.omg.CORBA.INITIALIZE ex )
            {
                // ignore non-urlable compiler.idl properties.
            }

        }

        // add default include directory. This should be last on the include list.


        URL openorbDir = props.getURLProperty( "openorb.home", null );

        if ( openorbDir != null )
        {
            try
            {
                includeList.addElement( new URL( openorbDir, "idl/" ) );
            }
            catch ( MalformedURLException ex )
            {}

        }

        // get import list


        itt = props.properties( "compiler.import" );

        while ( itt.hasNext() )
        {
            Property next = ( Property ) itt.next();
            String key = next.getName().substring( "compiler.import".length() + 1 ) + ":"
                         + next.getValue();
            importLink.addElement( key );
        }
    }
}
