package org.omg.CORBA;

/**
 * TRANSACTION_MODE exception is raised by the ORB when it detects a
 * mismatch between the TransactionPolicy in the IOR and the current
 * transaction mode.
 * 
 * @since  CORBA 3.0
 */

public class TRANSACTION_MODE extends org.omg.CORBA.SystemException
{
    //
    // Default constructor
    //
    public TRANSACTION_MODE()
    {
        super( null, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with reason string
    //
    public TRANSACTION_MODE( String orb_reason )
    {
        super( orb_reason, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public TRANSACTION_MODE( int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( null, minor, completed );
    }

    //
    // Full constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public TRANSACTION_MODE( String orb_reason, int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( orb_reason, minor, completed );
    }
}
