/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.CORBA.ORB;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.HeaderBlock;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPClientRequest;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.iiop.SocketQueue;
import org.openorb.io.BufferSource;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.Channel;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerRequest;
import org.openorb.net.Transport;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.Trace;

public class IIOPClientChannel
implements ClientChannel {
    private static final int CONN_SC_TOTAL = 2;
    private static final int CONN_SC_CODESETS = 0;
    private static final int CONN_SC_BIDIR = 1;
    private static final int CONN_SC_STATUS_UNSENT = 0;
    private static final int CONN_SC_STATUS_PEND = 1;
    private static final int CONN_SC_STATUS_SENT = 2;
    private static final byte[] RESERVED = new byte[]{0, 0, 0};
    private org.omg.CORBA.ORB m_orb;
    private IIOPClientProtocol m_client_protocol;
    private ClientManager m_client_manager;
    private java.lang.Object m_sync_state;
    private int m_state = 0x12000000;
    private boolean m_first_connect = true;
    private boolean m_paused = false;
    private boolean m_pending_close = false;
    private boolean m_pending_service_ctxt = false;
    private SocketQueue m_socket_queue;
    private org.omg.IIOP.Version m_version = new org.omg.IIOP.Version(1, 0);
    private SystemException m_close_exception = null;
    private short m_disposition = 0;
    private Logger m_logger = null;
    private Map m_active_requests = new HashMap();
    private int m_channel_age = 0;
    private int m_tcsc;
    private int m_tcsw;
    private int[] m_service_ctxts_sent = null;
    private boolean m_delegated = false;
    private IIOPServerProtocol m_server_protocol;
    private IIOPServerChannel m_server_peer;
    private Constructor m_os_ctor;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$MarshalBuffer;

    IIOPClientChannel(IIOPClientProtocol protocol, Transport transp, IIOPServerProtocol serverProtocol, int tcsc, int tcsw) {
        this.m_client_protocol = protocol;
        this.m_orb = this.m_client_protocol.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        this.m_client_manager = this.m_client_protocol.getClientManager();
        this.m_socket_queue = new SocketQueue(transp);
        this.m_socket_queue.setClientChannel(this);
        this.m_sync_state = new java.lang.Object();
        this.m_server_protocol = serverProtocol;
        this.m_tcsc = tcsc;
        this.m_tcsw = tcsw;
        try {
            Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", cargs);
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to initialize output stream constructor.", ex);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + ex + ")"), (Throwable)ex);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
    }

    IIOPClientChannel(IIOPClientProtocol protocol, IIOPServerChannel peer) {
        this.m_client_protocol = protocol;
        this.m_orb = this.m_client_protocol.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        this.m_client_manager = this.m_client_protocol.getClientManager();
        this.m_server_peer = peer;
        this.m_socket_queue = this.m_server_peer.getSocketQueue();
        this.m_socket_queue.setClientChannel(this);
        this.m_sync_state = this.m_server_peer.getSyncState();
        this.m_state = 0x11000000;
        this.m_delegated = true;
        this.m_tcsc = this.m_server_peer.getTCSC();
        this.m_tcsw = this.m_server_peer.getTCSW();
        try {
            Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", cargs);
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to initialize output stream constructor.", ex);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + ex + ")"), (Throwable)ex);
        }
    }

    public Map getActiveRequestMap() {
        return this.m_active_requests;
    }

    public SocketQueue getSocketQueue() {
        return this.m_socket_queue;
    }

    public java.lang.Object getSyncState() {
        return this.m_sync_state;
    }

    public int getChannelAge() {
        return this.m_channel_age;
    }

    public void setServerPeer(IIOPServerChannel srvchan) {
        this.m_server_peer = srvchan;
    }

    public void setCloseException(SystemException closeex) {
        this.m_close_exception = closeex;
    }

    public int getTCSC() {
        return this.m_tcsc;
    }

    public void setTCSC(int tcsc) {
        this.m_tcsc = tcsc;
    }

    public int getTCSW() {
        return this.m_tcsw;
    }

    public void setTCSW(int tcsw) {
        this.m_tcsw = tcsw;
    }

    public void setPendingClose() {
        this.m_pending_close = true;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int state() {
        if (this.m_delegated) {
            java.lang.Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_server_peer != null) {
                    return 0x11000000;
                }
                return 0x12000000;
            }
        }
        return this.m_state;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    boolean isDelegated() {
        return this.m_delegated;
    }

    public String toString() {
        return "ClientChannel: " + this.m_socket_queue.toString();
    }

    public org.omg.IIOP.Version version() {
        return this.m_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int active_requests() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            return this.m_active_requests.size() + (this.m_server_peer != null ? this.m_server_peer.getActiveRequestMap().size() : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int channel_age() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_active_requests.isEmpty() || this.m_server_peer != null && !this.m_server_peer.getActiveRequestMap().isEmpty()) {
                return RequestIDAllocator.peek_request_id();
            }
            if (this.m_server_peer != null && this.m_channel_age < this.m_server_peer.getChannelAge()) {
                return this.m_server_peer.getChannelAge();
            }
            return this.m_channel_age;
        }
    }

    private void request_open(Object target, Address address) {
        switch (this.m_state) {
            case 0x11000000: {
                return;
            }
            case 0x13000000: {
                throw this.m_close_exception;
            }
        }
        if (this.m_delegated && this.m_server_peer == null) {
            throw new TRANSIENT(0, CompletionStatus.COMPLETED_NO);
        }
        this.m_socket_queue.open();
        this.m_state = 0x11000000;
        this.m_first_connect = false;
        this.m_pending_close = false;
        this.m_close_exception = null;
        this.connectionSCReset();
        this.m_server_peer = null;
        this.m_client_manager.register_channel(this);
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " opened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (this.m_delegated) {
            this.m_server_peer.soft_close(false);
            return;
        }
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.active_requests() > 0) {
                return;
            }
            if (this.m_state != 0x11000000) {
                return;
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " paused");
            }
            this.m_state = 0x12000000;
            if (this.m_server_peer != null) {
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
            this.m_paused = true;
        }
        this.m_client_manager.unregister_channel(this);
        this.m_socket_queue.close();
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            this.m_paused = false;
            this.m_sync_state.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void server_pause(SystemException ex) {
        Channel name;
        this.getLogger().debug("server_pause invocation caused by", ex);
        IIOPServerChannel peer = null;
        ServerRequest[] serverRequests = null;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state != 0x11000000) {
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug(this + " already closed");
                }
                return;
            }
            this.m_state = 0x12000000;
            if (this.m_server_peer != null) {
                Map actreq = this.m_server_peer.getActiveRequestMap();
                if (!actreq.isEmpty()) {
                    serverRequests = new ServerRequest[actreq.size()];
                    actreq.values().toArray(serverRequests);
                    actreq.clear();
                }
                peer = this.m_server_peer;
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
            this.m_paused = true;
        }
        if (this.m_delegated) {
            name = peer;
            peer.getServerManager().unregister_channel(peer);
        } else {
            name = this;
            this.m_client_manager.unregister_channel(this);
        }
        this.m_socket_queue.close();
        IIOPClientRequest[] clientRequests = null;
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            this.m_paused = false;
            this.m_sync_state.notifyAll();
            if (!this.m_active_requests.isEmpty()) {
                clientRequests = new IIOPClientRequest[this.m_active_requests.size()];
                this.m_active_requests.values().toArray(clientRequests);
                this.m_active_requests.clear();
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(name.toString() + (this.m_delegated ? "paused by client" : "paused by server"));
            }
        }
        if (clientRequests != null) {
            int i = 0;
            while (i < clientRequests.length) {
                clientRequests[i].cancel(ex);
                ++i;
            }
        }
        if (serverRequests != null) {
            int i = 0;
            while (i < serverRequests.length) {
                serverRequests[i].client_cancel();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean kill_requests, SystemException ex) {
        if (this.m_delegated) {
            if (kill_requests) {
                this.m_server_peer.close();
            } else {
                this.m_server_peer.soft_close(this.m_pending_close);
            }
            return;
        }
        IIOPClientRequest[] clientRequests = null;
        ServerRequest[] serverRequests = null;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0x12000000) {
                boolean interrupted = false;
                while (this.m_paused) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException ir) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                this.m_close_exception = ex;
                this.m_state = 0x13000000;
                return;
            }
            if (this.m_state == 0x13000000) {
                return;
            }
            this.m_state = 0x13000000;
            this.m_close_exception = ex;
            if (!kill_requests && this.active_requests() > 0) {
                this.m_pending_close = true;
                if (this.m_server_peer != null) {
                    this.m_server_peer.setPendingClose();
                }
                return;
            }
            clientRequests = new IIOPClientRequest[this.m_active_requests.size()];
            this.m_active_requests.values().toArray(clientRequests);
            this.m_active_requests.clear();
            if (this.m_server_peer != null) {
                Map actreq = this.m_server_peer.getActiveRequestMap();
                serverRequests = new ServerRequest[actreq.size()];
                actreq.values().toArray(serverRequests);
                actreq.clear();
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
        }
        this.m_client_manager.unregister_channel(this);
        this.m_socket_queue.close();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
        if (clientRequests != null) {
            int i = 0;
            while (i < clientRequests.length) {
                clientRequests[i].cancel(ex);
                ++i;
            }
        }
        if (serverRequests != null) {
            int i = 0;
            while (i < serverRequests.length) {
                serverRequests[i].client_cancel();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRequest create_request(Object target, Address address, java.lang.Object tpAssc, String operation, boolean response_expected) throws RebindChannelException {
        int request_id = RequestIDAllocator.get_request_id() << 1;
        if (this.m_delegated) {
            --request_id;
        }
        IIOPClientRequest request = new IIOPClientRequest(request_id, target, address, tpAssc, this, operation, response_expected);
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            this.check_rebind(address);
            this.m_active_requests.put(NumberCache.getInteger(request_id), request);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + request_id + " created");
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRequest create_locate_request(Object target, Address address, java.lang.Object tpAssc) throws RebindChannelException {
        int request_id = RequestIDAllocator.get_request_id() << 1;
        if (this.m_delegated) {
            --request_id;
        }
        IIOPClientRequest request = new IIOPClientRequest(request_id, target, address, tpAssc, this);
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            this.check_rebind(address);
            this.m_active_requests.put(NumberCache.getInteger(request_id), request);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " locate request #" + request_id + " created");
        }
        return request;
    }

    private void check_rebind(Address address) throws RebindChannelException {
        if (this.m_delegated && this.m_server_peer == null) {
            this.m_client_protocol.rebindBidirDelegate(this, (IIOPAddress)address);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel_request(IIOPClientRequest request, boolean sendMesg) {
        int req_id = request.request_id();
        boolean closeChan = false;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0x13000000) {
                return false;
            }
            if (this.m_pending_service_ctxt && !request.is_locate()) {
                this.connectionSCCanceled();
                this.m_pending_service_ctxt = false;
                this.m_sync_state.notifyAll();
            }
            if (this.m_active_requests.isEmpty() || this.m_active_requests.remove(NumberCache.getInteger(req_id)) == null) {
                return false;
            }
            if (this.m_active_requests.isEmpty()) {
                this.m_channel_age = RequestIDAllocator.peek_request_id();
                closeChan = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + req_id + " canceled");
        }
        if (closeChan) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
            return true;
        }
        if (sendMesg) {
            long size = 4L;
            byte[] cancel = new byte[]{71, 73, 79, 80, this.m_version.major, this.m_version.minor, 0, 2, (byte)(size >>> 24), (byte)(size >>> 16), (byte)(size >>> 8), (byte)size, (byte)(req_id >>> 24), (byte)(req_id >>> 16), (byte)(req_id >>> 8), (byte)req_id};
            StorageBuffer buf = new StorageBuffer(cancel, 0, cancel.length);
            this.m_socket_queue.send(buf, request.get_transport_association());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream begin_marshal(IIOPClientRequest req) {
        CDROutputStream os;
        short req_disposition;
        org.omg.IIOP.Version iiopvers = ((IIOPAddress)req.address()).get_version();
        Version req_vers = new Version(1, 0);
        boolean addCodesets = false;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            boolean isRequest;
            if (this.m_version.minor < iiopvers.minor) {
                this.m_version.minor = iiopvers.minor;
            }
            req_vers.minor = this.m_version.minor;
            boolean bl = isRequest = !req.is_locate();
            if (isRequest) {
                while (this.m_paused || this.m_pending_service_ctxt) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            this.request_open(req.target(), req.address());
            if (isRequest) {
                this.m_pending_service_ctxt = this.connectionSCAdd(req);
            }
            req_disposition = this.m_disposition;
        }
        MarshalBuffer buf = new MarshalBuffer(new MarshalListener(), req);
        try {
            os = (CDROutputStream)this.m_os_ctor.newInstance(req.orb(), req_vers, buf);
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to create CDROutputStream class.", ex);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + ex + ")"), (Throwable)ex);
        }
        os.setCodesets(this.m_tcsc, this.m_tcsw);
        int req_id = req.request_id();
        if (req.is_request()) {
            new HeaderBlock(0, req_id, os);
            switch (req_vers.minor) {
                case 0: 
                case 1: {
                    ServiceContextListHelper.write(os, req.get_request_service_contexts());
                    os.write_long(req_id);
                    os.write_boolean(req.response_expected());
                    OctetSeqHelper.write(os, req.address().getTargetAddress((short)0).object_key());
                    os.write_string(req.operation());
                    os.write_long(0);
                    break;
                }
                case 2: {
                    os.write_long(req_id);
                    os.allowFragment();
                    switch (req.sync_scope()) {
                        case 0: 
                        case 1: {
                            os.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            os.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            os.write_octet((byte)3);
                        }
                    }
                    os.write_octet_array(RESERVED, 0, 3);
                    TargetAddressHelper.write(os, req.address().getTargetAddress(req_disposition));
                    os.write_string(req.operation());
                    ServiceContextListHelper.write(os, req.get_request_service_contexts());
                    os.pending_alignment(8);
                }
            }
        } else {
            new HeaderBlock(3, req_id, os);
            os.write_long(req_id);
            switch (req_vers.minor) {
                case 0: 
                case 1: {
                    byte[] oid = req.address().getTargetAddress((short)0).object_key();
                    OctetSeqHelper.write(os, oid);
                    break;
                }
                case 2: {
                    os.allowFragment();
                    TargetAddressHelper.write(os, req.address().getTargetAddress(req_disposition));
                }
            }
        }
        return os;
    }

    protected boolean connectionSCAdd(IIOPClientRequest req) {
        if (this.m_service_ctxts_sent == null) {
            return false;
        }
        boolean addSent = false;
        boolean addPend = false;
        if (this.m_service_ctxts_sent[0] == 0 && this.m_version.minor > 0) {
            if (this.m_tcsc != 0 || this.m_tcsw != 0) {
                byte[] data = new byte[]{0, 0, 0, 0, (byte)(this.m_tcsc >>> 24), (byte)(this.m_tcsc >>> 16), (byte)(this.m_tcsc >>> 8), (byte)this.m_tcsc, (byte)(this.m_tcsw >>> 24), (byte)(this.m_tcsw >>> 16), (byte)(this.m_tcsw >>> 8), (byte)this.m_tcsw};
                ServiceContext _codesetSC = new ServiceContext(1, data);
                req.add_request_service_context(_codesetSC, true);
                this.m_service_ctxts_sent[0] = 1;
                addPend = true;
            } else {
                this.m_service_ctxts_sent[0] = 2;
                addSent = true;
            }
        }
        if (this.m_service_ctxts_sent[1] == 0) {
            ServiceContext sc = this.m_client_protocol.getBiDirSC();
            if (sc != null) {
                BidirectionalPolicy pol = null;
                try {
                    pol = BidirectionalPolicyHelper.narrow(req.get_request_policy(37));
                }
                catch (INV_POLICY ex) {
                    // empty catch block
                }
                if (pol != null && pol.value() == 1) {
                    this.m_server_peer = new IIOPServerChannel(this.m_server_protocol.getServerManager(), this, this.m_client_protocol.getCodec());
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug(this + " became bidirectional with peer " + this.m_server_peer.toString());
                    }
                    req.add_request_service_context(sc, true);
                    this.m_service_ctxts_sent[1] = 1;
                    addPend = true;
                }
            } else {
                this.m_service_ctxts_sent[1] = 2;
                addSent = true;
            }
        }
        if (addPend) {
            return true;
        }
        if (addSent) {
            boolean allSent = true;
            int i = 0;
            while (i < this.m_service_ctxts_sent.length) {
                allSent = this.m_service_ctxts_sent[i] == 2;
                if (!allSent) break;
                ++i;
            }
            if (allSent) {
                this.m_service_ctxts_sent = null;
            }
        }
        return false;
    }

    protected void connectionSCSent() {
        if (this.m_service_ctxts_sent != null) {
            boolean allSent = true;
            int i = 0;
            while (i < this.m_service_ctxts_sent.length) {
                if (this.m_service_ctxts_sent[i] != 0) {
                    this.m_service_ctxts_sent[i] = 2;
                } else {
                    allSent = false;
                }
                ++i;
            }
            if (allSent) {
                this.m_service_ctxts_sent = null;
            }
        }
    }

    protected void connectionSCCanceled() {
        if (this.m_service_ctxts_sent != null) {
            int i = 0;
            while (i < this.m_service_ctxts_sent.length) {
                if (this.m_service_ctxts_sent[i] == 1) {
                    this.m_service_ctxts_sent[i] = 0;
                }
                ++i;
            }
        }
    }

    protected void connectionSCReset() {
        this.m_service_ctxts_sent = new int[2];
    }

    public boolean recv(int timeout) {
        if (this.m_delegated) {
            return false;
        }
        return this.m_socket_queue.receive(timeout);
    }

    public void run_recv() {
        if (this.m_delegated) {
            return;
        }
        while (!Thread.interrupted() && this.m_socket_queue.receive(1000)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int process_reply(byte minor, CDRInputStream is, byte msg_type, boolean fragFollows, BufferSource source, java.lang.Object tpAssc) {
        int reply_status = -1;
        ServiceContext[] reply_service_contexts = null;
        is.setCodesets(this.m_tcsc, this.m_tcsw);
        int req_id = 0;
        IIOPClientRequest request = null;
        boolean closeChan = false;
        try {
            try {
                if (minor < 2 && msg_type == 1) {
                    reply_service_contexts = ServiceContextListHelper.read(is);
                }
                req_id = is.read_long();
                java.lang.Object object = this.m_sync_state;
                synchronized (object) {
                    if (fragFollows) {
                        request = (IIOPClientRequest)this.m_active_requests.get(NumberCache.getInteger(req_id));
                    } else {
                        request = (IIOPClientRequest)this.m_active_requests.remove(NumberCache.getInteger(req_id));
                        if (this.m_active_requests.isEmpty()) {
                            this.m_channel_age = RequestIDAllocator.peek_request_id();
                            closeChan = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
                        }
                    }
                }
                if (request == null) {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + req_id + (fragFollows ? "" : " last") + " reply fragment discarded, no corresponding request.");
                    }
                } else if (!request.checkReplyTransportAssoc(tpAssc)) {
                    request = null;
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + req_id + (fragFollows ? "" : " last") + " reply fragment discarded, sender not authorized.");
                    }
                } else {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + req_id + (fragFollows ? "" : " last") + " reply fragment received");
                    }
                    request.setReplySource(source);
                    reply_status = is.read_long();
                    if (minor >= 2) {
                        if (msg_type == 1) {
                            reply_service_contexts = ServiceContextListHelper.read(is);
                        }
                        try {
                            is.alignment(8);
                        }
                        catch (MARSHAL ex1) {
                        }
                    }
                }
                java.lang.Object var15_17 = null;
            }
            catch (SystemException ex) {
                if (request == null) {
                    this.close(true, this.m_close_exception);
                } else {
                    request.cancel(ex);
                }
                int n = req_id;
                java.lang.Object var15_18 = null;
                source.removeWaitingForBufferListener(null);
                return n;
            }
            source.removeWaitingForBufferListener(null);
        }
        catch (Throwable throwable) {
            java.lang.Object var15_19 = null;
            source.removeWaitingForBufferListener(null);
            throw throwable;
        }
        if (request != null) {
            request.handle_reply(reply_status, reply_service_contexts, is);
        }
        if (closeChan) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
        }
        return req_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process_fragment(int req_id, StorageBuffer buf, boolean fragFollows, java.lang.Object tpAssc) {
        IIOPClientRequest request;
        boolean closeChan = false;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (fragFollows) {
                request = (IIOPClientRequest)this.m_active_requests.get(NumberCache.getInteger(req_id));
            } else {
                request = (IIOPClientRequest)this.m_active_requests.remove(NumberCache.getInteger(req_id));
                if (this.m_active_requests.isEmpty()) {
                    this.m_channel_age = RequestIDAllocator.peek_request_id();
                    closeChan = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
                }
            }
        }
        if (request == null) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + "request #" + req_id + (fragFollows ? "" : " last") + " reply fragment discarded, no corresponding request.");
            }
        } else if (!request.checkReplyTransportAssoc(tpAssc)) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + "request #" + req_id + (fragFollows ? "" : " last") + " reply fragment discarded, sender not authorized.");
            }
        } else {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + " request #" + req_id + (fragFollows ? "" : " last") + " reply fragment.");
            }
            request.getReplySource().addLast(buf, !fragFollows);
        }
        if (closeChan) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(false, new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO));
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private boolean m_fragment_sent = false;

        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer buffer, int available, java.lang.Object cookie) {
            while (available > 120000) {
                this.m_fragment_sent = true;
                IIOPClientRequest request = (IIOPClientRequest)cookie;
                if (request.state() != 1) {
                    return;
                }
                StorageBuffer buf = buffer.fragment(120000);
                if (IIOPClientChannel.this.m_socket_queue.send(buf, request.get_transport_association()) && IIOPClientChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    IIOPClientChannel.this.getLogger().info(IIOPClientChannel.this + "request #" + request.request_id() + " fragment sent");
                }
                available -= 120000;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferClosed(MarshalBuffer buffer, int available, java.lang.Object cookie) {
            IIOPClientRequest request = (IIOPClientRequest)cookie;
            if (request.state() != 1) {
                return;
            }
            StorageBuffer buf = buffer.lastFragment();
            if (IIOPClientChannel.this.m_socket_queue.send(buf, request.get_transport_association()) && IIOPClientChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                IIOPClientChannel.this.getLogger().debug(IIOPClientChannel.this + " request #" + request.request_id() + " last fragment sent");
            }
            if (IIOPClientChannel.this.m_pending_service_ctxt && !request.is_locate()) {
                java.lang.Object object = IIOPClientChannel.this.m_sync_state;
                synchronized (object) {
                    IIOPClientChannel.this.connectionSCSent();
                    IIOPClientChannel.this.m_pending_service_ctxt = false;
                    IIOPClientChannel.this.m_sync_state.notifyAll();
                }
            }
        }

        public void bufferCanceled(MarshalBuffer buffer, SystemException ex, java.lang.Object cookie) {
            IIOPClientRequest request = (IIOPClientRequest)cookie;
            IIOPClientChannel.this.cancel_request(request, this.m_fragment_sent);
            if (request.state() != 1) {
                return;
            }
            ex.completed = CompletionStatus.COMPLETED_NO;
            request.cancel(ex);
            throw ex;
        }
    }
}

