/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.FolderList;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ProxyLookup;

public class FolderLookup
extends FolderInstance {
    private static final Object LOCK = new Object();
    private ProxyLkp lookup;
    private String rootName;
    private final boolean isRoot;
    static /* synthetic */ Class class$org$openide$loaders$FolderLookup$ProxyLkp;
    static /* synthetic */ Class class$org$openide$util$Lookup;

    public FolderLookup(DataObject.Container df) {
        this(df, "FL[");
    }

    public FolderLookup(DataObject.Container df, String prefix) {
        this(df, prefix, true);
    }

    private FolderLookup(DataObject.Container df, String prefix, boolean isRoot) {
        super(df);
        this.rootName = prefix;
        this.isRoot = isRoot;
    }

    public final Class instanceClass() {
        return class$org$openide$loaders$FolderLookup$ProxyLkp == null ? (class$org$openide$loaders$FolderLookup$ProxyLkp = FolderLookup.class$("org.openide.loaders.FolderLookup$ProxyLkp")) : class$org$openide$loaders$FolderLookup$ProxyLkp;
    }

    public final Lookup getLookup() {
        boolean inited = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.lookup == null) {
                this.lookup = new ProxyLkp(this);
                inited = true;
            }
        }
        if (inited) {
            this.checkRecreate();
        }
        return this.lookup;
    }

    protected final Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        FolderLookupData flData = new FolderLookupData();
        if (this.isRoot) {
            flData.lookups.add(null);
        }
        int i = 0;
        while (i < cookies.length) {
            try {
                Object obj = cookies[i].instanceCreate();
                if (obj instanceof FolderLookupData) {
                    flData.items.addAll(((FolderLookupData)obj).items);
                    flData.lookups.addAll(((FolderLookupData)obj).lookups);
                } else if (obj instanceof Lookup) {
                    flData.lookups.add(obj);
                } else {
                    flData.items.add(obj);
                }
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            ++i;
        }
        if (!this.isRoot) {
            return flData;
        }
        this.getLookup();
        this.lookup.update(flData.items, flData.lookups);
        return this.lookup;
    }

    protected Object instanceForCookie(DataObject dobj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        boolean isLookup = cookie instanceof InstanceCookie.Of ? ((InstanceCookie.Of)cookie).instanceOf(class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup) : (class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup).isAssignableFrom(cookie.instanceClass());
        if (isLookup) {
            return cookie.instanceCreate();
        }
        return new ICItem(dobj, this.rootName, cookie);
    }

    protected InstanceCookie acceptFolder(DataFolder df) {
        return new FolderLookup(df, FolderLookup.objectName(this.rootName, df), false);
    }

    protected InstanceCookie acceptContainer(DataObject.Container df) {
        return new FolderLookup(df, this.rootName == null ? "<container>" : this.rootName + "<container>", false);
    }

    protected final Task postCreationTask(Runnable run) {
        run.run();
        return null;
    }

    private static String objectName(String name, DataObject obj) {
        if (name == null) {
            return obj.getName();
        }
        return name + '/' + obj.getName();
    }

    private static void exception(Exception e) {
        ErrorManager.getDefault().notify(1, e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FolderLookupData {
        private Collection items = new ArrayList(30);
        private List lookups = new ArrayList(5);
    }

    private static final class ICItem
    extends AbstractLookup.Pair
    implements Serializable {
        static final long serialVersionUID = 10L;
        private FileObject fo;
        private transient InstanceCookie ic;
        private transient DataObject obj;
        private transient WeakReference ref;
        private String rootName;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
        static /* synthetic */ Class class$java$lang$Object;

        public ICItem(DataObject obj, String rootName, InstanceCookie ic) {
            this.ic = ic;
            this.obj = obj;
            this.rootName = rootName;
            this.fo = obj.getPrimaryFile();
        }

        public void init() {
            if (this.ic != null) {
                return;
            }
            if (this.obj == null) {
                try {
                    this.obj = DataObject.find(this.fo);
                }
                catch (DataObjectNotFoundException donfe) {
                    this.ic = new BrokenInstance("File: " + this.fo.getPath(), donfe);
                    return;
                }
            }
            this.ic = (InstanceCookie)this.obj.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ICItem.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (this.ic == null) {
                this.ic = new BrokenInstance("File: " + this.fo.getPath(), null);
            }
        }

        protected boolean instanceOf(Class clazz) {
            this.init();
            if (this.ic instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.ic;
                return of.instanceOf(clazz);
            }
            try {
                return clazz.isAssignableFrom(this.ic.instanceClass());
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            return false;
        }

        public Object getInstance() {
            this.init();
            try {
                Object obj = this.ic.instanceCreate();
                this.ref = new WeakReference<Object>(obj);
                return obj;
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            return null;
        }

        public int hashCode() {
            this.init();
            return System.identityHashCode(this.ic);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICItem) {
                ICItem i = (ICItem)obj;
                i.init();
                this.init();
                return this.ic == i.ic;
            }
            return false;
        }

        public String getId() {
            this.init();
            if (this.obj == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return FolderLookup.objectName(this.rootName, this.obj);
        }

        public String getDisplayName() {
            this.init();
            if (this.obj == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return this.obj.getNodeDelegate().getDisplayName();
        }

        protected boolean creatorOf(Object obj) {
            WeakReference w = this.ref;
            return w != null && w.get() == obj;
        }

        public Class getType() {
            this.init();
            try {
                return this.ic.instanceClass();
            }
            catch (IOException ex) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = ICItem.class$("java.lang.Object")) : class$java$lang$Object;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static final class BrokenInstance
        implements InstanceCookie.Of {
            private final String message;
            private final Exception ex;

            public BrokenInstance(String message, Exception ex) {
                this.message = message;
                this.ex = ex;
            }

            public String instanceName() {
                return "java.lang.Object";
            }

            private ClassNotFoundException die() {
                if (this.ex != null) {
                    return new ClassNotFoundException(this.message, this.ex);
                }
                return new ClassNotFoundException(this.message);
            }

            public Class instanceClass() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public boolean instanceOf(Class type) {
                return false;
            }
        }
    }

    private static final class ProxyLkp
    extends ProxyLookup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient FolderLookup fl;
        private transient AbstractLookup.Content content;
        private transient boolean readFromStream;

        public ProxyLkp(FolderLookup folder) {
            this(folder, new AbstractLookup.Content());
        }

        private ProxyLkp(FolderLookup folder, AbstractLookup.Content content) {
            super(new Lookup[]{new AbstractLookup(content)});
            this.fl = folder;
            this.content = content;
        }

        public String toString() {
            return "FolderLookup.lookup[\"" + this.fl.rootName + "\"]";
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            Lookup[] ls = this.getLookups();
            int i = 0;
            while (i < ls.length) {
                oos.writeObject(ls[i]);
                ++i;
            }
            oos.writeObject(null);
            oos.writeObject(this.fl.folder);
            oos.writeObject(this.fl.rootName);
            oos.writeObject(this.content);
        }

        /*
         * WARNING - void declaration
         */
        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            Lookup l;
            ArrayList<void> ls = new ArrayList<void>();
            while ((l = (Lookup)ois.readObject()) != null) {
                void var3_3;
                ls.add(var3_3);
            }
            Lookup[] arr = ls.toArray(new Lookup[ls.size()]);
            DataFolder df = (DataFolder)ois.readObject();
            String root = (String)ois.readObject();
            df.getChildren();
            this.fl = new FolderLookup(df, root, true);
            this.fl.lookup = this;
            this.content = (AbstractLookup.Content)ois.readObject();
            this.setLookups(arr);
            this.readFromStream = true;
        }

        public void update(Collection items, List lookups) {
            this.readFromStream = false;
            Lookup pairs = this.getLookups()[0];
            this.content.setPairs(items);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed pairs: " + items);
            }
            lookups.set(0, pairs);
            Lookup[] arr = lookups.toArray(new Lookup[lookups.size()]);
            this.setLookups(arr);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed lookups: " + lookups);
            }
        }

        protected void beforeLookup(Lookup.Template template) {
            if (this.readFromStream) {
                return;
            }
            if (!FolderList.isFolderRecognizerThread()) {
                this.fl.instanceFinished();
            }
        }
    }
}

