/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.ErrorManager;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Mutex;
import org.openide.util.WeakListener;
import org.openide.util.enum.QueueEnumeration;

final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE = new VisualizerNode(0);
    private static final Reference NO_REF = new WeakReference<Object>(null);
    private static WeakHashMap cache = new WeakHashMap();
    public static final VisualizerNode EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
    private static final QP QUEUE = new QP();
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.explorer.view.VisualizerNode");
    Node node;
    private int hashCode;
    private Reference children = NO_REF;
    private VisualizerChildren parent;
    private String name;
    private String displayName;
    private static final String UNKNOWN = new String();
    private String shortDescription;
    static final long serialVersionUID = 3726728244698316872L;
    static /* synthetic */ Class class$org$openide$explorer$view$NodeModel;

    public static synchronized VisualizerNode getVisualizer(VisualizerChildren ch, Node n) {
        VisualizerNode v;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(n);
        VisualizerNode.TEMPLATE.node = n;
        Reference r = (Reference)cache.get(TEMPLATE);
        VisualizerNode.TEMPLATE.hashCode = 0;
        VisualizerNode.TEMPLATE.node = null;
        VisualizerNode visualizerNode = v = r == null ? null : (VisualizerNode)r.get();
        if (v == null) {
            v = new VisualizerNode(n);
            cache.put(v, new WeakReference<VisualizerNode>(v));
        }
        if (ch != null) {
            v.parent = ch;
        }
        return v;
    }

    private VisualizerNode(int hashCode) {
        this.hashCode = hashCode;
        this.node = null;
    }

    private VisualizerNode(Node n) {
        this.node = n;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(WeakListener.node(this, this.node));
        this.name = UNKNOWN;
        this.displayName = UNKNOWN;
        this.shortDescription = UNKNOWN;
    }

    public String getShortDescription() {
        String desc = this.shortDescription;
        if (desc == UNKNOWN) {
            this.shortDescription = desc = this.node.getShortDescription();
        }
        return desc;
    }

    public String getDisplayName() {
        if (this.displayName == UNKNOWN) {
            this.displayName = this.node == null ? null : this.node.getDisplayName();
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == UNKNOWN) {
            this.name = this.node == null ? null : this.node.getName();
        }
        return this.name;
    }

    public List getChildren() {
        VisualizerChildren ch = (VisualizerChildren)this.children.get();
        if (ch == null && !this.node.isLeaf()) {
            Node[] tmpInit = this.node.getChildren().getNodes();
            ch = (VisualizerChildren)Children.MUTEX.readAccess(new Mutex.Action(){

                public Object run() {
                    Node[] nodes = VisualizerNode.this.node.getChildren().getNodes();
                    VisualizerChildren vc = new VisualizerChildren(VisualizerNode.this, nodes);
                    VisualizerNode.this.notifyVisualizerChildrenChange(nodes.length, vc);
                    return vc;
                }
            });
        }
        return ch == null ? Collections.EMPTY_LIST : ch.list;
    }

    public int getIndex(TreeNode p1) {
        return this.getChildren().indexOf(p1);
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public TreeNode getChildAt(int p1) {
        List ch = this.getChildren();
        VisualizerNode vn = (VisualizerNode)ch.get(p1);
        if (vn == null) {
            System.out.println("Children are: ");
            Iterator it = ch.iterator();
            while (it.hasNext()) {
                System.out.println("    " + it.next());
            }
            throw new IllegalStateException("VisualizerNode.getChildAt() returning null!");
        }
        return vn;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        if (err.isLoggable(1)) {
            List l = this.getChildren();
            if (l.contains(null)) {
                err.log("Children are: ");
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    err.log("    " + it.next());
                }
                throw new IllegalStateException("VisualizerNode.children() contains null!");
            }
            return Collections.enumeration(l);
        }
        return Collections.enumeration(this.getChildren());
    }

    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    public TreeNode getParent() {
        Node parent = this.node.getParentNode();
        return parent == null ? null : VisualizerNode.getVisualizer(null, parent);
    }

    public void childrenAdded(NodeMemberEvent ev) {
        VisualizerChildren ch = (VisualizerChildren)this.children.get();
        if (ch == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(ch, ev.getDelta(), ev.getDeltaIndices()));
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        VisualizerChildren ch = (VisualizerChildren)this.children.get();
        if (ch == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(ch, ev.getDelta()));
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.doChildrenReordered(ev.getPermutation());
    }

    void doChildrenReordered(int[] perm) {
        VisualizerChildren ch = (VisualizerChildren)this.children.get();
        if (ch == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(ch, perm));
    }

    public void nodeDestroyed(NodeEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("name".equals(name) || "displayName".equals(name) || "shortDescription".equals(name) || "icon".equals(name) || "openedIcon".equals(name)) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if ("leaf".equals(name)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualizerNode.this.children = NO_REF;
                    VisualizerNode parent = VisualizerNode.this;
                    while (parent != null) {
                        Object[] listeners = parent.getListenerList();
                        int i = listeners.length - 1;
                        while (i >= 0) {
                            ((NodeModel)listeners[i]).structuralChange(VisualizerNode.this);
                            i -= 2;
                        }
                        parent = (VisualizerNode)parent.getParent();
                    }
                }
            });
        }
    }

    public void run() {
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        VisualizerNode parent = this;
        while (parent != null) {
            Object[] listeners = parent.getListenerList();
            int i = listeners.length - 1;
            while (i >= 0) {
                ((NodeModel)listeners[i]).update(this);
                i -= 2;
            }
            parent = (VisualizerNode)parent.getParent();
        }
    }

    void notifyVisualizerChildrenChange(int size, VisualizerChildren ch) {
        this.children = size == 0 ? new StrongReference(ch) : new WeakReference<VisualizerChildren>(ch);
    }

    public synchronized void addNodeModel(NodeModel l) {
        this.add(class$org$openide$explorer$view$NodeModel == null ? (class$org$openide$explorer$view$NodeModel = VisualizerNode.class$("org.openide.explorer.view.NodeModel")) : class$org$openide$explorer$view$NodeModel, l);
    }

    public synchronized void removeNodeModel(NodeModel l) {
        this.remove(class$org$openide$explorer$view$NodeModel == null ? (class$org$openide$explorer$view$NodeModel = VisualizerNode.class$("org.openide.explorer.view.NodeModel")) : class$org$openide$explorer$view$NodeModel, l);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode v = (VisualizerNode)o;
        return v.node == this.node;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class QP
    implements Runnable {
        private QueueEnumeration queue = null;

        QP() {
        }

        public void runSafe(Runnable run) {
            boolean isNew = false;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    this.queue = new QueueEnumeration();
                    isNew = true;
                }
                this.queue.put(run);
            }
            if (isNew) {
                Mutex.EVENT.writeAccess(this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            QueueEnumeration en;
            QP qP = this;
            synchronized (qP) {
                en = this.queue;
                this.queue = null;
            }
            while (en.hasMoreElements()) {
                Runnable r = (Runnable)en.nextElement();
                r.run();
            }
        }
    }

    private static final class StrongReference
    extends WeakReference {
        private Object o;

        public StrongReference(Object o) {
            super(null);
            this.o = o;
        }

        public Object get() {
            return this.o;
        }
    }
}

