/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.StorageBuffer;
import org.openorb.util.Trace;

public abstract class AbstractInputStream
extends InputStream
implements ExtendedInputStream {
    private StorageBuffer m_curr_buf;
    private BufferSource m_source;
    private int m_overread;
    private SystemException m_cancel_exception;

    public AbstractInputStream(StorageBuffer buf) {
        this.m_curr_buf = buf;
        this.m_source = this.m_source;
    }

    public AbstractInputStream(BufferSource source) {
        this.m_curr_buf = source.next();
        this.m_source = source;
    }

    public String get_codebase() {
        return null;
    }

    public int read() throws IOException {
        if (this.m_overread > 0) {
            return -1;
        }
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        try {
            return this.read_octet();
        }
        catch (MARSHAL ex) {
            if (this.m_overread > 0) {
                return -1;
            }
            throw ex;
        }
    }

    public int read(byte[] val) {
        return this.read(val, 0, val.length);
    }

    public int read(byte[] val, int off, int len) {
        if (this.m_overread > 0) {
            return -1;
        }
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        try {
            this.read_octet_array(val, off, len);
            return len;
        }
        catch (MARSHAL ex) {
            if (this.m_overread > 0) {
                int ret = len - this.m_overread;
                return ret == 0 ? -1 : ret;
            }
            throw ex;
        }
    }

    protected void force_skip(int len) {
        if ((len = (int)((long)len - this.skip(len))) != 0) {
            this.m_overread = len;
            throw new MARSHAL("Buffer overread by " + len + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected void cancel(SystemException ex) {
        if (this.m_source == null) {
            this.m_cancel_exception = ex;
            throw this.m_cancel_exception;
        }
        this.m_source.setException(ex);
        try {
            this.m_source.next();
        }
        catch (SystemException nex) {
            this.m_cancel_exception = nex;
            throw nex;
        }
        Trace.signalIllegalCondition(null, "Invalid state.");
    }

    public int available() {
        return this.m_curr_buf.available() + (this.m_source != null ? this.m_source.available() : 0);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        if (this.m_source != null) {
            this.m_source.mark();
        } else {
            this.m_curr_buf.mark();
        }
    }

    public void reset() throws IOException {
        if (this.m_source != null) {
            StorageBuffer ncurr = this.m_source.reset();
            if (ncurr == null) {
                throw new IOException("No marked position to reset to");
            }
            this.m_curr_buf = ncurr;
        } else if (!this.m_curr_buf.reset()) {
            throw new IOException("No marked position to reset to");
        }
        this.m_overread = 0;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long count) {
        block8: {
            block7: {
                if (this.m_cancel_exception != null) {
                    throw this.m_cancel_exception;
                }
                total = count;
                if (this.m_source == null) break block7;
                if (this.m_curr_buf != null) ** GOTO lbl16
                return 0L;
lbl-1000:
                // 1 sources

                {
                    count -= (long)this.m_curr_buf.available();
                    try {
                        this.m_curr_buf = this.m_source.next();
                    }
                    catch (SystemException ex) {
                        this.m_cancel_exception = ex;
                        throw ex;
                    }
                    if (this.m_curr_buf != null) continue;
                    return total - count;
lbl16:
                    // 2 sources

                    ** while (count > (long)this.m_curr_buf.available())
                }
lbl17:
                // 1 sources

                len = new IntHolder((int)count);
                count -= (long)this.m_curr_buf.skip(len);
                if (this.m_curr_buf.available() == 0) {
                    try {
                        this.m_curr_buf = this.m_source.next();
                    }
                    catch (SystemException ex) {
                        this.m_cancel_exception = ex;
                        throw ex;
                    }
                }
                break block8;
            }
            len = new IntHolder((int)count);
            count -= (long)this.m_curr_buf.skip(len);
        }
        return total - count;
    }

    protected int next(OctetSeqHolder dst, IntHolder off, IntHolder len) {
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        if (len.value == 0) {
            return 0;
        }
        if (this.m_curr_buf == null) {
            this.m_overread = len.value;
            throw new MARSHAL("Buffer overread by " + len.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
        int ret = this.m_curr_buf.next(dst, off, len);
        if (this.m_curr_buf.available() == 0) {
            if (this.m_source != null) {
                try {
                    this.m_curr_buf = this.m_source.next();
                }
                catch (SystemException ex) {
                    this.m_cancel_exception = ex;
                    throw ex;
                }
            } else if (ret < 0) {
                this.m_overread = len.value;
                throw new MARSHAL("Buffer overread by " + len.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return ret;
    }
}

