/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.openorb.util.ZipHandle;
import org.openorb.util.ZipUtil;

public class ClassLoader
extends java.lang.ClassLoader {
    private Vector m_pathList = new Vector();
    private Hashtable m_usedArchive = new Hashtable();

    public void addPath(String path) {
        StringTokenizer token = new StringTokenizer(path, File.pathSeparator);
        while (token.hasMoreTokens()) {
            String nextToken = token.nextToken();
            this.m_pathList.addElement(nextToken);
            if (!nextToken.endsWith(".jar")) continue;
            this.addManifestReferences(nextToken);
        }
    }

    private void addManifestReferences(String archive) {
        try {
            Manifest m = new JarFile(archive).getManifest();
            String basePath = archive.substring(0, archive.lastIndexOf(File.separator) + 1);
            if (m == null) {
                return;
            }
            String paths = m.getMainAttributes().getValue("Class-Path");
            if (paths == null) {
                return;
            }
            StringTokenizer token = new StringTokenizer(paths, " ");
            while (token.hasMoreTokens()) {
                this.m_pathList.addElement(basePath + token.nextToken());
            }
        }
        catch (Exception ex) {}
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clz = this.findLoadedClass(name);
        if (clz == null) {
            try {
                clz = this.findSystemClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (clz == null) {
            clz = this.findClass(name);
        }
        if (resolve && clz != null) {
            this.resolveClass(clz);
        }
        if (clz == null) {
            throw new ClassNotFoundException();
        }
        return clz;
    }

    protected Class findClass(String name) {
        byte[] content = null;
        int i = 0;
        while (i < this.m_pathList.size()) {
            String path = (String)this.m_pathList.elementAt(i);
            if (path.endsWith(".zip") || path.endsWith(".jar") ? (content = this.loadClassFromArchive(path, this.name_to_archive_class(name))) != null : (content = this.loadClassFromPath(path, name)) != null) break;
            ++i;
        }
        if (content == null) {
            return null;
        }
        return this.defineClass(name, content, 0, content.length);
    }

    private byte[] loadClassFromArchive(String archive_name, String name) {
        try {
            boolean new_archive = false;
            ZipHandle archive = (ZipHandle)this.m_usedArchive.get(archive_name);
            if (archive == null) {
                try {
                    archive = ZipUtil.OpenZip(archive_name);
                    new_archive = true;
                }
                catch (IOException ex) {
                    ZipUtil.CloseZip(archive);
                    return null;
                }
            }
            if (!ZipUtil.containsFile(archive, name)) {
                if (new_archive) {
                    ZipUtil.CloseZip(archive);
                }
                return null;
            }
            byte[] content = ZipUtil.getFileContent(archive, name);
            if (new_archive) {
                this.m_usedArchive.put(archive_name, archive);
            }
            return content;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String name_to_archive_class(String name) {
        String file_name = name.replace('.', '/');
        return file_name + ".class";
    }

    private String name_to_class(String name) {
        String file_name = name.replace('.', File.separatorChar);
        return file_name + ".class";
    }

    private byte[] loadClassFromPath(String path, String name) {
        File file;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (!(file = new File(path + this.name_to_class(name))).exists()) {
            return null;
        }
        try {
            long read;
            FileInputStream input = new FileInputStream(file);
            long size = 0L;
            Vector<byte[]> list = new Vector<byte[]>();
            byte[] packet = null;
            while ((read = (long)input.read(packet = new byte[2048], 0, packet.length)) != -1L) {
                size += read;
                byte[] correctPacket = new byte[(int)read];
                System.arraycopy(packet, 0, correctPacket, 0, (int)read);
                list.addElement(correctPacket);
            }
            input.close();
            byte[] content = new byte[(int)size];
            int index = 0;
            int i = 0;
            while (i < list.size()) {
                packet = (byte[])list.elementAt(i);
                System.arraycopy(packet, 0, content, index, packet.length);
                index += packet.length;
                ++i;
            }
            return content;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public URL getResource(String name) {
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(name);
            if (url != null) {
                return url;
            }
            return this.findResource(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected URL findResource(String name) {
        try {
            String resourcePath = null;
            int i = 0;
            while (i < this.m_pathList.size()) {
                String path = (String)this.m_pathList.elementAt(i);
                if (path.endsWith(".zip") || path.endsWith(".jar")) {
                    resourcePath = this.loadResourceFromArchive(path, name);
                    if (resourcePath != null) {
                        break;
                    }
                } else {
                    resourcePath = this.loadResourceFromPath(path, name);
                    if (resourcePath == null) break;
                    break;
                }
                ++i;
            }
            if (resourcePath == null) {
                return null;
            }
            return new URL(resourcePath);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String loadResourceFromArchive(String archive_name, String name) {
        try {
            boolean new_archive = false;
            ZipHandle archive = (ZipHandle)this.m_usedArchive.get(archive_name);
            if (archive == null) {
                try {
                    archive = ZipUtil.OpenZip(archive_name);
                    new_archive = true;
                }
                catch (IOException ex) {
                    ZipUtil.CloseZip(archive);
                    return null;
                }
            }
            if (!ZipUtil.containsFile(archive, name)) {
                if (new_archive) {
                    ZipUtil.CloseZip(archive);
                }
                return null;
            }
            return new String("jar:file:" + archive_name + "!/" + name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String name_to_resource(String name) {
        String file_name = name.replace('/', File.separatorChar);
        return file_name;
    }

    private String loadResourceFromPath(String path, String name) {
        File file;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (!(file = new File(path + name)).exists()) {
            return null;
        }
        return new String("file:" + file.getAbsolutePath());
    }
}

