/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodMap {
    private Map<Class<?>, List<ITestNGMethod>> m_classMap = new HashMap();
    private Map<ITestClass, Set<Object>> m_beforeClassMethods = new HashMap<ITestClass, Set<Object>>();
    private Map<ITestClass, Set<Object>> m_afterClassMethods = new HashMap<ITestClass, Set<Object>>();

    public ClassMethodMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            Class<?> c = this.getMethodClass(m);
            List<ITestNGMethod> l = this.m_classMap.get(c);
            if (l == null) {
                l = new ArrayList<ITestNGMethod>();
                this.m_classMap.put(c, l);
            }
            l.add(m);
        }
    }

    public synchronized boolean removeAndCheckIfLast(ITestNGMethod m) {
        Class<?> c = this.getMethodClass(m);
        List<ITestNGMethod> l = this.m_classMap.get(c);
        l.remove(m);
        return l.size() == 0;
    }

    private Class<?> getMethodClass(ITestNGMethod m) {
        return m.getTestClass().getRealClass();
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.m_beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.m_afterClassMethods;
    }

    public void clear() {
        for (Set<Object> instances : this.m_beforeClassMethods.values()) {
            instances.clear();
            instances = null;
        }
        for (Set<Object> instances : this.m_afterClassMethods.values()) {
            instances.clear();
            Object var2_2 = null;
        }
        this.m_beforeClassMethods.clear();
        this.m_afterClassMethods.clear();
    }
}

