/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeListener;
import org.netbeans.core.windows.frames.FrameTypeSupport;
import org.netbeans.core.windows.frames.WindowFrameListenerAdapter;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;

public class TopFrameTypeImpl
extends JFrame
implements FrameType {
    private HashMap flMap;
    private FrameTypeSupport support = new FrameTypeSupport(this);
    private ModeImpl mode;
    private static Reference selectedFrameRef = new WeakReference<Object>(null);
    private static long time;
    private static Reference pendingFocusRequestorRef;

    public TopFrameTypeImpl() {
        this("");
    }

    public TopFrameTypeImpl(String title) {
        super(title);
    }

    public Container getRootPaneContainer() {
        return this;
    }

    public void addNotify() {
        super.addNotify();
        this.support.addNotify();
    }

    public Component getIcon() {
        return null;
    }

    public void requestFocus() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        super.requestFocus();
        Container contentPane = this.getContentPane();
        if (contentPane != null) {
            contentPane.requestFocus();
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public synchronized void addFrameTypeListener(FrameTypeListener fl) {
        if (this.flMap == null) {
            this.flMap = new HashMap(5);
        }
        WindowFrameListenerAdapter wfa = new WindowFrameListenerAdapter(this, fl);
        this.addWindowListener(wfa);
        this.flMap.put(fl, wfa);
    }

    public synchronized void removeFrameTypeListener(FrameTypeListener fl) {
        if (this.flMap == null) {
            return;
        }
        WindowFrameListenerAdapter wfa = (WindowFrameListenerAdapter)this.flMap.get(fl);
        if (wfa != null) {
            this.removeWindowListener(wfa);
        }
        this.flMap.remove(fl);
    }

    public int getType() {
        return 2;
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        if (selected) {
            selectedFrameRef = new WeakReference<TopFrameTypeImpl>(this);
            this.tryRequestFocus();
        } else {
            this.transferFocus();
        }
    }

    private void tryRequestFocus() {
        if (SwingUtilities.findFocusOwner(this) != null) {
            return;
        }
        time = System.currentTimeMillis();
        TopFrameTypeImpl pendingFocusRequestor = (TopFrameTypeImpl)pendingFocusRequestorRef.get();
        if (pendingFocusRequestor == this) {
            if (this != selectedFrameRef.get()) {
                this.requestFocus();
            }
        } else if (pendingFocusRequestor == null) {
            pendingFocusRequestorRef = new WeakReference<TopFrameTypeImpl>(this);
            this.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopFrameTypeImpl pendingFocusRequestor = (TopFrameTypeImpl)pendingFocusRequestorRef.get();
                    if (pendingFocusRequestor != null && pendingFocusRequestor == selectedFrameRef.get() && SwingUtilities.findFocusOwner(pendingFocusRequestor) != null) {
                        pendingFocusRequestorRef = new WeakReference<Object>(null);
                    }
                    if (pendingFocusRequestor == null) {
                        TopFrameTypeImpl.this.tryRequestFocus();
                    } else {
                        if (System.currentTimeMillis() > time + 200L) {
                            return;
                        }
                        if (TopFrameTypeImpl.this.isShowing()) {
                            SwingUtilities.invokeLater(this);
                        }
                    }
                }
            });
        }
    }

    public void attachToMode(ModeImpl mode) {
        this.mode = mode;
    }

    public ModeImpl getMode() {
        return this.mode;
    }

    public void setState(int state) {
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
            try {
                Method method = this.getClass().getMethod("setExtendedState", Integer.TYPE);
                method.invoke((Object)this, new Integer(state));
                return;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        super.setState(state);
    }

    public int getState() {
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
            try {
                Method method = this.getClass().getMethod("getExtendedState", new Class[0]);
                Integer state = (Integer)method.invoke((Object)this, new Object[0]);
                return state;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return super.getState();
    }

    static {
        pendingFocusRequestorRef = new WeakReference<Object>(null);
    }
}

