/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeAdapter;
import org.netbeans.core.windows.frames.FrameTypeEvent;
import org.netbeans.core.windows.frames.FrameTypeSupport;
import org.netbeans.core.windows.frames.InternalFrameTypeImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class DesktopPane
extends PerimeterPane
implements SwingConstants {
    private JDesktopPane desktopPane = new CenterDesktopPane();
    private DesktopScrollbarListener desktopScrollbarListener = new DesktopScrollbarListener();
    private MinMaxListener minMaxListener = new MinMaxListener();
    private DeactivationListener deactivationListener = new DeactivationListener();
    private JScrollPane desktopScrollPane = new JScrollPane(this.desktopPane);
    private boolean maxMode;
    private WeakHashMap frames2States;
    private Window topLevelWindow;
    private static int HORIZONTAL_STEP = 10;
    private static int VERTICAL_STEP = 14;

    public DesktopPane() {
        this.desktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        this.desktopPane.addContainerListener(this.desktopScrollbarListener);
        this.desktopScrollPane.getVerticalScrollBar().addAdjustmentListener(this.desktopScrollbarListener);
        this.desktopScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.desktopScrollbarListener);
        super.addImpl(this.desktopScrollPane, "CENTER", 0);
        this.desktopPane.registerKeyboardAction(new CloseViewActionRunner(), KeyStroke.getKeyStroke(115, 2), 1);
    }

    public void addNotify() {
        super.addNotify();
        Window curTopLevel = SwingUtilities.windowForComponent(this);
        if (curTopLevel != this.topLevelWindow) {
            curTopLevel.addWindowListener(this.deactivationListener);
            if (this.topLevelWindow != null) {
                this.topLevelWindow.removeWindowListener(this.deactivationListener);
            }
            this.topLevelWindow = curTopLevel;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.topLevelWindow != null) {
            this.topLevelWindow.removeWindowListener(this.deactivationListener);
            this.topLevelWindow = null;
        }
    }

    public Dimension getInnerDesktopSize() {
        return this.desktopPane.getSize();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == "CENTER") {
            throw new IllegalArgumentException("Cannot replace desktop.");
        }
        super.addImpl(comp, constraints, index + 1);
    }

    public void addFrameType(FrameType frame) {
        Container cont = frame.getRootPaneContainer();
        cont.addComponentListener(this.desktopScrollbarListener);
        frame.addFrameTypeListener(this.minMaxListener);
        if (frame.getIcon() != null) {
            frame.getIcon().addComponentListener(this.desktopScrollbarListener);
        }
        frame.addFrameTypeListener(this.deactivationListener);
        this.desktopPane.add(FrameTypeSupport.obtainFrameComponent(frame));
    }

    public void addFrameType(FrameType frame, Object constraints) {
        if (constraints == "CENTER") {
            this.addFrameType(frame);
        } else {
            frame.addFrameTypeListener(this.deactivationListener);
            this.add((Component)frame.getRootPaneContainer(), constraints);
        }
    }

    public void removeFrameType(FrameType frame) {
        Component comp = FrameTypeSupport.obtainFrameComponent(frame);
        if (this.desktopPane.isAncestorOf(comp)) {
            ((Container)this.desktopPane).remove(comp);
            if (comp.isVisible()) {
                this.desktopPane.repaint();
            }
        } else {
            this.remove(comp);
        }
        if (frame.getIcon() != null) {
            frame.getIcon().removeComponentListener(this.desktopScrollbarListener);
        }
        frame.getRootPaneContainer().removeComponentListener(this.desktopScrollbarListener);
        frame.removeFrameTypeListener(this.minMaxListener);
        frame.removeFrameTypeListener(this.deactivationListener);
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp != this.desktopScrollPane) {
            super.remove(index);
            this.revalidate();
        }
    }

    public void remove(Component comp) {
        if (comp != this.desktopScrollPane) {
            super.remove(comp);
        }
    }

    public void removeAll() {
        ((Container)this.desktopPane).removeAll();
        super.removeAll();
    }

    public int getPosition(FrameType frame) {
        if (frame != null) {
            return this.desktopPane.getPosition(FrameTypeSupport.obtainFrameComponent(frame));
        }
        return -1;
    }

    public void moveToFront(FrameType frame) {
        Component comp = FrameTypeSupport.obtainFrameComponent(frame);
        if (this.desktopPane.isAncestorOf(comp)) {
            this.desktopPane.moveToFront(comp);
            if (comp instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)comp).setSelected(true);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
        } else {
            super.moveToFront(comp);
        }
    }

    public void setAutoFocusEnabled(boolean autoFocus) {
        this.deactivationListener.setAutoFocusEnabled(autoFocus);
    }

    public boolean isAutoFocusEnabled() {
        return this.deactivationListener.isAutoFocusEnabled();
    }

    public void setMaxMode(boolean maxMode) {
        if (this.maxMode == maxMode) {
            return;
        }
        this.maxMode = maxMode;
        this.desktopScrollbarListener.passivate();
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        if (maxMode) {
            this.frames2States = new WeakHashMap(Math.max(5, frames.length * 2));
        }
        int i = 0;
        while (i < frames.length) {
            this.setMaxModeForFrame(frames[i], maxMode);
            ++i;
        }
        if (!maxMode) {
            this.frames2States = null;
        }
        this.desktopScrollbarListener.activate();
        if (maxMode) {
            this.desktopScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            Border b = UIManager.getBorder("DesktopPane.border");
            if (b == null) {
                b = UIManager.getBorder("ScrollPane.border");
            }
            this.desktopScrollPane.setBorder(b);
        }
    }

    public boolean isMaxMode() {
        return this.maxMode;
    }

    private void setMaxModeForFrame(JInternalFrame frame, boolean enable) {
        if (enable) {
            Rectangle visibleRect = this.desktopScrollPane.getViewport().getViewRect();
            try {
                if (frame.isIcon()) {
                    this.frames2States.put(frame, Boolean.TRUE);
                }
                frame.setMaximum(true);
                frame.setBounds(visibleRect);
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        } else {
            try {
                frame.setMaximum(false);
                if (this.frames2States.get(frame) != null) {
                    frame.setIcon(true);
                }
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    public Rectangle getFrameBounds(FrameType frame) {
        Component comp = FrameTypeSupport.obtainFrameComponent(frame);
        if (comp instanceof JInternalFrame) {
            return ((JInternalFrame)comp).getNormalBounds();
        }
        return comp.getBounds();
    }

    public int getFrameState(FrameType frame) {
        if (this.isMaxMode()) {
            return this.frames2States.get(frame.getRootPaneContainer()) != null ? 1 : 0;
        }
        return frame.getState();
    }

    public void relayout(int width, int height) {
        PerimeterLayout.relayoutImpl(width, height, this.desktopPane.getComponents());
    }

    private class MinMaxListener
    extends FrameTypeAdapter {
        MinMaxListener() {
        }

        public void frameClosed(FrameTypeEvent fe) {
            if (DesktopPane.this.desktopPane.getAllFrames().length == 0) {
                DesktopPane.this.setMaxMode(false);
            }
        }

        public void frameIconified(FrameTypeEvent fe) {
            InternalFrameTypeImpl frame = (InternalFrameTypeImpl)fe.getSource();
            if (!frame.isVisible()) {
                return;
            }
            DesktopPane.this.setMaxMode(false);
            Rectangle minRect = DesktopPane.this.desktopScrollPane.getViewport().getViewRect();
            JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
            Rectangle iconRect = icon.getBounds();
            iconRect.setLocation(minRect.x, minRect.y + minRect.height - iconRect.height);
            Component comp = null;
            do {
                Component component = comp = (comp = DesktopPane.this.desktopPane.getComponentAt(iconRect.getLocation())) instanceof RootPaneContainer || comp == icon || comp == DesktopPane.this.desktopPane ? null : comp;
                if (comp == null) continue;
                iconRect.setLocation(iconRect.x + comp.getBounds().width, iconRect.y);
            } while (comp != null);
        }

        public void frameMaximized(FrameTypeEvent fe) {
            if (!((InternalFrameTypeImpl)fe.getSource()).isVisible()) {
                return;
            }
            if (!DesktopPane.this.isMaxMode()) {
                DesktopPane.this.setMaxMode(true);
                this.selectFrame((FrameType)fe.getSource());
            }
        }

        public void frameNormalized(FrameTypeEvent fe) {
            if (!((InternalFrameTypeImpl)fe.getSource()).isVisible()) {
                return;
            }
            if (DesktopPane.this.isMaxMode()) {
                DesktopPane.this.frames2States.remove(fe.getSource());
                DesktopPane.this.setMaxMode(false);
                this.selectFrame((FrameType)fe.getSource());
            }
        }

        private void selectFrame(FrameType frame) {
            DesktopPane.this.moveToFront(frame);
        }
    }

    private class DesktopScrollbarListener
    implements ComponentListener,
    ContainerListener,
    AdjustmentListener {
        private boolean nowUpdating = false;

        DesktopScrollbarListener() {
        }

        public void componentShown(ComponentEvent p1) {
            this.checkDesktopSize();
        }

        public void componentResized(ComponentEvent p1) {
            this.checkDesktopSize();
        }

        public void componentHidden(ComponentEvent p1) {
            this.checkDesktopSize();
        }

        public void componentMoved(ComponentEvent p1) {
            this.checkDesktopSize();
        }

        public void componentRemoved(ContainerEvent p1) {
            this.checkDesktopSize();
        }

        public void componentAdded(ContainerEvent ce) {
            if (DesktopPane.this.isMaxMode() && ce.getChild() instanceof FrameType) {
                try {
                    ((FrameType)((Object)ce.getChild())).setState(6);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
            this.checkDesktopSize();
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            this.checkDesktopSize();
        }

        private void checkDesktopSize() {
            if (this.nowUpdating) {
                return;
            }
            this.nowUpdating = true;
            JDesktopPane desktopPane = DesktopPane.this.desktopPane;
            JScrollPane scrollPane = DesktopPane.this.desktopScrollPane;
            Rectangle minRect = scrollPane.getViewport().getViewRect();
            Point oldViewPos = scrollPane.getViewport().getViewPosition();
            JInternalFrame[] frames = desktopPane.getAllFrames();
            if (!DesktopPane.this.isMaxMode()) {
                int i = 0;
                while (i < frames.length) {
                    Rectangle compRect;
                    Rectangle rectangle = compRect = frames[i].isIcon() ? frames[i].getDesktopIcon().getBounds() : frames[i].getBounds();
                    if (frames[i].isIcon()) {
                        compRect.y = 0;
                    }
                    minRect.add(compRect);
                    ++i;
                }
                boolean sizeChanged = !minRect.getSize().equals(desktopPane.getSize());
                boolean viewPosChanged = (minRect.x != 0 || minRect.y != 0) && oldViewPos.x != -minRect.x && oldViewPos.y != -minRect.y;
                this.resizeDesktop(minRect, oldViewPos);
            } else {
                int i = 0;
                while (i < frames.length) {
                    frames[i].setBounds(scrollPane.getViewport().getViewRect());
                    ++i;
                }
                this.resizeDesktop(minRect, oldViewPos);
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ DesktopScrollbarListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    DesktopScrollbarListener.access$402(this.this$1, false);
                }
            });
        }

        private void resizeDesktop(Rectangle newDRect, Point oldViewPos) {
            JDesktopPane desktopPane = DesktopPane.this.desktopPane;
            JScrollPane scrollPane = DesktopPane.this.desktopScrollPane;
            boolean emptyDesktop = desktopPane.getSize().getHeight() == 0.0 && desktopPane.getSize().getWidth() == 0.0;
            this.passivate();
            JViewport viewport = scrollPane.getViewport();
            JInternalFrame[] frames = desktopPane.getAllFrames();
            JInternalFrame curFrame = null;
            JComponent curComp = null;
            boolean isIcon = false;
            int i = 0;
            while (i < frames.length) {
                curFrame = frames[i];
                isIcon = curFrame.isIcon();
                curComp = isIcon ? curFrame.getDesktopIcon() : curFrame;
                Point loc = curComp.getLocation();
                loc.x -= newDRect.x;
                loc.y -= newDRect.y;
                if (isIcon) {
                    int viewPortHeight = ((DesktopPane)DesktopPane.this).desktopScrollPane.getViewport().getViewRect().height;
                    loc.y = Math.min(loc.y, viewPortHeight - ((Component)curComp).getHeight());
                    if (loc.y < 0) {
                        loc.y = 0;
                    }
                }
                curComp.setLocation(loc);
                ++i;
            }
            desktopPane.setPreferredSize(newDRect.getSize());
            desktopPane.setSize(newDRect.getSize());
            desktopPane.revalidate();
            if (newDRect.x != 0 || newDRect.y != 0) {
                oldViewPos.translate(-newDRect.x, -newDRect.y);
                viewport.setViewPosition(oldViewPos);
            }
            if (!emptyDesktop) {
                this.determineScrollBarPolicy(newDRect);
            }
            SwingUtilities.invokeLater(new Runnable(this, scrollPane){
                private final /* synthetic */ JScrollPane val$scrollPane;
                private final /* synthetic */ DesktopScrollbarListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$scrollPane = val$scrollPane;
                }

                public void run() {
                    this.val$scrollPane.invalidate();
                    this.val$scrollPane.validate();
                }
            });
            this.activate();
        }

        private void determineScrollBarPolicy(Rectangle newDRect) {
            JScrollPane scrollPane = DesktopPane.this.desktopScrollPane;
            Dimension sSize = scrollPane.getSize();
            int vPolicy = newDRect.height > sSize.height ? 22 : 21;
            boolean vEnabled = vPolicy == 22;
            int hPolicy = newDRect.width > sSize.width ? 32 : 31;
            boolean hEnabled = hPolicy == 32;
            scrollPane.setVerticalScrollBarPolicy(vPolicy);
            scrollPane.setHorizontalScrollBarPolicy(hPolicy);
            scrollPane.getVerticalScrollBar().setEnabled(vEnabled);
            scrollPane.getHorizontalScrollBar().setEnabled(hEnabled);
            if (vEnabled) {
                scrollPane.getVerticalScrollBar().setUnitIncrement(VERTICAL_STEP);
            }
            if (hEnabled) {
                scrollPane.getHorizontalScrollBar().setUnitIncrement(HORIZONTAL_STEP);
            }
        }

        private void passivate() {
            JDesktopPane desktopPane = DesktopPane.this.desktopPane;
            JScrollPane scrollPane = DesktopPane.this.desktopScrollPane;
            desktopPane.removeContainerListener(this);
            scrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
            scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this);
            JInternalFrame[] frames = desktopPane.getAllFrames();
            int i = 0;
            while (i < frames.length) {
                frames[i].getDesktopIcon().removeComponentListener(this);
                frames[i].removeComponentListener(this);
                ++i;
            }
        }

        private void activate() {
            JDesktopPane desktopPane = DesktopPane.this.desktopPane;
            JScrollPane scrollPane = DesktopPane.this.desktopScrollPane;
            desktopPane.addContainerListener(this);
            scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
            JInternalFrame[] frames = desktopPane.getAllFrames();
            int i = 0;
            while (i < frames.length) {
                frames[i].getDesktopIcon().addComponentListener(this);
                frames[i].addComponentListener(this);
                ++i;
            }
        }

        static /* synthetic */ boolean access$402(DesktopScrollbarListener x0, boolean x1) {
            x0.nowUpdating = x1;
            return x0.nowUpdating;
        }
    }

    private static class DeactivationListener
    extends FrameTypeAdapter
    implements WindowListener {
        private FrameType activated;
        private boolean autoFocusEnabled = true;

        DeactivationListener() {
        }

        public void setAutoFocusEnabled(boolean autoFocusEnabled) {
            if (this.autoFocusEnabled == autoFocusEnabled) {
                return;
            }
            this.autoFocusEnabled = autoFocusEnabled;
        }

        public boolean isAutoFocusEnabled() {
            return this.autoFocusEnabled;
        }

        public void frameActivated(FrameTypeEvent fte) {
            FrameType frame = (FrameType)fte.getSource();
            if (this.activated != null && frame != this.activated) {
                try {
                    this.activated.setSelected(false);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
            this.activated = frame;
        }

        public void windowDeactivated(WindowEvent p1) {
            if (this.autoFocusEnabled && this.activated != null) {
                try {
                    this.activated.setSelected(false);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
        }

        public void windowActivated(WindowEvent p1) {
            if (this.autoFocusEnabled && this.activated != null) {
                try {
                    this.activated.setSelected(true);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
        }

        public void windowClosed(WindowEvent p1) {
        }

        public void windowDeiconified(WindowEvent p1) {
        }

        public void windowOpened(WindowEvent p1) {
        }

        public void windowIconified(WindowEvent p1) {
        }

        public void windowClosing(WindowEvent p1) {
        }
    }

    private static final class CloseViewActionRunner
    implements ActionListener {
        CloseViewActionRunner() {
        }

        public void actionPerformed(ActionEvent evt) {
            KeyStroke ctrlF4 = KeyStroke.getKeyStroke(115, 2);
            ActionEvent aev = new ActionEvent(evt.getSource(), 1001, Utilities.keyToString((KeyStroke)ctrlF4));
            NbFocusManager.processKeyStroke(ctrlF4, aev);
        }
    }

    private static class CenterDesktopPane
    extends JDesktopPane {
        static /* synthetic */ Class class$org$netbeans$core$windows$frames$DesktopPane;

        CenterDesktopPane() {
        }

        public void paint(Graphics g) {
            int n;
            super.paint(g);
            WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
            if (wmi.isSwitchingWorkspace() && (n = this.getComponentCount()) == 0) {
                Workspace ws = wmi.getCurrentWorkspace();
                Dimension size = this.getSize();
                int x = size.width / 2;
                int y = size.height / 2;
                Font currFont = g.getFont();
                Font newFont = currFont.deriveFont(1);
                g.setFont(newFont);
                String s = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$DesktopPane == null ? (class$org$netbeans$core$windows$frames$DesktopPane = CenterDesktopPane.class$("org.netbeans.core.windows.frames.DesktopPane")) : class$org$netbeans$core$windows$frames$DesktopPane), (String)"MSG_SwitchingWorkspaces", (Object)Actions.cutAmpersand((String)ws.getDisplayName()));
                FontMetrics metrics = g.getFontMetrics();
                int w = metrics.stringWidth(s);
                g.drawString(s, x -= w / 2, y);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

