/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.EqualFlowLayout;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NbPresenter
extends JDialog
implements PropertyChangeListener,
WindowListener,
Mutex.Action {
    public static NbPresenter currentModalDialog;
    private static final Set listeners;
    protected NotifyDescriptor descriptor;
    private final JButton stdYesButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("YES_OPTION_CAPTION"));
    private final JButton stdNoButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("NO_OPTION_CAPTION"));
    private final JButton stdOKButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("OK_OPTION_CAPTION"));
    private final JButton stdCancelButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("CANCEL_OPTION_CAPTION"));
    private final JButton stdClosedButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("CLOSED_OPTION_CAPTION"));
    private final JButton stdHelpButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("HELP_OPTION_CAPTION"));
    private final JButton stdDetailButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("HELP_OPTION_CAPTION"));
    private static final String CANCEL_COMMAND = "Cancel";
    private Component currentMessage;
    private JScrollPane currentScrollPane;
    private JPanel currentButtonsPanel;
    private Component[] currentPrimaryButtons;
    private Component[] currentSecondaryButtons;
    private int currentAlign;
    private ButtonListener buttonListener;
    private transient HelpCtx currentHelp;
    private transient boolean haveCalledInitializeButtons;
    static final long serialVersionUID = -4508637164126678997L;
    static /* synthetic */ Class class$org$netbeans$core$NbPresenter;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public NbPresenter(NotifyDescriptor d, Frame owner, boolean modal) {
        super(owner, d.getTitle(), modal);
        this.stdYesButton.setDefaultCapable(true);
        this.stdOKButton.setDefaultCapable(true);
        this.stdNoButton.setDefaultCapable(false);
        this.stdCancelButton.setDefaultCapable(false);
        this.stdCancelButton.setVerifyInputWhenFocusTarget(false);
        this.stdClosedButton.setDefaultCapable(false);
        this.stdHelpButton.setDefaultCapable(false);
        this.stdDetailButton.setDefaultCapable(false);
        this.stdNoButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("NO_OPTION_CAPTION_MNEMONIC").charAt(0));
        this.stdHelpButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("HELP_OPTION_CAPTION_MNEMONIC").charAt(0));
        this.initAccessibility();
        this.currentHelp = null;
        this.haveCalledInitializeButtons = false;
        this.initialize(d);
    }

    public NbPresenter(NotifyDescriptor d, Dialog owner, boolean modal) {
        super(owner, d.getTitle(), modal);
        this.stdYesButton.setDefaultCapable(true);
        this.stdOKButton.setDefaultCapable(true);
        this.stdNoButton.setDefaultCapable(false);
        this.stdCancelButton.setDefaultCapable(false);
        this.stdCancelButton.setVerifyInputWhenFocusTarget(false);
        this.stdClosedButton.setDefaultCapable(false);
        this.stdHelpButton.setDefaultCapable(false);
        this.stdDetailButton.setDefaultCapable(false);
        this.stdNoButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("NO_OPTION_CAPTION_MNEMONIC").charAt(0));
        this.stdHelpButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("HELP_OPTION_CAPTION_MNEMONIC").charAt(0));
        this.initAccessibility();
        this.currentHelp = null;
        this.haveCalledInitializeButtons = false;
        this.initialize(d);
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter));
        this.stdYesButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_YES_OPTION_NAME"));
        this.stdYesButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_YES_OPTION_DESC"));
        this.stdNoButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NO_OPTION_NAME"));
        this.stdNoButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NO_OPTION_DESC"));
        this.stdOKButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_OK_OPTION_NAME"));
        this.stdOKButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_OK_OPTION_DESC"));
        this.stdCancelButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CANCEL_OPTION_NAME"));
        this.stdCancelButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CANCEL_OPTION_DESC"));
        this.stdClosedButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CLOSED_OPTION_NAME"));
        this.stdClosedButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CLOSED_OPTION_DESC"));
        this.stdHelpButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_HELP_OPTION_NAME"));
        this.stdHelpButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_HELP_OPTION_DESC"));
        this.stdDetailButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_HELP_OPTION_NAME"));
        this.stdDetailButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_HELP_OPTION_DESC"));
    }

    private void initialize(NotifyDescriptor d) {
        this.descriptor = d;
        this.setDefaultCloseOperation(0);
        this.buttonListener = new ButtonListener();
        this.getRootPane().registerKeyboardAction(this.buttonListener, CANCEL_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        this.initializePresenter();
        this.pack();
        ((Component)this).setBounds(Utilities.findCenterBounds((Dimension)this.getSize()));
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
            return;
        }
        this.requestFocusForMessage();
    }

    private void requestFocusForJdk14(Component comp) {
        this.validate();
        try {
            Object root = Class.forName("java.awt.Component").getDeclaredMethod("getFocusCycleRootAncestor", new Class[0]).invoke((Object)comp, new Object[0]);
            if (root != null) {
                comp = (Component)root;
            }
            if (comp instanceof Container) {
                Class.forName("java.awt.Container").getDeclaredMethod("transferFocusDownCycle", new Class[0]).invoke((Object)comp, new Object[0]);
            } else {
                comp.requestFocus();
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
    }

    private void requestFocusForMessage() {
        Component comp = this.currentMessage;
        if (comp == null) {
            return;
        }
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4.0")) == 0) {
            if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4.1")) > 0) {
                this.requestFocusForJdk14(comp);
            }
            return;
        }
        if (!(comp instanceof JComponent) || !((JComponent)comp).requestDefaultFocus()) {
            comp.requestFocus();
        }
    }

    private void initializeMessage() {
        Object newMessage = this.descriptor.getMessage();
        if (this.currentMessage == null || !this.currentMessage.equals(newMessage)) {
            this.uninitializeMessage();
            this.currentMessage = this.descriptor.getMessageType() == -1 && newMessage instanceof Component ? (Component)newMessage : this.createOptionPane();
            Dimension minSize = this.currentMessage.getMinimumSize();
            final Rectangle screenBounds = Utilities.getUsableScreenBounds();
            if (minSize.width > screenBounds.width - 100 || minSize.height > screenBounds.height - 100) {
                this.currentScrollPane = new JScrollPane(){

                    public Dimension getPreferredSize() {
                        Dimension sz = new Dimension(super.getPreferredSize());
                        if (sz.width > screenBounds.width - 100) {
                            sz.width = screenBounds.width * 3 / 4;
                        }
                        if (sz.height > screenBounds.height - 100) {
                            sz.height = screenBounds.height * 3 / 4;
                        }
                        return sz;
                    }
                };
                this.currentScrollPane.setViewportView(this.currentMessage);
                this.getContentPane().add((Component)this.currentScrollPane, "Center");
            } else {
                this.getContentPane().add(this.currentMessage, "Center");
            }
        }
    }

    private void uninitializeMessage() {
        if (this.currentMessage != null) {
            if (this.currentScrollPane != null) {
                this.getContentPane().remove(this.currentScrollPane);
                this.currentScrollPane = null;
            } else {
                this.getContentPane().remove(this.currentMessage);
            }
            this.currentMessage = null;
        }
    }

    private void initializePresenter() {
        if (this.currentMessage != null) {
            return;
        }
        this.initializeMessage();
        this.updateHelp();
        this.initializeButtons();
        this.haveCalledInitializeButtons = true;
        this.descriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.addWindowListener(this);
    }

    private void uninitializePresenter() {
        this.descriptor.removePropertyChangeListener((PropertyChangeListener)this);
        this.uninitializeMessage();
        this.uninitializeButtons();
    }

    public void addNotify() {
        super.addNotify();
        this.initializePresenter();
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninitializePresenter();
    }

    private JOptionPane createOptionPane() {
        Object msg = this.descriptor.getMessage();
        boolean override = true;
        String strMsg = null;
        if (msg instanceof String) {
            msg = Utilities.replaceString((String)((String)msg), (String)"\t", (String)"    ");
            strMsg = (String)(msg = Utilities.replaceString((String)((String)msg), (String)"\r", (String)""));
            String strMsgLower = strMsg.toLowerCase();
            boolean bl = override = !strMsgLower.startsWith("<html>");
        }
        if (msg instanceof Accessible) {
            strMsg = ((Accessible)msg).getAccessibleContext().getAccessibleDescription();
        }
        JOptionPane optionPane = override ? new JOptionPane(msg, this.descriptor.getMessageType(), 0, null, new Object[0], null){

            public int getMaxCharactersPerLineCount() {
                return 100;
            }
        } : new JOptionPane(msg, this.descriptor.getMessageType(), 0, null, new Object[0], null);
        optionPane.setUI(new BasicOptionPaneUI(){

            public Dimension getMinimumOptionPaneSize() {
                if (this.minimumSize == null) {
                    return new Dimension(262, 50);
                }
                return new Dimension(this.minimumSize.width, 50);
            }
        });
        optionPane.setWantsInput(false);
        optionPane.getAccessibleContext().setAccessibleDescription(strMsg);
        return optionPane;
    }

    private void uninitializeButtons() {
        if (this.currentButtonsPanel != null) {
            int i;
            if (this.currentPrimaryButtons != null) {
                i = 0;
                while (i < this.currentPrimaryButtons.length) {
                    this.modifyListener(this.currentPrimaryButtons[i], this.buttonListener, false);
                    ++i;
                }
            }
            if (this.currentSecondaryButtons != null) {
                i = 0;
                while (i < this.currentSecondaryButtons.length) {
                    this.modifyListener(this.currentSecondaryButtons[i], this.buttonListener, false);
                    ++i;
                }
            }
            this.getContentPane().remove(this.currentButtonsPanel);
            this.currentButtonsPanel = null;
        }
    }

    protected final void initializeButtons() {
        JButton button;
        Component focusOwner = SwingUtilities.findFocusOwner(this);
        boolean helpButtonShown = this.stdHelpButton.isShowing() || this.descriptor instanceof WizardDescriptor;
        this.uninitializeButtons();
        Object[] primaryOptions = this.descriptor.getOptions();
        Object[] secondaryOptions = this.descriptor.getAdditionalOptions();
        this.currentAlign = this.getOptionsAlign();
        this.currentPrimaryButtons = null;
        this.currentSecondaryButtons = null;
        if (primaryOptions != null) {
            this.currentPrimaryButtons = new Component[primaryOptions.length];
            int i = 0;
            while (i < primaryOptions.length) {
                if (primaryOptions[i] == NotifyDescriptor.YES_OPTION) {
                    this.currentPrimaryButtons[i] = this.stdYesButton;
                } else if (primaryOptions[i] == NotifyDescriptor.NO_OPTION) {
                    this.currentPrimaryButtons[i] = this.stdNoButton;
                } else if (primaryOptions[i] == NotifyDescriptor.OK_OPTION) {
                    this.currentPrimaryButtons[i] = this.stdOKButton;
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                } else if (primaryOptions[i] == NotifyDescriptor.CANCEL_OPTION) {
                    this.currentPrimaryButtons[i] = this.stdCancelButton;
                } else if (primaryOptions[i] == NotifyDescriptor.CLOSED_OPTION) {
                    this.currentPrimaryButtons[i] = this.stdClosedButton;
                } else if (primaryOptions[i] instanceof Component) {
                    this.currentPrimaryButtons[i] = (Component)primaryOptions[i];
                } else if (primaryOptions[i] instanceof Icon) {
                    button = new JButton((Icon)primaryOptions[i]);
                    button.setDefaultCapable(false);
                    this.currentPrimaryButtons[i] = button;
                } else {
                    button = new JButton();
                    Actions.setMenuText((AbstractButton)button, (String)primaryOptions[i].toString(), (boolean)true);
                    button.setDefaultCapable(primaryOptions[i].equals(this.descriptor.getValue()));
                    this.currentPrimaryButtons[i] = button;
                }
                ++i;
            }
        } else {
            switch (this.descriptor.getOptionType()) {
                case 0: {
                    this.currentPrimaryButtons = new Component[2];
                    this.currentPrimaryButtons[0] = this.stdYesButton;
                    this.currentPrimaryButtons[1] = this.stdNoButton;
                    break;
                }
                case 1: {
                    this.currentPrimaryButtons = new Component[3];
                    this.currentPrimaryButtons[0] = this.stdYesButton;
                    this.currentPrimaryButtons[1] = this.stdNoButton;
                    this.currentPrimaryButtons[2] = this.stdCancelButton;
                    break;
                }
                default: {
                    this.currentPrimaryButtons = new Component[2];
                    this.currentPrimaryButtons[0] = this.stdOKButton;
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                    this.currentPrimaryButtons[1] = this.stdCancelButton;
                }
            }
        }
        if (this.currentHelp != null || helpButtonShown) {
            if (this.currentPrimaryButtons == null) {
                this.currentPrimaryButtons = new Component[0];
            }
            Component[] cPB2 = new Component[this.currentPrimaryButtons.length + 1];
            System.arraycopy(this.currentPrimaryButtons, 0, cPB2, 0, this.currentPrimaryButtons.length);
            cPB2[this.currentPrimaryButtons.length] = this.stdHelpButton;
            this.currentPrimaryButtons = cPB2;
            this.stdHelpButton.setEnabled(this.currentHelp != null);
        }
        if (secondaryOptions != null && secondaryOptions.length != 0) {
            this.currentSecondaryButtons = new Component[secondaryOptions.length];
            int i = 0;
            while (i < secondaryOptions.length) {
                if (secondaryOptions[i] == NotifyDescriptor.YES_OPTION) {
                    this.currentSecondaryButtons[i] = this.stdYesButton;
                } else if (secondaryOptions[i] == NotifyDescriptor.NO_OPTION) {
                    this.currentSecondaryButtons[i] = this.stdNoButton;
                } else if (secondaryOptions[i] == NotifyDescriptor.OK_OPTION) {
                    this.currentSecondaryButtons[i] = this.stdOKButton;
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                } else if (secondaryOptions[i] == NotifyDescriptor.CANCEL_OPTION) {
                    this.currentSecondaryButtons[i] = this.stdCancelButton;
                } else if (secondaryOptions[i] == NotifyDescriptor.CLOSED_OPTION) {
                    this.currentSecondaryButtons[i] = this.stdClosedButton;
                } else if (secondaryOptions[i] instanceof Component) {
                    this.currentSecondaryButtons[i] = (Component)secondaryOptions[i];
                } else if (secondaryOptions[i] instanceof Icon) {
                    button = new JButton((Icon)secondaryOptions[i]);
                    this.currentSecondaryButtons[i] = button;
                } else {
                    button = new JButton();
                    Actions.setMenuText((AbstractButton)button, (String)secondaryOptions[i].toString(), (boolean)true);
                    this.currentSecondaryButtons[i] = button;
                }
                ++i;
            }
        }
        if (this.currentAlign == 0 || this.currentAlign == -1) {
            int i;
            JPanel panelForPrimary = null;
            JPanel panelForSecondary = null;
            if (this.currentPrimaryButtons != null) {
                panelForPrimary = new JPanel();
                if (this.currentAlign == -1) {
                    panelForPrimary.setLayout((LayoutManager)new EqualFlowLayout());
                } else {
                    panelForPrimary.setLayout((LayoutManager)new EqualFlowLayout(2));
                }
                i = 0;
                while (i < this.currentPrimaryButtons.length) {
                    this.modifyListener(this.currentPrimaryButtons[i], this.buttonListener, true);
                    panelForPrimary.add(this.currentPrimaryButtons[i]);
                    ++i;
                }
            }
            if (this.currentSecondaryButtons != null) {
                panelForSecondary = new JPanel();
                panelForSecondary.setLayout((LayoutManager)new EqualFlowLayout(0));
                i = 0;
                while (i < this.currentSecondaryButtons.length) {
                    this.modifyListener(this.currentSecondaryButtons[i], this.buttonListener, true);
                    panelForSecondary.add(this.currentSecondaryButtons[i]);
                    ++i;
                }
            }
            if (panelForPrimary != null && panelForSecondary != null) {
                this.currentButtonsPanel = new JPanel();
                this.currentButtonsPanel.setLayout(new BorderLayout());
                this.currentButtonsPanel.add((Component)panelForPrimary, "East");
                this.currentButtonsPanel.add((Component)panelForSecondary, "West");
            } else {
                this.currentButtonsPanel = panelForPrimary != null ? panelForPrimary : panelForSecondary;
            }
            if (this.currentButtonsPanel != null && this.currentButtonsPanel.getComponentCount() != 0) {
                this.currentButtonsPanel.setBorder(new EmptyBorder(new Insets(11, 6, 5, 5)));
                this.getContentPane().add((Component)this.currentButtonsPanel, "South");
            }
        } else if (this.currentAlign == 1) {
            this.currentButtonsPanel = new JPanel();
            this.currentButtonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 4, 2, 5);
            gbc.fill = 2;
            if (this.currentPrimaryButtons != null) {
                int i = 0;
                while (i < this.currentPrimaryButtons.length) {
                    this.modifyListener(this.currentPrimaryButtons[i], this.buttonListener, true);
                    this.currentButtonsPanel.add(this.currentPrimaryButtons[i], gbc);
                    ++i;
                }
            }
            GridBagConstraints padding = new GridBagConstraints();
            padding.gridwidth = 0;
            padding.weightx = 1.0;
            padding.weighty = 1.0;
            padding.fill = 1;
            this.currentButtonsPanel.add((Component)new JPanel(), padding);
            gbc.insets = new Insets(2, 4, 5, 5);
            if (this.currentSecondaryButtons != null) {
                int i = 0;
                while (i < this.currentSecondaryButtons.length) {
                    this.modifyListener(this.currentSecondaryButtons[i], this.buttonListener, true);
                    this.currentButtonsPanel.add(this.currentSecondaryButtons[i], gbc);
                    ++i;
                }
            }
            if (this.currentButtonsPanel != null) {
                this.currentButtonsPanel.setBorder(new EmptyBorder(new Insets(6, 7, 5, 5)));
                this.getContentPane().add((Component)this.currentButtonsPanel, "East");
            }
        }
        this.updateDefaultButton();
        Component fo = SwingUtilities.findFocusOwner(this);
        if (fo != focusOwner && focusOwner != null) {
            focusOwner.requestFocus();
        }
    }

    private void updateDefaultButton() {
        if (this.currentPrimaryButtons != null) {
            int i = 0;
            while (i < this.currentPrimaryButtons.length) {
                JButton b;
                if (this.currentPrimaryButtons[i] instanceof JButton && (b = (JButton)this.currentPrimaryButtons[i]).isVisible() && b.isEnabled() && b.isDefaultCapable()) {
                    this.getRootPane().setDefaultButton(b);
                    return;
                }
                ++i;
            }
        }
        this.getRootPane().setDefaultButton(null);
    }

    private void updateOKButton(boolean valid) {
        JButton b;
        int i;
        if (this.currentPrimaryButtons != null) {
            i = 0;
            while (i < this.currentPrimaryButtons.length) {
                if (this.currentPrimaryButtons[i] instanceof JButton && (b = (JButton)this.currentPrimaryButtons[i]) == this.stdOKButton && b.isVisible()) {
                    b.setEnabled(valid);
                }
                ++i;
            }
        }
        if (this.currentSecondaryButtons != null) {
            i = 0;
            while (i < this.currentSecondaryButtons.length) {
                if (this.currentSecondaryButtons[i] instanceof JButton && (b = (JButton)this.currentSecondaryButtons[i]) == this.stdOKButton && b.isVisible()) {
                    b.setEnabled(valid);
                }
                ++i;
            }
        }
    }

    private void modifyListener(Component comp, ButtonListener l, boolean add) {
        if (comp instanceof JButton) {
            JButton b = (JButton)comp;
            if (add) {
                b.addActionListener(l);
                b.addComponentListener(l);
                b.addPropertyChangeListener(l);
            } else {
                b.removeActionListener(l);
                b.removeComponentListener(l);
                b.removePropertyChangeListener(l);
            }
            return;
        }
        Method m = null;
        try {
            m = comp.getClass().getMethod(add ? "addActionListener" : "removeActionListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = NbPresenter.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        catch (SecurityException e2) {
            m = null;
        }
        if (m != null) {
            try {
                m.invoke((Object)comp, l);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void superShow() {
        super.show();
    }

    public void show() {
        if (this.isModal() && Dependency.JAVA_IMPL.indexOf("1.4.0") >= 0 && WindowManagerImpl.isWindowDnDEnabled() && WindowDnDManager.getDefault().isDragging()) {
            this.setModal(false);
        }
        if (this.isModal()) {
            Mutex.EVENT.readAccess((Mutex.Action)this);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.doShow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbPresenter.this.doShow();
                }
            });
        }
    }

    public Object run() {
        this.doShow();
        return null;
    }

    private void doShow() {
        NbPresenter prev = null;
        if (this.isModal()) {
            prev = currentModalDialog;
            currentModalDialog = this;
            NbPresenter.fireChangeEvent();
        }
        this.superShow();
        if (currentModalDialog != prev) {
            currentModalDialog = prev;
            NbPresenter.fireChangeEvent();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean update = false;
        if ("options".equals(evt.getPropertyName())) {
            this.initializeButtons();
            update = true;
        } else if ("optionType".equals(evt.getPropertyName())) {
            this.initializeButtons();
            update = true;
        } else if ("optionsAlign".equals(evt.getPropertyName())) {
            this.initializeButtons();
            update = true;
        } else if ("message".equals(evt.getPropertyName())) {
            this.initializeMessage();
            this.requestFocusForMessage();
            this.updateHelp();
            update = true;
        } else if ("messageType".equals(evt.getPropertyName())) {
            this.initializeMessage();
            this.requestFocusForMessage();
            update = true;
        } else if ("title".equals(evt.getPropertyName())) {
            this.setTitle(this.descriptor.getTitle());
        } else if ("helpCtx".equals(evt.getPropertyName())) {
            this.updateHelp();
            this.currentButtonsPanel.revalidate();
            this.currentButtonsPanel.repaint();
        } else if ("valid".equals(evt.getPropertyName())) {
            this.updateOKButton((Boolean)evt.getNewValue());
        }
        if (update) {
            Dimension sz = this.getSize();
            Dimension minsz = this.getMinimumSize();
            if (minsz.width > sz.width || minsz.height > sz.height) {
                ((Component)this).setSize(Math.max(minsz.width, sz.width), Math.max(minsz.height, sz.height));
            }
            this.validate();
            this.repaint();
        }
    }

    private void updateHelp() {
        HelpCtx help = this.getHelpCtx();
        if (HelpCtx.DEFAULT_HELP.equals((Object)help)) {
            Object msg = this.descriptor.getMessage();
            if (msg instanceof Component) {
                help = HelpCtx.findHelp((Component)((Component)msg));
            }
            if (HelpCtx.DEFAULT_HELP.equals((Object)help)) {
                help = null;
            }
        }
        if (!Utilities.compareObjects((Object)this.currentHelp, (Object)help)) {
            this.currentHelp = help;
            if (help != null && help.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)help.getHelpID());
            }
            if (this.haveCalledInitializeButtons) {
                this.initializeButtons();
            }
        }
    }

    protected int getOptionsAlign() {
        return -1;
    }

    protected ActionListener getButtonListener() {
        return null;
    }

    protected Object[] getClosingOptions() {
        return null;
    }

    protected HelpCtx getHelpCtx() {
        return null;
    }

    public void windowDeactivated(WindowEvent p1) {
    }

    public void windowClosed(WindowEvent p1) {
    }

    public void windowDeiconified(WindowEvent p1) {
    }

    public void windowOpened(WindowEvent p1) {
    }

    public void windowIconified(WindowEvent p1) {
    }

    public void windowClosing(WindowEvent p1) {
        this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
        this.dispose();
    }

    public void windowActivated(WindowEvent p1) {
    }

    public static void addChangeListener(ChangeListener l) {
        Set set = listeners;
        synchronized (set) {
            listeners.add(l);
        }
    }

    public static void removeChangeListener(ChangeListener l) {
        Set set = listeners;
        synchronized (set) {
            listeners.remove(l);
        }
    }

    private static void fireChangeEvent() {
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$core$NbPresenter;

            public void run() {
                Iterator it;
                Set set = listeners;
                synchronized (set) {
                    it = new HashSet(listeners).iterator();
                }
                ChangeEvent ev = new ChangeEvent(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = 5.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter);
                while (it.hasNext()) {
                    ((ChangeListener)it.next()).stateChanged(ev);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNbPresenter();
        }
        return this.accessibleContext;
    }

    private static String getMessageTypeDescription(int messageType) {
        switch (messageType) {
            case 0: {
                return NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("ACSD_ErrorMessage");
            }
            case 2: {
                return NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("ACSD_WarningMessage");
            }
            case 3: {
                return NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("ACSD_QuestionMessage");
            }
            case 1: {
                return NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("ACSD_InformationMessage");
            }
            case -1: {
                return NbBundle.getBundle((Class)(class$org$netbeans$core$NbPresenter == null ? (class$org$netbeans$core$NbPresenter = NbPresenter.class$("org.netbeans.core.NbPresenter")) : class$org$netbeans$core$NbPresenter)).getString("ACSD_PlainMessage");
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        listeners = new HashSet();
    }

    private class AccessibleNbPresenter
    extends JDialog.AccessibleJDialog {
        AccessibleNbPresenter() {
            super(NbPresenter.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (NbPresenter.this.currentMessage instanceof Accessible && NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleName() != null) {
                return NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleName();
            }
            return super.getAccessibleName();
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (NbPresenter.this.currentMessage instanceof Accessible && NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleDescription() != null) {
                return MessageFormat.format(NbPresenter.getMessageTypeDescription(NbPresenter.this.descriptor.getMessageType()), NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleDescription());
            }
            return super.getAccessibleDescription();
        }
    }

    private class ButtonListener
    implements ActionListener,
    ComponentListener,
    PropertyChangeListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object[] arr;
            Object pressedOption = evt.getSource();
            if (evt.getActionCommand() == NbPresenter.CANCEL_COMMAND) {
                pressedOption = NotifyDescriptor.CLOSED_OPTION;
            } else {
                int i;
                if (evt.getSource() == NbPresenter.this.stdHelpButton) {
                    NbTopManager.get().showHelp(NbPresenter.this.currentHelp);
                    return;
                }
                Object[] options = NbPresenter.this.descriptor.getOptions();
                if (options != null && NbPresenter.this.currentPrimaryButtons != null && options.length == NbPresenter.this.currentPrimaryButtons.length - (NbPresenter.this.currentHelp != null ? 1 : 0)) {
                    i = 0;
                    while (i < NbPresenter.this.currentPrimaryButtons.length) {
                        if (evt.getSource() == NbPresenter.this.currentPrimaryButtons[i]) {
                            pressedOption = options[i];
                        }
                        ++i;
                    }
                }
                if ((options = NbPresenter.this.descriptor.getAdditionalOptions()) != null && NbPresenter.this.currentSecondaryButtons != null && options.length == NbPresenter.this.currentSecondaryButtons.length) {
                    i = 0;
                    while (i < NbPresenter.this.currentSecondaryButtons.length) {
                        if (evt.getSource() == NbPresenter.this.currentSecondaryButtons[i]) {
                            pressedOption = options[i];
                        }
                        ++i;
                    }
                }
                if (evt.getSource() == NbPresenter.this.stdYesButton) {
                    pressedOption = NotifyDescriptor.YES_OPTION;
                } else if (evt.getSource() == NbPresenter.this.stdNoButton) {
                    pressedOption = NotifyDescriptor.NO_OPTION;
                } else if (evt.getSource() == NbPresenter.this.stdCancelButton) {
                    pressedOption = NotifyDescriptor.CANCEL_OPTION;
                } else if (evt.getSource() == NbPresenter.this.stdClosedButton) {
                    pressedOption = NotifyDescriptor.CLOSED_OPTION;
                } else if (evt.getSource() == NbPresenter.this.stdOKButton) {
                    pressedOption = NotifyDescriptor.OK_OPTION;
                }
            }
            NbPresenter.this.descriptor.setValue(pressedOption);
            ActionListener al = NbPresenter.this.getButtonListener();
            if (al != null) {
                if (pressedOption == evt.getSource()) {
                    al.actionPerformed(evt);
                } else {
                    al.actionPerformed(new ActionEvent(pressedOption, evt.getID(), evt.getActionCommand(), evt.getModifiers()));
                }
            }
            if ((arr = NbPresenter.this.getClosingOptions()) == null || pressedOption == NotifyDescriptor.CLOSED_OPTION) {
                NbPresenter.this.dispose();
            } else {
                List<Object> l = Arrays.asList(arr);
                if (l.contains(pressedOption)) {
                    NbPresenter.this.dispose();
                }
            }
        }

        public void componentShown(ComponentEvent p1) {
            NbPresenter.this.updateDefaultButton();
        }

        public void componentResized(ComponentEvent p1) {
        }

        public void componentHidden(ComponentEvent p1) {
            NbPresenter.this.updateDefaultButton();
        }

        public void componentMoved(ComponentEvent p1) {
        }

        public void propertyChange(PropertyChangeEvent p1) {
            if ("enabled".equals(p1.getPropertyName())) {
                NbPresenter.this.updateDefaultButton();
            }
        }
    }
}

