/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.ToolTipManager;
import org.netbeans.core.NetworkOptions;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IDESettings
extends SystemOption {
    static final long serialVersionUID = 801136840705717911L;
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_SHOW_TIPS_ON_STARTUP = "showTipsOnStartup";
    public static final String PROP_LAST_TIP = "lastTip";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String PROP_PROXY_HOST = "proxyHost";
    public static final String PROP_PROXY_PORT = "proxyPort";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_MODULES_SORT_MODE = "modulesSortMode";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_UIMODE = "UIMode";
    public static final String KEY_PROXY_HOST = "http.proxyHost";
    public static final String KEY_PROXY_PORT = "http.proxyPort";
    public static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String PROP_MINI_STATUS_BAR_STATE = "mini_status_bar_state";
    public static final int MODULES_SORT_UNSORTED = 0;
    public static final int MODULES_SORT_DISPLAYNAME = 1;
    public static final int MODULES_SORT_CODENAME = 2;
    public static final int MODULES_SORT_ENABLED = 3;
    public static final int MODULES_SORT_URL = 4;
    public static final int MODULES_SORT_CATEGORY = 5;
    private static boolean showToolTips = true;
    private static boolean showTips = true;
    private static int lastTip = -1;
    private static boolean confirmDelete = true;
    private static int modulesSortMode = 5;
    private static Hashtable alreadyLoadedBeans = new Hashtable();
    private static boolean useProxy = false;
    private static boolean isMiniStatusBarEnabled = true;
    private static String proxyHost = System.getProperty("http.proxyHost", "");
    private static String proxyPort = System.getProperty("http.proxyPort", "");
    private static int uiMode = 2;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private static Properties getPreInitProxyProps() throws IOException {
        String ideHome = System.getProperty("netbeans.home");
        String propsRelPath = "installer/pre-settings.properties";
        FileInputStream propsIStream = new FileInputStream(new File(ideHome, "installer/pre-settings.properties"));
        Properties propsRetVal = new Properties();
        propsRetVal.load(propsIStream);
        ((InputStream)propsIStream).close();
        return propsRetVal;
    }

    protected void initialize() {
        super.initialize();
        String newProxyHost = proxyHost;
        String newProxyPort = proxyPort;
        if (proxyHost.length() == 0 || proxyPort.length() == 0) {
            try {
                Properties props = IDESettings.getPreInitProxyProps();
                newProxyHost = props.getProperty("proxy_host");
                newProxyPort = props.getProperty("proxy_port");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (newProxyHost != null && newProxyPort != null) {
                this.setProxyHost(newProxyHost);
                this.setProxyPort(newProxyPort);
                this.setUseProxy(newProxyHost.length() != 0 && newProxyPort.length() != 0);
            }
        }
        this.putProperty(PROP_WWWBROWSER, "", false);
    }

    public static URL getRealHomeURL() {
        return NetworkOptions.getStaticHomeURL();
    }

    public int getModulesSortMode() {
        return modulesSortMode;
    }

    public void setModulesSortMode(int nue) {
        int oldValue = modulesSortMode;
        modulesSortMode = nue;
        this.firePropertyChange(PROP_MODULES_SORT_MODE, new Integer(oldValue), new Integer(nue));
    }

    public boolean getShowToolTipsInIDE() {
        return showToolTips;
    }

    public void setShowToolTipsInIDE(boolean value) {
        if (showToolTips == value) {
            return;
        }
        showToolTips = value;
        ToolTipManager.sharedInstance().setEnabled(value);
        this.firePropertyChange(PROP_SHOW_TOOLTIPS_IN_IDE, !showToolTips ? Boolean.TRUE : Boolean.FALSE, showToolTips ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getShowTipsOnStartup() {
        return showTips;
    }

    public void setShowTipsOnStartup(boolean value) {
        if (showTips == value) {
            return;
        }
        showTips = value;
        this.firePropertyChange(PROP_SHOW_TIPS_ON_STARTUP, !showTips ? Boolean.TRUE : Boolean.FALSE, showTips ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getLastTip() {
        return lastTip;
    }

    public void setLastTip(int value) {
        if (value == lastTip) {
            return;
        }
        Integer oldValue = new Integer(lastTip);
        lastTip = value;
        this.firePropertyChange(PROP_LAST_TIP, oldValue, new Integer(lastTip));
    }

    public boolean getConfirmDelete() {
        return confirmDelete;
    }

    public void setConfirmDelete(boolean value) {
        if (value == confirmDelete) {
            return;
        }
        Boolean oldValue = confirmDelete ? Boolean.TRUE : Boolean.FALSE;
        confirmDelete = value;
        ExplorerPanel.setConfirmDelete((boolean)value);
        this.firePropertyChange(PROP_CONFIRM_DELETE, oldValue, confirmDelete ? Boolean.TRUE : Boolean.FALSE);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettings.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings)).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettings.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings);
    }

    public Hashtable getLoadedBeans() {
        return alreadyLoadedBeans;
    }

    public void setLoadedBeans(Hashtable table) {
        alreadyLoadedBeans = table;
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String homePage) {
        HtmlBrowser.setHomePage((String)homePage);
    }

    public boolean getMiniStatusBarState() {
        return isMiniStatusBarEnabled;
    }

    public void setMiniStatusBarState(boolean state) {
        if (isMiniStatusBarEnabled != state) {
            boolean oldValue = isMiniStatusBarEnabled;
            isMiniStatusBarEnabled = state;
            this.firePropertyChange(PROP_MINI_STATUS_BAR_STATE, oldValue ? Boolean.TRUE : Boolean.FALSE, isMiniStatusBarEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean value) {
        if (useProxy != value) {
            boolean oldValue = useProxy;
            useProxy = value;
            if (value) {
                System.setProperty(KEY_PROXY_HOST, this.getProxyHost());
                System.setProperty(KEY_PROXY_PORT, this.getProxyPort());
                System.setProperty(KEY_NON_PROXY_HOSTS, this.getDefaultNonProxyHosts());
            } else {
                System.setProperty(KEY_PROXY_HOST, "");
                System.setProperty(KEY_PROXY_PORT, "");
                System.setProperty(KEY_NON_PROXY_HOSTS, "");
            }
            this.firePropertyChange(PROP_USE_PROXY, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String value) {
        if (!proxyHost.equals(value)) {
            String oldValue = proxyHost;
            proxyHost = value;
            if (this.getUseProxy()) {
                System.setProperty(KEY_PROXY_HOST, proxyHost);
            }
            this.firePropertyChange(PROP_PROXY_HOST, oldValue, proxyHost);
        }
    }

    public String getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(String value) {
        if (!proxyPort.equals(value)) {
            String oldValue = proxyPort;
            proxyPort = value;
            if (this.getUseProxy()) {
                System.setProperty(KEY_PROXY_PORT, proxyPort);
            }
            this.firePropertyChange(PROP_PROXY_PORT, oldValue, proxyPort);
        }
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean s) {
        boolean old = this.getShowFileExtensions();
        DataNode.setShowFileExtensions((boolean)s);
        this.firePropertyChange(PROP_SHOW_FILE_EXTENSIONS, old ? Boolean.TRUE : Boolean.FALSE, s ? Boolean.TRUE : Boolean.FALSE);
    }

    public HtmlBrowser.Factory getWWWBrowser() {
        try {
            Node.Handle hdl;
            Node n;
            InstanceCookie ic;
            Object obj = this.getProperty(PROP_WWWBROWSER);
            if (obj instanceof String && !"".equals(obj)) {
                Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettings.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory, (String)obj, null));
                return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
            }
            if (obj == null || "".equals(obj)) {
                Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettings.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory));
                Iterator it = res.allInstances().iterator();
                while (it.hasNext()) {
                    Object brow = it.next();
                    FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder folder = DataFolder.findFolder((FileObject)fo);
                    DataObject[] dobjs = folder.getChildren();
                    int i = 0;
                    while (i < dobjs.length) {
                        Object o = null;
                        try {
                            InstanceCookie cookie;
                            if (!Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("hidden")) && (cookie = (InstanceCookie)dobjs[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie)) != null && (o = cookie.instanceCreate()) != null && o.equals(brow)) {
                                return (HtmlBrowser.Factory)brow;
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        catch (ClassNotFoundException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        ++i;
                    }
                }
                return null;
            }
            if (obj instanceof Node.Handle && (ic = (InstanceCookie)(n = (hdl = (Node.Handle)obj).getNode()).getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = IDESettings.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) != null) {
                Object o = ic.instanceCreate();
                return (HtmlBrowser.Factory)o;
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return null;
    }

    public void setWWWBrowser(HtmlBrowser.Factory brow) {
        try {
            if (brow == null) {
                this.putProperty(PROP_WWWBROWSER, "", true);
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettings.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory, null, (Object)brow));
            if (item != null) {
                this.putProperty(PROP_WWWBROWSER, item.getId(), true);
            } else {
                ErrorManager.getDefault().log("IDESettings: Cannot find browser in lookup");
                this.putProperty(PROP_WWWBROWSER, "", true);
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            DataObject[] dobjs = folder.getChildren();
            int i = 0;
            while (i < dobjs.length) {
                Object o = null;
                try {
                    InstanceCookie ic = (InstanceCookie)dobjs[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                    if (ic != null) {
                        o = ic.instanceCreate();
                    }
                }
                catch (IOException ex) {
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (o != null && o.equals(brow)) {
                    dobjs[i].getPrimaryFile().setAttribute("DEFAULT_BROWSER", (Object)Boolean.TRUE);
                } else {
                    Object attr = dobjs[i].getPrimaryFile().getAttribute("DEFAULT_BROWSER");
                    if (attr != null && attr instanceof Boolean) {
                        dobjs[i].getPrimaryFile().setAttribute("DEFAULT_BROWSER", (Object)Boolean.FALSE);
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void setUIMode(int uiMode) {
        if (IDESettings.uiMode == uiMode) {
            return;
        }
        int oldValue = IDESettings.uiMode;
        IDESettings.uiMode = uiMode;
        this.firePropertyChange(PROP_UIMODE, new Integer(oldValue), new Integer(uiMode));
    }

    public int getUIMode() {
        return uiMode;
    }

    private String getDefaultNonProxyHosts() {
        String nonProxy = "localhost";
        try {
            nonProxy = nonProxy + "|" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return nonProxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

