/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class ListImageEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String PROP_IMAGES = "images";
    public static final String PROP_VALUES = "values";
    public static final String PROP_DESCRIPTIONS = "descriptions";
    private boolean canWrite = true;
    private boolean canRead = true;
    private Image[] images = null;
    private Integer[] values = null;
    private String[] descriptions = null;

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor d = env.getFeatureDescriptor();
        if (d instanceof Node.Property) {
            this.canWrite = ((Node.Property)d).canWrite();
            this.canRead = ((Node.Property)d).canRead();
        }
        Image[] imgs = null;
        Integer[] vals = null;
        String[] descs = null;
        Object o = d.getValue(PROP_IMAGES);
        if (o instanceof Image[]) {
            imgs = (Image[])o;
        }
        if ((o = d.getValue(PROP_VALUES)) instanceof Integer[]) {
            vals = (Integer[])o;
        }
        if ((o = d.getValue(PROP_DESCRIPTIONS)) instanceof String[]) {
            descs = (String[])o;
        }
        if (imgs != null && vals != null) {
            int length = imgs.length;
            if (vals.length < length) {
                length = vals.length;
            }
            if (descs != null && descs.length < length) {
                length = descs.length;
            }
            this.images = new Image[length];
            this.values = new Integer[length];
            this.descriptions = new String[length];
            int i = 0;
            while (i < length) {
                this.images[i] = imgs[i];
                this.values[i] = vals[i];
                this.descriptions[i] = descs == null ? vals[i].toString() : descs[i];
                ++i;
            }
        }
    }

    public boolean isEditable() {
        return this.canWrite;
    }

    public String getAsText() {
        int i = this.findIndex(this.values, this.getValue());
        return (String)this.findObject(this.descriptions, i);
    }

    public void setAsText(String str) throws IllegalArgumentException {
        int i = this.findIndex(this.descriptions, str);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        this.setValue(this.findObject(this.values, i));
    }

    public String[] getTags() {
        return this.descriptions;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
        Image img = (Image)this.findObject(this.images, this.findIndex(this.values, this.getValue()));
        if (img != null) {
            g.drawImage(img, rectangle.x + (rectangle.width - img.getWidth(null)) / 2, rectangle.y + (rectangle.height - img.getHeight(null)) / 2, img.getWidth(null), img.getHeight(null), null);
        }
    }

    public String getJavaInitializationString() {
        return "new Integer(" + this.getValue() + ")";
    }

    private Object findObject(Object[] objs, int i) {
        if (objs == null || i < 0 || i >= objs.length) {
            return null;
        }
        return objs[i];
    }

    private int findIndex(Object[] objs, Object obj) {
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i].equals(obj)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

