/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.beaninfo.editors.ExtensionListEditor;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;

public class ExtensionListCustomEditor
extends JPanel {
    ExtensionList value;
    ExtensionListEditor editor;
    private static final int DEFAULT_WIDTH = 400;
    static final long serialVersionUID = -4347656479280614636L;
    private JScrollPane itemListScroll;
    private JLabel itemLabel;
    private JPanel buttonsPanel;
    private JTextField itemField;
    private JPanel editPanel;
    private JList itemList;
    private JLabel itemListLabel;
    private JButton changeButton;
    private JPanel jPanel1;
    private JButton addButton;
    private JButton removeButton;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor;

    private String[] getStrings() {
        ArrayList l = new ArrayList();
        if (this.value == null) {
            return new String[0];
        }
        Enumeration e = this.value.extensions();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        e = this.value.mimeTypes();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l.toArray(new String[l.size()]);
    }

    public ExtensionListCustomEditor(ExtensionListEditor ed) {
        this.editor = ed;
        this.value = (ExtensionList)((ExtensionList)this.editor.getValue()).clone();
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setSelectionMode(0);
        this.itemList.setListData(this.getStrings());
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor == null ? (class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor = ExtensionListCustomEditor.class$("org.netbeans.beaninfo.editors.ExtensionListCustomEditor")) : class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor));
        this.itemLabel.setText(bundle.getString("CTL_ELCE_Item"));
        this.itemListLabel.setText(bundle.getString("CTL_ELCE_ItemList"));
        this.addButton.setText(bundle.getString("CTL_ELCE_Add"));
        this.changeButton.setText(bundle.getString("CTL_ELCE_Change"));
        this.removeButton.setText(bundle.getString("CTL_ELCE_Remove"));
        this.itemLabel.setDisplayedMnemonic(bundle.getString("CTL_ELCE_Item_Mnemonic").charAt(0));
        this.itemListLabel.setDisplayedMnemonic(bundle.getString("CTL_ELCE_ItemList_Mnemonic").charAt(0));
        this.addButton.setMnemonic(bundle.getString("CTL_ELCE_Add_Mnemonic").charAt(0));
        this.changeButton.setMnemonic(bundle.getString("CTL_ELCE_Change_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(bundle.getString("CTL_ELCE_Remove_Mnemonic").charAt(0));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE"));
        this.itemField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Add"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Change"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Remove"));
        if (!this.editor.isEditable()) {
            this.itemField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.updateButtons();
    }

    public Dimension getPreferredSize() {
        Dimension sup = super.getPreferredSize();
        return new Dimension(Math.max(sup.width, 400), sup.height);
    }

    private void initComponents() {
        this.editPanel = new JPanel();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new GridBagLayout());
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExtensionListCustomEditor.this.itemListValueChanged(evt);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editPanel.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setLabelFor(this.itemField);
        this.itemLabel.setText("item");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        this.editPanel.add((Component)this.itemLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.editPanel.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setLabelFor(this.itemList);
        this.itemListLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editPanel.add((Component)this.itemListLabel, gridBagConstraints);
        this.add((Component)this.editPanel, "Center");
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonsPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.add((Component)this.buttonsPanel, "East");
    }

    private String addTexts() {
        StringTokenizer st = new StringTokenizer(this.itemField.getText(), ",. \n\t");
        String last = null;
        while (st.hasMoreTokens()) {
            last = st.nextToken();
            if (last.indexOf(47) >= 0) {
                this.value.addMimeType(last);
                continue;
            }
            this.value.addExtension(last);
        }
        return last;
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        int sel = this.itemList.getSelectedIndex();
        String s = (String)this.itemList.getModel().getElementAt(sel);
        if (s.indexOf(47) >= 0) {
            this.value.removeMimeType(s);
        } else {
            this.value.removeExtension(s);
        }
        this.doAdd();
    }

    private int indexOf(String[] array, String item) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int sel = this.itemList.getSelectedIndex();
        String s = (String)this.itemList.getModel().getElementAt(sel);
        if (s.indexOf(47) >= 0) {
            this.value.removeMimeType(s);
        } else {
            this.value.removeExtension(s);
        }
        this.itemList.setListData(this.getStrings());
        int count = this.itemList.getModel().getSize();
        if (count != 0) {
            if (sel >= count) {
                sel = count - 1;
            }
            this.itemList.setSelectedIndex(sel);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
        int sel = this.itemList.getSelectedIndex();
        if (sel != -1) {
            this.itemField.setText((String)this.itemList.getModel().getElementAt(sel));
        }
    }

    private void doAdd() {
        String last = this.addTexts();
        String[] values = this.getStrings();
        int index = this.indexOf(values, last);
        this.itemList.setListData(values);
        if (index >= 0) {
            this.itemList.setSelectedIndex(index);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.doAdd();
    }

    private void updateButtons() {
        int sel = this.itemList.getSelectedIndex();
        if (sel == -1 || !this.editor.isEditable()) {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        this.editor.setValue(this.value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        static final long serialVersionUID = 487512296465844339L;
        static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof String)) {
                return this;
            }
            String text = (String)value;
            if ("".equals(text)) {
                text = NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor == null ? (class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor = EmptyStringListCellRenderer.class$("org.netbeans.beaninfo.editors.ExtensionListCustomEditor")) : class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor), (String)"CTL_ELCE_Empty");
            }
            this.setText(text);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

