/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.ResourceParser;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class InjectableResourceManager
extends ResourceManagerDefaultImpl {
    private final ClassLoader classLoader;
    private final Cache<Pair<String, String>, Resource> resourceCache = new Cache<Pair<String, String>, Resource>(){

        protected Resource createNew(Pair<String, String> resourceName) {
            String qualifiedResourceName = InjectableResourceManager.this.getQualifiedResourceName((String)resourceName.getFirst(), (String)resourceName.getSecond());
            InputStream in = InjectableResourceManager.this.classLoader.getResourceAsStream(qualifiedResourceName);
            if (in == null) {
                return null;
            }
            Reader reader = InjectableResourceManager.this.createReader(in);
            ResourceParser parser = (ResourceParser)InjectableResourceManager.this.registeredParsers.get(resourceName.getSecond());
            if (parser == null) {
                throw new RuntimeException("No Parser registered for extension '" + (String)resourceName.getSecond() + "'! Known extensions are '" + InjectableResourceManager.this.registeredParsers.keySet() + "'");
            }
            Resource res = parser.parse(reader, qualifiedResourceName);
            res.setFullyQualifiedName((String)resourceName.getFirst());
            return res;
        }
    };
    public static final String FILE_ENCODING = "fileEncoding";

    @Inject
    public InjectableResourceManager(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Resource loadResource(String fullyQualifiedName, String extension) {
        return (Resource)this.resourceCache.get((Object)Tuples.pair((Object)fullyQualifiedName, (Object)extension));
    }

    private String getQualifiedResourceName(String fullyQualifiedName, String extension) {
        return String.valueOf(fullyQualifiedName.replace("::", "/")) + "." + extension;
    }

    @Inject(optional=true)
    public void setFileEncoding(@Named(value="fileEncoding") String fileEncoding) {
        super.setFileEncoding(fileEncoding);
    }
}

