/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASTArrayInitializer;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

public class ASTArrayDimensions
extends SimpleNode {
    public Class baseType;
    private int arrayDims;
    public transient int[] dimensions;

    ASTArrayDimensions(int n) {
        super(n);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        int n = this.jjtGetNumChildren();
        if (n > 0) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
            if (simpleNode instanceof ASTArrayInitializer) {
                if (this.baseType == null) {
                    throw new EvalError("Internal Array Eval err:  unknown base type", this);
                }
                Object object = ((ASTArrayInitializer)simpleNode).eval(this.baseType, nameSpace, interpreter);
                Class<?> clazz = object.getClass();
                this.dimensions = new int[Reflect.getArrayDimensions(clazz)];
                if (this.dimensions.length != this.arrayDims) {
                    throw new EvalError("Incompatible initializer. Allocation calls for a " + this.arrayDims + " dimensional array, but initializer is a " + this.dimensions.length + " dimensional array", this);
                }
                Object object2 = object;
                int n2 = 0;
                while (n2 < this.dimensions.length) {
                    this.dimensions[n2] = Array.getLength(object2);
                    if (this.dimensions[n2] > 0) {
                        object2 = Array.get(object2, 0);
                    }
                    ++n2;
                }
                return object;
            }
            this.dimensions = new int[n];
            int n3 = 0;
            while (n3 < this.dimensions.length) {
                try {
                    Object object = ((SimpleNode)this.jjtGetChild(n3)).eval(nameSpace, interpreter);
                    this.dimensions[n3] = ((Primitive)object).intValue();
                }
                catch (Exception exception) {
                    throw new EvalError("Array index: " + n3 + " does not evaluate to an integer", this);
                }
                ++n3;
            }
        }
        return Primitive.VOID;
    }

    public Object eval(Class clazz, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Interpreter.debug("array base type = " + clazz);
        this.baseType = clazz;
        return this.eval(nameSpace, interpreter);
    }
}

