/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.hibernate.tm.SyncTransactionManager;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAException;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.PreparedCommand;
import net.sf.ehcache.transaction.xa.PreparedContext;
import net.sf.ehcache.transaction.xa.TransactionXARequestProcessor;
import net.sf.ehcache.transaction.xa.TwoPcExecutionListener;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import net.sf.ehcache.transaction.xa.XARequest;
import net.sf.ehcache.transaction.xa.XARequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheXAResourceImpl
implements EhcacheXAResource {
    private static final int LOCK_TIMEOUT = 15000;
    private static final int DEFAULT_TX_TIMEOUT = 60;
    private static final int MILLISEC_PER_SECOND = 1000;
    private static final Logger LOG = LoggerFactory.getLogger((String)EhcacheXAResourceImpl.class.getName());
    private final String cacheName;
    private final XARequestProcessor processor;
    private final EhcacheXAStore ehcacheXAStore;
    private final Store store;
    private final Store oldVersionStore;
    private final TransactionManager txnManager;
    private final Ehcache cache;
    private final Set<Xid> recoverySet = new HashSet<Xid>();
    private final boolean bypassValidation;
    private volatile int transactionTimeout = 60;
    private volatile Xid currentXid;
    private List<TwoPcExecutionListener> twoPcExecutionListeners = new ArrayList<TwoPcExecutionListener>();

    public EhcacheXAResourceImpl(Ehcache cache, TransactionManager txnManager, EhcacheXAStore ehcacheXAStore) {
        String cacheMgrName = cache.getCacheManager() == null || !cache.getCacheManager().isNamed() ? "__DEFAULT__" : cache.getCacheManager().getName();
        this.cacheName = cache.getName() + "@" + cacheMgrName + ".cacheManager";
        this.store = ehcacheXAStore.getUnderlyingStore();
        this.txnManager = txnManager;
        this.ehcacheXAStore = ehcacheXAStore;
        this.oldVersionStore = ehcacheXAStore.getOldVersionStore();
        this.cache = cache;
        this.processor = new TransactionXARequestProcessor(this);
        this.bypassValidation = txnManager instanceof SyncTransactionManager;
    }

    public void addTwoPcExecutionListener(TwoPcExecutionListener listener) {
        this.twoPcExecutionListeners.add(listener);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.start called for Txn with flag: " + this.prettyPrintFlags(flags) + " and id: " + xid);
        }
        this.currentXid = xid;
    }

    public void end(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.end called for Txn with flag: " + this.prettyPrintFlags(flags) + " and id: " + xid);
        }
        if (this.isFlagSet(flags, 0x20000000)) {
            if (this.ehcacheXAStore.isPrepared(xid)) {
                this.markContextAsRolledbackIfRecovered(xid);
            } else {
                this.ehcacheXAStore.removeData(xid);
            }
        }
        this.currentXid = null;
    }

    public int prepare(Xid xid) throws XAException {
        for (TwoPcExecutionListener twoPcExecutionListener : this.twoPcExecutionListeners) {
            try {
                twoPcExecutionListener.beforePrepare(this);
            }
            catch (RuntimeException ex) {
                LOG.warn("exception thrown before prepare in TwoPcExecutionListener " + twoPcExecutionListener, (Throwable)ex);
            }
        }
        return this.processor.process(new XARequest(XARequest.RequestType.PREPARE, this.getCurrentTransaction(), xid, 0));
    }

    int prepareInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.prepare called for Txn with id: " + xid);
        }
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
        CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
        Object[] updatedKeys = context.getUpdatedKeys();
        this.tryLockingKeysRequiredForPrepare(storeLockProvider, oldVersionStoreLockProvider, updatedKeys);
        try {
            this.validateCommands(context, xid);
        }
        catch (XAException e) {
            this.cleanUpFailure(xid, storeLockProvider, oldVersionStoreLockProvider, updatedKeys);
            throw e;
        }
        PreparedContext preparedContext = this.ehcacheXAStore.createPreparedContext();
        for (VersionAwareCommand command : context.getCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            this.oldVersionStore.put(this.store.get(command.getKey()));
            preparedContext.addCommand(command);
        }
        oldVersionStoreLockProvider.unlockWriteLockForAllKeys(updatedKeys);
        boolean writes = false;
        HashSet<Object> keysAlreadyProcessed = new HashSet<Object>(updatedKeys.length);
        try {
            for (VersionAwareCommand command : context.getCommands()) {
                writes = command.execute(this.store) || writes;
                keysAlreadyProcessed.add(command.getKey());
            }
        }
        catch (IllegalStateException e) {
            this.switchValuesBack(keysAlreadyProcessed);
            this.cleanUpFailure(xid, storeLockProvider, null, updatedKeys);
            throw new EhcacheXAException("Couldn't execute command on store!", 103);
        }
        return this.determinePrepareReturnCode(xid, updatedKeys, preparedContext, writes);
    }

    private int determinePrepareReturnCode(Xid xid, Object[] updatedKeys, PreparedContext preparedContext, boolean writes) throws EhcacheXAException {
        if (writes) {
            this.ehcacheXAStore.prepare(xid, preparedContext);
            return 0;
        }
        if (updatedKeys.length > 0) {
            LOG.warn(updatedKeys.length + " updated keys, but nothing got changed?!");
            this.ehcacheXAStore.prepare(xid, preparedContext);
            return 0;
        }
        this.ehcacheXAStore.removeData(xid);
        this.fireAfterCommitOrRollback();
        return 3;
    }

    private void switchValuesBack(Object ... keysAlreadyProcessed) {
        for (Object key : keysAlreadyProcessed) {
            if (key == null) continue;
            Element element = this.oldVersionStore.remove(key);
            if (element != null) {
                this.store.put(element);
                continue;
            }
            this.store.remove(key);
        }
    }

    private void tryLockingKeysRequiredForPrepare(CacheLockProvider storeLockProvider, CacheLockProvider oldVersionStoreLockProvider, Object[] updatedKeys) throws EhcacheXAException {
        try {
            oldVersionStoreLockProvider.getAndWriteLockAllSyncForKeys(15000L, updatedKeys);
        }
        catch (TimeoutException ex) {
            throw new EhcacheXAException("could not lock all required entries in oldVersionStore", 102, ex);
        }
        try {
            storeLockProvider.getAndWriteLockAllSyncForKeys(15000L, updatedKeys);
        }
        catch (TimeoutException ex) {
            oldVersionStoreLockProvider.unlockWriteLockForAllKeys(updatedKeys);
            throw new EhcacheXAException("could not lock all required entries in storeLockProvider", 102, ex);
        }
    }

    private void cleanUpFailure(Xid xid, CacheLockProvider storeLockProvider, CacheLockProvider oldVersionStoreLockProvider, Object[] updatedKeys) {
        HashSet<Object> keys = new HashSet<Object>(Arrays.asList(updatedKeys));
        if (!this.bypassValidation) {
            for (Object e : keys) {
                this.ehcacheXAStore.checkin(e, xid, true);
            }
        }
        storeLockProvider.unlockWriteLockForAllKeys(updatedKeys);
        if (oldVersionStoreLockProvider != null) {
            oldVersionStoreLockProvider.unlockWriteLockForAllKeys(updatedKeys);
        }
    }

    public void forget(Xid xid) throws XAException {
        this.processor.process(new XARequest(XARequest.RequestType.FORGET, this.getCurrentTransaction(), xid));
    }

    void forgetInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.forget called for Txn with id: " + xid);
        }
        if (this.ehcacheXAStore.isPrepared(xid)) {
            this.markContextAsRolledbackIfRecovered(xid);
        } else {
            this.ehcacheXAStore.removeData(xid);
        }
    }

    public Xid[] recover(int flags) throws XAException {
        Xid[] allPreparedXids;
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.recover called for Txn with flag: " + this.prettyPrintFlags(flags));
        }
        HashSet<Xid> xids = new HashSet<Xid>();
        if (this.isFlagSet(flags, 0x1000000)) {
            this.recoverySet.clear();
        }
        for (Xid preparedXid : allPreparedXids = this.ehcacheXAStore.getPreparedXids()) {
            if (!this.recoverySet.contains(preparedXid)) {
                xids.add(preparedXid);
            }
            this.recoverySet.add(preparedXid);
        }
        for (Xid preparedXid : xids) {
            this.markContextAsRolledbackIfRecovered(preparedXid);
        }
        Xid[] toRecover = xids.toArray(new Xid[xids.size()]);
        if (this.isFlagSet(flags, 0x800000)) {
            this.recoverySet.clear();
        }
        return toRecover;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Transaction txn = this.getCurrentTransaction();
        if (onePhase) {
            this.onePhaseCommit(xid);
        } else {
            this.processor.process(new XARequest(XARequest.RequestType.COMMIT, txn, xid, 0, onePhase));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void commitInternal(Xid xid, boolean onePhase) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.commit called for Txn with phase: " + (onePhase ? "onePhase" : "twoPhase") + " and id: " + xid);
        }
        if (onePhase) {
            if (this.ehcacheXAStore.getPreparedContext(xid) != null) throw new EhcacheXAException(xid + " has been prepared! Cannot operate one phased commit!", -6);
            this.onePhaseCommit(xid);
        } else {
            PreparedContext context = this.ehcacheXAStore.getPreparedContext(xid);
            CacheLockProvider oldVersionStoreProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
            CacheLockProvider storeProvider = (CacheLockProvider)this.store.getInternalContext();
            Object[] keys = context.getUpdatedKeys();
            if (!context.isCommitted() && !context.isRolledBack()) {
                context.setCommitted(true);
                oldVersionStoreProvider.getAndWriteLockAllSyncForKeys(keys);
                for (PreparedCommand command : context.getPreparedCommands()) {
                    Object key = command.getKey();
                    if (key == null) continue;
                    this.potentiallyCheckin(context, command, xid);
                    this.oldVersionStore.remove(key);
                }
                storeProvider.unlockWriteLockForAllKeys(keys);
                oldVersionStoreProvider.unlockWriteLockForAllKeys(keys);
            } else if (context.isRolledBack()) {
                throw new EhcacheXAException("Transaction " + xid + " has been heuristically rolled back", 6);
            }
        }
        this.ehcacheXAStore.removeData(xid);
        this.fireAfterCommitOrRollback();
    }

    private boolean isLastCommandForKey(PreparedContext context, PreparedCommand command) {
        List<PreparedCommand> commands = context.getPreparedCommands();
        ListIterator<PreparedCommand> listIterator = commands.listIterator(commands.lastIndexOf(command) + 1);
        while (listIterator.hasNext()) {
            if (!listIterator.next().getKey().equals(command.getKey())) continue;
            return false;
        }
        return true;
    }

    private void potentiallyCheckin(PreparedContext context, PreparedCommand command, Xid xid) {
        if (!this.bypassValidation && this.isLastCommandForKey(context, command)) {
            this.ehcacheXAStore.checkin(command.getKey(), xid, !command.isWriteCommand());
        }
    }

    private void fireAfterCommitOrRollback() {
        for (TwoPcExecutionListener twoPcExecutionListener : this.twoPcExecutionListeners) {
            try {
                twoPcExecutionListener.afterCommitOrRollback(this);
            }
            catch (RuntimeException ex) {
                LOG.warn("exception thrown after commit or rollback in TwoPcExecutionListener " + twoPcExecutionListener, (Throwable)ex);
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        this.processor.process(new XARequest(XARequest.RequestType.ROLLBACK, this.getCurrentTransaction(), xid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.rollback called for Txn with id: " + xid);
        }
        PreparedContext context = this.ehcacheXAStore.getPreparedContext(xid);
        if (this.ehcacheXAStore.isPrepared(xid) && !context.isRolledBack() && !context.isCommitted()) {
            context.setRolledBack(true);
            CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
            CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
            Object[] updatedKeys = context.getUpdatedKeys();
            oldVersionStoreLockProvider.getAndWriteLockAllSyncForKeys(updatedKeys);
            try {
                for (Object updatedKey : updatedKeys) {
                    this.switchValuesBack(updatedKey);
                    storeLockProvider.getSyncForKey(updatedKey).unlock(LockType.WRITE);
                }
            }
            finally {
                oldVersionStoreLockProvider.unlockWriteLockForAllKeys(updatedKeys);
            }
        } else if (context != null && context.isCommitted()) {
            throw new EhcacheXAException("Transaction " + xid + " has been heuristically committed", 7);
        }
        this.ehcacheXAStore.removeData(xid);
        this.fireAfterCommitOrRollback();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        if (timeout < 0) {
            throw new EhcacheXAException("time out has to be > 0, but was " + timeout, -5);
        }
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public TransactionContext createTransactionContext() throws SystemException, RollbackException {
        Transaction transaction = this.txnManager.getTransaction();
        transaction.enlistResource((XAResource)this);
        if (this.cache.getWriterManager() != null) {
            try {
                transaction.registerSynchronization((Synchronization)new CacheWriterManagerSynchronization(this.currentXid));
            }
            catch (RollbackException e) {
            }
            catch (SystemException e) {
                throw new CacheException("Couldn't register CacheWriter's Synchronization with the JTA Transaction : " + e.getMessage(), e);
            }
        }
        if (this.currentXid == null) {
            throw new CacheException("enlistment of XAResource of cache named '" + this.getCacheName() + "' did not end up calling XAResource.start()");
        }
        return this.ehcacheXAStore.createTransactionContext(this.currentXid);
    }

    public TransactionContext getCurrentTransactionContext() {
        return this.currentXid != null ? this.ehcacheXAStore.getTransactionContext(this.currentXid) : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EhcacheXAResource) {
            EhcacheXAResource resource2 = (EhcacheXAResource)obj;
            return this.cacheName.equals(resource2.getCacheName());
        }
        return false;
    }

    public int hashCode() {
        return this.cacheName.hashCode();
    }

    private Transaction getCurrentTransaction() throws EhcacheXAException {
        Transaction txn;
        try {
            txn = this.txnManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EhcacheXAException("Couldn't get to current Transaction: " + e.getMessage(), e.errorCode, e);
        }
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onePhaseCommit(Xid xid) throws XAException {
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
        Object[] keys = context.getUpdatedKeys();
        try {
            storeLockProvider.getAndWriteLockAllSyncForKeys(this.transactionTimeout * 1000, keys);
        }
        catch (TimeoutException ex) {
            throw new EhcacheXAException("could not lock all required entries in storeLockProvider", 102, ex);
        }
        try {
            this.validateCommands(context, xid);
            LOG.debug("One phase commit called for Txn with id: {}", (Object)xid);
            List<VersionAwareCommand> commands = context.getCommands();
            for (VersionAwareCommand command : commands) {
                command.execute(this.store);
                Object key = command.getKey();
                if (key == null) continue;
                this.potentiallyCheckin(context, command, xid);
            }
        }
        finally {
            storeLockProvider.unlockWriteLockForAllKeys(keys);
        }
        this.ehcacheXAStore.removeData(xid);
        this.fireAfterCommitOrRollback();
    }

    private void potentiallyCheckin(TransactionContext context, VersionAwareCommand command, Xid xid) {
        List<VersionAwareCommand> commands = context.getCommands();
        ListIterator<VersionAwareCommand> listIterator = commands.listIterator(commands.lastIndexOf(command) + 1);
        boolean lastCommandForKey = true;
        while (listIterator.hasNext()) {
            if (!listIterator.next().getKey().equals(command.getKey())) continue;
            lastCommandForKey = false;
            break;
        }
        if (!this.bypassValidation && lastCommandForKey) {
            this.ehcacheXAStore.checkin(command.getKey(), xid, !command.isWriteCommand());
        }
    }

    private void validateCommands(TransactionContext context, Xid xid) throws XAException {
        if (this.bypassValidation) {
            return;
        }
        for (VersionAwareCommand command : context.getCommands()) {
            if (!command.isVersionAware() || this.ehcacheXAStore.isValid(command, xid)) continue;
            throw new EhcacheXAException("Element for key <" + command.getKey() + "> has changed since it was " + command.getCommandName() + " in the cache and the transaction committed (currentVersion: " + command.getVersion() + ")", 103);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markContextAsRolledbackIfRecovered(Xid preparedXid) throws EhcacheXAException {
        PreparedContext context = this.ehcacheXAStore.getPreparedContext(preparedXid);
        if (context == null) {
            return;
        }
        Object[] updatedKeys = context.getUpdatedKeys();
        if (updatedKeys.length > 0) {
            boolean readLocked;
            Object someKey = updatedKeys[0];
            Sync syncForKey = ((CacheLockProvider)this.store.getInternalContext()).getSyncForKey(someKey);
            try {
                readLocked = syncForKey.tryLock(LockType.READ, 1L);
            }
            catch (InterruptedException e) {
                throw new EhcacheXAException("Interrupted testing for Xid's status: " + preparedXid, -7);
            }
            if (readLocked) {
                try {
                    if (!context.isCommitted() && !context.isRolledBack()) {
                        for (Object updatedKey : updatedKeys) {
                            this.oldVersionStore.remove(updatedKey);
                        }
                        context.setRolledBack(true);
                    }
                }
                finally {
                    syncForKey.unlock(LockType.READ);
                }
            }
        }
    }

    private boolean isFlagSet(int flags, int mask) {
        return mask == (flags & mask);
    }

    private String printFlag(int flags, int mask, String flagStr) {
        return this.isFlagSet(flags, mask) ? flagStr : "";
    }

    private String prettyPrintFlags(int flags) {
        StringBuilder flagStrings = new StringBuilder();
        flagStrings.append(this.printFlag(flags, 0x800000, "TMENDRSCAN "));
        flagStrings.append(this.printFlag(flags, 0x20000000, "TMFAIL "));
        flagStrings.append(this.printFlag(flags, 0x200000, "TMJOIN "));
        flagStrings.append(this.printFlag(flags, 0x40000000, "TMONEPHASE "));
        flagStrings.append(this.printFlag(flags, 0x8000000, "TMRESUME "));
        flagStrings.append(this.printFlag(flags, 0x1000000, "TMSTARTRSCAN "));
        flagStrings.append(this.printFlag(flags, 0x4000000, "TMSUCCESS "));
        flagStrings.append(this.printFlag(flags, 0x2000000, "TMSUSPEND "));
        String flagStr = flagStrings.toString();
        return flagStr.equals("") ? "TMNOFLAGS" : flagStr;
    }

    private class CacheWriterManagerSynchronization
    implements Synchronization {
        private Xid currentXid;

        public CacheWriterManagerSynchronization(Xid currentXid) {
            this.currentXid = currentXid;
        }

        public void beforeCompletion() {
            TransactionContext context = EhcacheXAResourceImpl.this.ehcacheXAStore.getTransactionContext(this.currentXid);
            for (VersionAwareCommand versionAwareCommand : context.getCommands()) {
                versionAwareCommand.execute(EhcacheXAResourceImpl.this.cache.getWriterManager());
            }
        }

        public void afterCompletion(int status) {
        }
    }
}

