/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import junit.extensions.jfcunit.WindowMonitor;
import junit.extensions.jfcunit.finder.Finder;

public abstract class AbstractWindowFinder
extends Finder {
    private String m_title;
    private boolean m_caseIndependent = false;

    public AbstractWindowFinder(String str) {
        this(str, false);
        this.setWait(30);
    }

    public AbstractWindowFinder(String title, boolean caseIndependent) {
        this.setTitle(title);
        this.m_caseIndependent = caseIndependent;
        this.createPatternMatcher(this.m_title, caseIndependent);
    }

    public final void setTitle(String title) {
        this.m_title = title;
    }

    public boolean isCaseIndependent() {
        return this.m_caseIndependent;
    }

    public final String getTitle() {
        return this.m_title;
    }

    public static List getWindows(List pRet, Container[] windows, Finder finder) {
        ArrayList<Window> ret = pRet;
        if (ret == null) {
            ret = new ArrayList<Window>();
        }
        if (windows == null || finder == null) {
            return ret;
        }
        for (int i = 0; i < windows.length; ++i) {
            Container c = windows[i];
            Window window = c instanceof Window ? (Window)windows[i] : SwingUtilities.getWindowAncestor(c);
            if (!finder.testComponent(window)) {
                AbstractWindowFinder.getWindows(ret, window.getOwnedWindows(), finder);
                continue;
            }
            String title = "";
            if (window instanceof Frame) {
                title = ((Frame)window).getTitle();
            } else if (window instanceof JDialog) {
                title = ((JDialog)window).getTitle();
            }
            if ("JUnit".equalsIgnoreCase(title)) continue;
            if (!ret.contains(window)) {
                ret.add(window);
            }
            AbstractWindowFinder.getWindows(ret, window.getOwnedWindows(), finder);
        }
        return ret;
    }

    public List findAll(Container[] owners) {
        List retSet = new ArrayList();
        int wait = Math.max(0, this.getWait());
        long date = System.currentTimeMillis() + (long)(wait * 1000);
        do {
            if ((retSet = owners == null ? AbstractWindowFinder.getWindows(retSet, WindowMonitor.getWindows(), this) : AbstractWindowFinder.getWindows(retSet, owners, this)).size() != 0) continue;
            this.pause(date);
        } while (retSet.size() == 0 && System.currentTimeMillis() < date);
        return retSet;
    }

    protected final boolean checkIfTitleMatches(String winTitle) {
        boolean value;
        boolean bl = value = this.m_title == null || winTitle != null && this.evaluate(winTitle, this.m_title);
        if (this.getDebug()) {
            System.err.println("Comparing window title(" + value + "): " + winTitle + " match " + this.m_title);
        }
        return value;
    }
}

