/*
 * SimpleChildrenListManager.java
 *
 * Created on November 12, 2002, 9:37 PM
 */

package gpcourse;

import cern.gp.explorer.test.helpers.SimpleDemoBean;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.NodeList;
import java.beans.IntrospectionException;
import java.util.Comparator;

/**
 * A simple example of a ChildrenListManager
 * @author  vbaggiol
 */
public class ExampleChildrenListManager implements ChildrenListManager {
  protected final static int NUMBER_OF_CHILDREN = 3;
  public final static String BEAN_NAME_PREFIX = "bean-";
  
  public Comparator getComparator() {
    return null; // do not compare
  }
  
  /**
   * simple implementation of ChildrenListManager.initChildrenList()
   * This method is called by the GP explorer when the parent node in the tree is opened. 
   * It creates NUMBER_OF_CHILDREN children and adds them to nodeList.
   * Each of the children have again a SimpleChildrenListManager objects that creates their own
   * children.
   *
   * @param nodeList the list of nodes to be initialized
   */
  public void initChildrenList(NodeList nodeList) {
    try {
      for (int ix=0; ix<NUMBER_OF_CHILDREN; ix++) {
        GPNode node = NodeFactory.createNode(new ExampleBean(BEAN_NAME_PREFIX + ix));
        nodeList.addNode(node);
      }
    } catch (IntrospectionException ex) { ex.printStackTrace(); }
  }
  
}
