
/* This file is part of xtmodcoll-3.0, (c) xtmod.com
 * 
 * xtmodcoll-3.0 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * xtmodcoll-3.0 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser Public License
 * along with xtmodcoll-3.0.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.xtmod.util.algo;

/**
 * Extracts a unique feature from an object, such as a name, or an id, or similar.
 * 
 * Depending on what is to be done with the feature, it may be necessary to implement </ol>
 * <li> hashCode()
 * <li> equals()
 * </ol>
 * 
 */
public interface Feature<T, R> {

	
	public R feature(T x);
	

	/**
	 * Required by some APIs that need to sort.
	 */
	public static interface SortableFeature <TT, RR extends Comparable> extends Feature<TT,RR>{
		RR feature(TT x);
	}
	

	/**
	 * Convenience, as String is often used.
	 */
	public static interface StringFeature<TT> extends SortableFeature<TT, String> {
		
	}

	
}