package si.ijs.acs.objectexplorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

import si.ijs.acs.objectexplorer.engine.Converter;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.SimpleIntrospectable;

import com.cosylab.gui.components.r2.InterceptorPane;
import com.cosylab.gui.components.r2.SmartPanel;
import com.cosylab.gui.components.r2.SmartTextPane;
/**
 * This type was generated by a SmartGuide.
 * @author rbertoncelj
 * @author Miha Kadunc
 */
public class ObjectExplorer extends JFrame {
	private boolean ready = false;
	private JMenu eMenu=null;
	private JPanel ivjJFrameContentPane = null;
	private JPanel ivjObjectExplorerPane = null;
	private JButton ivjJButton1 = null;
	private JPanel ivjJPanel2 = null;
	private JSplitPane ivjJSplitPane1 = null;
	private JSplitPane ivjJSplitPane2 = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private JScrollPane ivjJScrollPane1 = null;
	private OETree ivjOETree1 = null;
	private JSplitPane ivjJSplitPane3 = null;
	private JScrollPane ivjJScrollPane4 = null;
	private TreeHandlerBean ivjTreeHandlerBean1 = null;
	private NotificationBean ivjNotificationBean1 = null;
	private JScrollPane ivjJScrollPane5 = null;
	private JMenuBar ivjObjectExplorerJMenuBar = null;
	private JCheckBoxMenuItem ivjJCheckBoxMenuItem1 = null;
	private JCheckBoxMenuItem ivjJCheckBoxMenuItem2 = null;
	private JMenu ivjJMenu2 = null;
	private JCheckBoxMenuItem ivjdebugCheckBox = null;
	private JCheckBoxMenuItem ivjConfirmationCheckBox = null;
	private JMenuItem ivjconnectMenuItem = null;
	private JPopupMenu ivjoeTreePopup = null;
	private JMenuItem ivjdisconnectMenuItem = null;
	private JMenu ivjconverterMenu = null;
	private JSeparator ivjJSeparator2 = null;
	private JLabel ivjJLabel1 = null;
	private JMenu ivjFile = null;
	private JMenuItem ivjJMenuItem1 = null;
	private JSeparator ivjJSeparator1 = null;
	private SmartTextPane ivjSmartTextArea2 = null;
	private SmartPanel ivjMessages = null;
	private JPanel ivjJPanel1 = null;
	private SmartPanel ivjResults = null;
	private boolean ivjConnPtoP4Aligning = false;
	private boolean ivjConnPtoP5Aligning = false;
	private SmartTextPane ivjSmartTextArea3 = null;
	private JButton ivjJButton2 = null;
	private JButton ivjJButton3 = null;
	private JPanel ivjJDialogContentPane = null;
	private JLabel ivjJLabel2 = null;
	private JTextField ivjJTextField1 = null;
	private JMenu ivjConnectMenu = null;
	private JDialog ivjOtherRemoteAccessDialog = null;
	private static Map converters = new HashMap();
	
	// ----- components manually added for new hierarchy -----
	private JTabbedPane jTabbedPaneTreesContainer = null;
	private JPanel jPanelTreeByName = null;
	private JScrollPane jScrollPaneTreeByName = null;
	private OETree oeTreeByName = null;
	private Hashtable devices = new Hashtable();
	private JButton jButtonSearchTreeByName = null;
	// ----- * by rbertoncelj
	
	private static final String CONVERTER_PROPERTY = "objexp.converters";
	private static ArrayList converterRepository = new ArrayList();
	
	public synchronized boolean isReady() {
		return ready;
	}
	public synchronized void setReady(boolean value){
		ready = value;
	}
	
	/**
	 * Get converter of the given introspectable, <code>null</code> if none is registered.
	 * @param introspectable	introspectable instance.
	 * @return	converter of the given introspectable, <code>null</code> if none is registered.
	 */
	public static Converter getConverter(SimpleIntrospectable introspectable)
	{
		return (Converter)converters.get(introspectable);
	}
	
	/**
	 * Remove converter from the given introspectable, <code>null</code> if none is registered.
	 * @param introspectable	introspectable instance.
	 */
	public static void removeConverter(SimpleIntrospectable introspectable)
	{
		converters.remove(introspectable);
	}
	
	/**
	 * Add converter of the given introspectable, <code>null</code> if none is registered.
	 * @param introspectable	introspectable instance.
	 * @param converter			converted to be added.
	 */
	public static void addConverter(SimpleIntrospectable introspectable, Converter converter)
	{
		converters.put(introspectable, converter);
	}
	
	/**
	 * Get all registered converters from converter repository.
	 * @return	list of all registered converters.
	 */
	public List getConverterRepository()
	{
		return converterRepository;
	}
	
	/**
	 * Load converters....
	 */
	private void loadConverters()
	{
		try
		{
			String fileName = (String)System.getProperty(CONVERTER_PROPERTY);
			
			getNotificationBean1().reportDebug(
					"ObjectExplorer::loadConverters",
					"Startup using '" +CONVERTER_PROPERTY + "' = '" + fileName + "'.");
			
			if (fileName == null)
				return;
			
			BufferedReader reader = new BufferedReader(new FileReader(fileName));
			
			String line = reader.readLine();
			while (line != null)
			{
				line = line.trim();
				if (line.length() > 0 && !line.startsWith("#"))
				{
					// line contains class name
					try
					{
						Class converterClass = Class.forName(line);
						Converter converter = (Converter)converterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
						getNotificationBean1().reportDebug(
								"ObjectExplorer::loadConverters",
								"Loaded converter '" + line + "' (" + converter.getDescription() + ").");
						converterRepository.add(converter);
					}
					catch (Throwable th)
					{
						getNotificationBean1().reportDebug(
								"ObjectExplorer::loadConverters",
								"Failed to load converter '" + line + "'.");
						th.printStackTrace();
					}
				}
				line = reader.readLine();
			}
			
			reader.close();
		}
		catch (Throwable th)
		{
			th.printStackTrace();
		}
		
		getNotificationBean1().reportDebug(
				"ObjectExplorer::loadConverters",
				"Registered " + converterRepository.size() + " converter(s).");
		
	}
	
	
	class IvjEventHandler implements java.awt.event.ActionListener, java.awt.event.MouseListener, java.awt.event.WindowListener, java.beans.PropertyChangeListener, javax.swing.event.TreeSelectionListener, si.ijs.acs.objectexplorer.OETreeEventListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (e.getSource() == ObjectExplorer.this.getJButton1() || e.getSource() == ObjectExplorer.this.getJButtonSearchTreeByName()) 
				connEtoM13(e);
			if (e.getSource() == ObjectExplorer.this.getJButton1() || e.getSource() == ObjectExplorer.this.getJButtonSearchTreeByName()) 
				connEtoM3(e);
			if (e.getSource() == ObjectExplorer.this.getJCheckBoxMenuItem1()) 
				connEtoM8(e);
			if (e.getSource() == ObjectExplorer.this.getJCheckBoxMenuItem2()) 
				connEtoM9(e);
			if (e.getSource() == ObjectExplorer.this.getdebugCheckBox()) 
				connEtoM10(e);
			if (e.getSource() == ObjectExplorer.this.getConfirmationCheckBox()) 
				connEtoM18(e);
			if (e.getSource() == ObjectExplorer.this.getdisconnectMenuItem()) 
				connEtoM11(e);
			if (e.getSource() == ObjectExplorer.this.getconnectMenuItem()) 
				connEtoM12(e);
			if (e.getSource() == ObjectExplorer.this.getJMenuItem1()) 
				connEtoC4(e);
			if (e.getSource() == ObjectExplorer.this.getConnectMenu()) 
				connEtoM5(e);
			if (e.getSource() == ObjectExplorer.this.getJButton3()) 
				connEtoM17(e);
			if (e.getSource() == ObjectExplorer.this.getJButton2()) 
				connEtoM15(e);
			if (e.getSource() == ObjectExplorer.this.getJButton2()) 
				connEtoC1(e);
		};
		public void firstTimeExpanded(si.ijs.acs.objectexplorer.FirstTimeExpandedEvent event) {
			if (event.getSource() == ObjectExplorer.this.getOETree1()) 
				connEtoM1(event);
			if (event.getSource() == ObjectExplorer.this.getOETreeByName() && isReady()) {	//added for 2nd tree
				getTreeHandlerBean1().getDevices(event);
			}
		};
		public void mouseClicked(java.awt.event.MouseEvent e) {
			if (e.getSource() == ObjectExplorer.this.getOETree1()) 
				connEtoC3(e);
			if (e.getSource() == ObjectExplorer.this.getOETreeByName()) {	//added for the 2nd tree
				ObjectExplorer.this.oeTreeByName_MouseClicked(e);
			}
		};
		public void mouseEntered(java.awt.event.MouseEvent e) {};
		public void mouseExited(java.awt.event.MouseEvent e) {};
		public void mousePressed(java.awt.event.MouseEvent e) {};
		public void mouseReleased(java.awt.event.MouseEvent e) {};
		public void propertyChange(java.beans.PropertyChangeEvent evt) {
			if (evt.getSource() == ObjectExplorer.this.getJSplitPane3() && (evt.getPropertyName().equals("dividerSize"))) 
				connPtoP4SetTarget();
			if (evt.getSource() == ObjectExplorer.this.getJSplitPane1() && (evt.getPropertyName().equals("dividerSize"))) 
				connPtoP4SetSource();
			if (evt.getSource() == ObjectExplorer.this.getJSplitPane3() && (evt.getPropertyName().equals("dividerSize"))) 
				connPtoP5SetTarget();
			if (evt.getSource() == ObjectExplorer.this.getJSplitPane2() && (evt.getPropertyName().equals("dividerSize"))) 
				connPtoP5SetSource();
		};
		public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
			if (e.getSource() == ObjectExplorer.this.getOETree1()) 
				connEtoM2();
			if (e.getSource() == ObjectExplorer.this.getOETreeByName()) {
				getTreeHandlerBean1().selectionChanged(getOETreeByName()); //TODO finish this
			}
		};
		public void windowActivated(java.awt.event.WindowEvent e) {};
		public void windowClosed(java.awt.event.WindowEvent e) {};
		public void windowClosing(java.awt.event.WindowEvent e) {
			if (e.getSource() == ObjectExplorer.this) 
				connEtoM6(e);
		};
		public void windowDeactivated(java.awt.event.WindowEvent e) {};
		public void windowDeiconified(java.awt.event.WindowEvent e) {};
		public void windowIconified(java.awt.event.WindowEvent e) {};
		public void windowOpened(java.awt.event.WindowEvent e) {};
	};
	private ReporterBean ivjReporterBean = null;
	public ObjectExplorer() {
		super();
		initialize();
		loadConverters();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (13.5.2001 16:19:23)
	 * @param menuItem javax.swing.JMenuItem
	 */
	public void addEngineMenu(JMenu menu) {
		if (eMenu != null) removeEngineMenu();
		eMenu = menu;
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				javax.swing.JComponent mb=getObjectExplorerJMenuBar();
				mb.add(eMenu);
				mb.revalidate();
				mb.repaint();
			}
		});
	}
	/**
	 * connEtoC1:  (JButton2.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectExplorer.startConnect(Ljava.lang.String;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC1(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.startConnect(getJTextField1().getText());
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC3:  (OETree1.mouse.mouseClicked(java.awt.event.MouseEvent) --> ObjectExplorer.oETree1_MouseClicked(Ljava.awt.event.MouseEvent;)V)
	 * @param arg1 java.awt.event.MouseEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC3(java.awt.event.MouseEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.oETree1_MouseClicked(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC4:  (JMenuItem1.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectExplorer.systemExit()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC4(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.systemExit();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	
	/**
	 *  updates "Show confirmation dialog" menu item 
	 *  before the menu contains it opens. 
	 */
	private void connEtoC5(java.awt.event.ActionEvent arg1) {
		try {
			JCheckBoxMenuItem item = getConfirmationCheckBox();
			item.setSelected(getNotificationBean1().isConfirmationDialog());
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	
	/**
	 * connEtoM1:  (OETree1.OETreeEvent.FirstTimeExpanded(si.ijs.acs.objectexplorer.FirstTimeExpandedEvent) --> TreeHandlerBean1.getDevices(Lsi.ijs.acs.objectexplorer.FirstTimeExpandedEvent;)V)
	 * @param arg1 si.ijs.acs.objectexplorer.FirstTimeExpandedEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM1(FirstTimeExpandedEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getTreeHandlerBean1().getDevices(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM10:  (debugCheckBox.action.actionPerformed(java.awt.event.ActionEvent) --> NotificationBean1.setDebugToConsole()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM10(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getNotificationBean1().setDebugToConsole();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM18:  (confirmationCheckBox.action.actionPerformed(java.awt.event.ActionEvent) --> NotificationBean1.setConfirmationDialog()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	private void connEtoM18(java.awt.event.ActionEvent arg1) {
		try {
			boolean b = ((JCheckBoxMenuItem)arg1.getSource()).isSelected();
			getNotificationBean1().setConfirmationDialog(b);
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM11:  (disconnectMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> TreeHandlerBean1.disconnect()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM11(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getTreeHandlerBean1().disconnect();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM12:  (connectMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> TreeHandlerBean1.connect()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM12(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getTreeHandlerBean1().connect();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM13:  (JButton1.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectExplorer.setEnabled(Z)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM13(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.setEnabled(false);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM15:  (JButton2.action.actionPerformed(java.awt.event.ActionEvent) --> JDialog1.dispose()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM15(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getOtherRemoteAccessDialog().dispose();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM17:  (JButton3.action.actionPerformed(java.awt.event.ActionEvent) --> JDialog1.dispose()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM17(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getOtherRemoteAccessDialog().dispose();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM2:  (OETree1.treeSelection. --> TreeHandlerBean1.selectionChanged()V)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM2() {
		try {
			// user code begin {1}
			// user code end
			getTreeHandlerBean1().selectionChanged(getOETree1());
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM3:  (JButton1.action.actionPerformed(java.awt.event.ActionEvent) --> OETree1.clearTree()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM3(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getOETree1().clearTree();
			//getOETreeByName().clearTree();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM5:  (JMenu1.action.actionPerformed(java.awt.event.ActionEvent) --> OETree1.clearTree()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM5(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getOETree1().clearTree();
			//getOETreeByName().clearTree();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM6:  (ObjectExplorer.window.windowClosing(java.awt.event.WindowEvent) --> TreeHandlerBean1.destroy()V)
	 * @param arg1 java.awt.event.WindowEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM6(java.awt.event.WindowEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getTreeHandlerBean1().destroy();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM8:  (JCheckBoxMenuItem1.action.actionPerformed(java.awt.event.ActionEvent) --> ReporterBean1.setExpand()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM8(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getReporterBean().setExpand();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoM9:  (JCheckBoxMenuItem2.action.actionPerformed(java.awt.event.ActionEvent) --> ReporterBean1.setWindow()V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoM9(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			getReporterBean().setWindow();
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP10SetTarget:  (ResultArea.this <--> ReporterBean1.resultArea)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP10SetTarget() {
		/* Set the target from the source */
		try {
			getNotificationBean1().setTextArea(getSmartTextArea2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP11SetTarget:  (JTextField1.this <--> JLabel2.labelFor)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP11SetTarget() {
		/* Set the target from the source */
		try {
			getJLabel2().setLabelFor(getJTextField1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP13SetTarget:  (SmartTextArea2.this <--> ReporterBean1.resultArea)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP13SetTarget() {
		/* Set the target from the source */
		try {
			getReporterBean().setResultArea(getSmartTextArea3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP14SetTarget:  (ObjectExplorer.this <--> NotificationBean1.parent)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP14SetTarget() {
		/* Set the target from the source */
		try {
			getNotificationBean1().setParent(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP1SetTarget:  (NotificationBean1.this <--> TreeHandlerBean1.notifier)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP1SetTarget() {
		/* Set the target from the source */
		try {
			getTreeHandlerBean1().setNotifier(getNotificationBean1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP2SetTarget:  (OETree1.this <--> TreeHandlerBean1.tree)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP2SetTarget() {
		/* Set the target from the source */
		try {
			getTreeHandlerBean1().setTree(getOETree1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP3SetTarget:  (NotificationBean1.this <--> ReporterBean1.notifier)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP3SetTarget() {
		/* Set the target from the source */
		try {
			getReporterBean().setNotifier(getNotificationBean1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP4SetSource:  (JSplitPane3.dividerSize <--> JSplitPane1.dividerSize)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP4SetSource() {
		/* Set the source from the target */
		try {
			if (ivjConnPtoP4Aligning == false) {
				// user code begin {1}
				// user code end
				ivjConnPtoP4Aligning = true;
				getJSplitPane3().setDividerSize(getJSplitPane1().getDividerSize());
				// user code begin {2}
				// user code end
				ivjConnPtoP4Aligning = false;
			}
		} catch (java.lang.Throwable ivjExc) {
			ivjConnPtoP4Aligning = false;
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP4SetTarget:  (OETree1.this <--> JButton1.nextFocusableComponent)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP4SetTarget() {
		/* Set the target from the source */
		try {
			if (ivjConnPtoP4Aligning == false) {
				// user code begin {1}
				// user code end
				ivjConnPtoP4Aligning = true;
				getJSplitPane1().setDividerSize(getJSplitPane3().getDividerSize());
				// user code begin {2}
				// user code end
				ivjConnPtoP4Aligning = false;
			}
		} catch (java.lang.Throwable ivjExc) {
			ivjConnPtoP4Aligning = false;
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP5SetSource:  (JSplitPane3.dividerSize <--> JSplitPane2.dividerSize)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP5SetSource() {
		/* Set the source from the target */
		try {
			if (ivjConnPtoP5Aligning == false) {
				// user code begin {1}
				// user code end
				ivjConnPtoP5Aligning = true;
				getJSplitPane3().setDividerSize(getJSplitPane2().getDividerSize());
				// user code begin {2}
				// user code end
				ivjConnPtoP5Aligning = false;
			}
		} catch (java.lang.Throwable ivjExc) {
			ivjConnPtoP5Aligning = false;
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP5SetTarget:  (JMenu1.this <--> File.nextFocusableComponent)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP5SetTarget() {
		/* Set the target from the source */
		try {
			if (ivjConnPtoP5Aligning == false) {
				// user code begin {1}
				// user code end
				ivjConnPtoP5Aligning = true;
				getJSplitPane2().setDividerSize(getJSplitPane3().getDividerSize());
				// user code begin {2}
				// user code end
				ivjConnPtoP5Aligning = false;
			}
		} catch (java.lang.Throwable ivjExc) {
			ivjConnPtoP5Aligning = false;
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connPtoP7SetTarget:  (ObjectExplorer.this <--> TreeHandlerBean1.parent)
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connPtoP7SetTarget() {
		/* Set the target from the source */
		try {
			getTreeHandlerBean1().setParent(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * Return the JMenu1 property value.
	 * @return javax.swing.JMenu
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenu getConnectMenu() {
		if (ivjConnectMenu == null) {
			try {
				ivjConnectMenu = new javax.swing.JMenu();
				ivjConnectMenu.setName("ConnectMenu");
				ivjConnectMenu.setMnemonic('c');
				ivjConnectMenu.setText("Connect    ");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjConnectMenu;
	}
	/**
	 * Return the connectMenuItem property value.
	 * @return javax.swing.JMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenuItem getconnectMenuItem() {
		if (ivjconnectMenuItem == null) {
			try {
				ivjconnectMenuItem = new javax.swing.JMenuItem();
				ivjconnectMenuItem.setName("connectMenuItem");
				ivjconnectMenuItem.setText("connect");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjconnectMenuItem;
	}
	
	/**
	 * ActionListener implementation for every converter item.
	 */
	class SetConverterActionListener implements ActionListener
	{
		private Converter converter;
		
		/**
		 * Constructor.
		 * @param converter
		 */
		public SetConverterActionListener(Converter converter)
		{
			this.converter = converter;
		}
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			
			Introspectable intro = getTreeHandlerBean1().getClicked();
			if (intro != null)
			{
				// remove
				if (converter == null)
					ObjectExplorer.removeConverter(intro);
				else
					ObjectExplorer.addConverter(intro, converter);
			}
		}
		/**
		 * @return Returns the converter.
		 */
		public Converter getConverter() {
			return converter;
		}
	};
	
	/**
	 * Return the convertMenuItem property value.
	 * @return javax.swing.JMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenu getconverterMenu() {
		if (ivjconverterMenu == null) {
			try {
				ivjconverterMenu = new javax.swing.JMenu();
				ivjconverterMenu.setName("converterMenu");
				ivjconverterMenu.setText("convert");
				// user code begin {1}
				
				// list of converters is static
				
				List converters = getConverterRepository();
				if (converters.size() > 0)
				{
					JMenuItem item = new JMenuItem("none");
					item.addActionListener(new SetConverterActionListener(null));
					ivjconverterMenu.add(item);
					ivjconverterMenu.add(new JSeparator());
				}
				
				Iterator iter = converters.iterator();
				while (iter.hasNext())
				{
					Converter converter = (Converter)iter.next();
					JMenuItem item = new JMenuItem(converter.getDescription());
					item.addActionListener(new SetConverterActionListener(converter));
					ivjconverterMenu.add(item);
				}
				
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjconverterMenu;
	}
	/**
	 * Return the debugCheckBox property value.
	 * @return javax.swing.JCheckBoxMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBoxMenuItem getdebugCheckBox() {
		if (ivjdebugCheckBox == null) {
			try {
				ivjdebugCheckBox = new javax.swing.JCheckBoxMenuItem();
				ivjdebugCheckBox.setName("debugCheckBox");
				ivjdebugCheckBox.setSelected(true);
				ivjdebugCheckBox.setMnemonic('d');
				ivjdebugCheckBox.setText("Debug to console");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjdebugCheckBox;
	}
	private javax.swing.JCheckBoxMenuItem getConfirmationCheckBox() {
		if (ivjConfirmationCheckBox == null) {
			try {
				ivjConfirmationCheckBox = new javax.swing.JCheckBoxMenuItem();
				ivjConfirmationCheckBox.setName("confirmationCheckBox");
				ivjConfirmationCheckBox.setSelected(getNotificationBean1().isConfirmationDialog());
				ivjConfirmationCheckBox.setText("Show confirmation dialog");
			} catch (java.lang.Throwable ivjExc) {
				handleException(ivjExc);
			}
		}
		return ivjConfirmationCheckBox;
	}
	/**
	 * Return the disconnectMenuItem property value.
	 * @return javax.swing.JMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenuItem getdisconnectMenuItem() {
		if (ivjdisconnectMenuItem == null) {
			try {
				ivjdisconnectMenuItem = new javax.swing.JMenuItem();
				ivjdisconnectMenuItem.setName("disconnectMenuItem");
				ivjdisconnectMenuItem.setSelected(true);
				ivjdisconnectMenuItem.setText("disconnect");
				ivjdisconnectMenuItem.setEnabled(true);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjdisconnectMenuItem;
	}
	/**
	 * Return the File property value.
	 * @return javax.swing.JMenu
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenu getFile() {
		if (ivjFile == null) {
			try {
				ivjFile = new javax.swing.JMenu();
				ivjFile.setName("File");
				ivjFile.setMnemonic('F');
				ivjFile.setText("File   ");
				ivjFile.add(getConnectMenu());
				ivjFile.add(getJSeparator1());
				ivjFile.add(getJMenuItem1());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjFile;
	}
	/**
	 * Return the JButton1 property value.
	 * @return javax.swing.JButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JButton getJButton1() {
		if (ivjJButton1 == null) {
			try {
				ivjJButton1 = new javax.swing.JButton();
				ivjJButton1.setName("JButton1");
				ivjJButton1.setMnemonic('S');
				ivjJButton1.setText("Search");
				ivjJButton1.setMaximumSize(new java.awt.Dimension(150, 25));
				ivjJButton1.setPreferredSize(new java.awt.Dimension(150, 25));
				ivjJButton1.setEnabled(false);
				ivjJButton1.setMinimumSize(new java.awt.Dimension(150, 25));
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJButton1;
	}
	/**
	 * Return the JButton2 property value.
	 * @return javax.swing.JButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JButton getJButton2() {
		if (ivjJButton2 == null) {
			try {
				ivjJButton2 = new javax.swing.JButton();
				ivjJButton2.setName("JButton2");
				ivjJButton2.setText("OK");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJButton2;
	}
	/**
	 * Return the JButton3 property value.
	 * @return javax.swing.JButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JButton getJButton3() {
		if (ivjJButton3 == null) {
			try {
				ivjJButton3 = new javax.swing.JButton();
				ivjJButton3.setName("JButton3");
				ivjJButton3.setText("Cancel");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJButton3;
	}
	/**
	 * Return the JCheckBoxMenuItem1 property value.
	 * @return javax.swing.JCheckBoxMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBoxMenuItem getJCheckBoxMenuItem1() {
		if (ivjJCheckBoxMenuItem1 == null) {
			try {
				ivjJCheckBoxMenuItem1 = new javax.swing.JCheckBoxMenuItem();
				ivjJCheckBoxMenuItem1.setName("JCheckBoxMenuItem1");
				ivjJCheckBoxMenuItem1.setMnemonic('e');
				ivjJCheckBoxMenuItem1.setText("Expand result data");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJCheckBoxMenuItem1;
	}
	/**
	 * Return the JCheckBoxMenuItem2 property value.
	 * @return javax.swing.JCheckBoxMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBoxMenuItem getJCheckBoxMenuItem2() {
		if (ivjJCheckBoxMenuItem2 == null) {
			try {
				ivjJCheckBoxMenuItem2 = new javax.swing.JCheckBoxMenuItem();
				ivjJCheckBoxMenuItem2.setName("JCheckBoxMenuItem2");
				ivjJCheckBoxMenuItem2.setSelected(true);
				ivjJCheckBoxMenuItem2.setMnemonic('i');
				ivjJCheckBoxMenuItem2.setText("Invocation response in a separate window");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJCheckBoxMenuItem2;
	}
	/**
	 * Return the JDialogContentPane property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJDialogContentPane() {
		if (ivjJDialogContentPane == null) {
			try {
				ivjJDialogContentPane = new javax.swing.JPanel();
				ivjJDialogContentPane.setName("JDialogContentPane");
				ivjJDialogContentPane.setLayout(new java.awt.GridBagLayout());
				
				java.awt.GridBagConstraints constraintsJTextField1 = new java.awt.GridBagConstraints();
				constraintsJTextField1.gridx = 0; constraintsJTextField1.gridy = 1;
				constraintsJTextField1.gridwidth = 2;
				constraintsJTextField1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextField1.weightx = 1.0;
				constraintsJTextField1.insets = new java.awt.Insets(4, 10, 8, 10);
				getJDialogContentPane().add(getJTextField1(), constraintsJTextField1);
				
				java.awt.GridBagConstraints constraintsJButton2 = new java.awt.GridBagConstraints();
				constraintsJButton2.gridx = 0; constraintsJButton2.gridy = 2;
				constraintsJButton2.anchor = java.awt.GridBagConstraints.SOUTHEAST;
				constraintsJButton2.weightx = 1.0;
				constraintsJButton2.weighty = 1.0;
				constraintsJButton2.ipadx = 20;
				constraintsJButton2.insets = new java.awt.Insets(4, 4, 8, 5);
				getJDialogContentPane().add(getJButton2(), constraintsJButton2);
				
				java.awt.GridBagConstraints constraintsJLabel2 = new java.awt.GridBagConstraints();
				constraintsJLabel2.gridx = 0; constraintsJLabel2.gridy = 0;
				constraintsJLabel2.gridwidth = 2;
				constraintsJLabel2.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJLabel2.anchor = java.awt.GridBagConstraints.WEST;
				constraintsJLabel2.insets = new java.awt.Insets(8, 10, 4, 10);
				getJDialogContentPane().add(getJLabel2(), constraintsJLabel2);
				
				java.awt.GridBagConstraints constraintsJButton3 = new java.awt.GridBagConstraints();
				constraintsJButton3.gridx = 1; constraintsJButton3.gridy = 2;
				constraintsJButton3.anchor = java.awt.GridBagConstraints.SOUTHWEST;
				constraintsJButton3.weightx = 1.0;
				constraintsJButton3.weighty = 1.0;
				constraintsJButton3.insets = new java.awt.Insets(4, 5, 8, 4);
				getJDialogContentPane().add(getJButton3(), constraintsJButton3);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJDialogContentPane;
	}
	/**
	 * Return the JFrameContentPane property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJFrameContentPane() {
		if (ivjJFrameContentPane == null) {
			try {
				ivjJFrameContentPane = new javax.swing.JPanel();
				ivjJFrameContentPane.setName("JFrameContentPane");
				ivjJFrameContentPane.setLayout(new java.awt.BorderLayout());
				getJFrameContentPane().add(getObjectExplorerPane(), "Center");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJFrameContentPane;
	}
	/**
	 * Return the JLabel1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabel1() {
		if (ivjJLabel1 == null) {
			try {
				ivjJLabel1 = new javax.swing.JLabel();
				ivjJLabel1.setName("JLabel1");
				ivjJLabel1.setFont(new java.awt.Font("Arial", 1, 14));
				ivjJLabel1.setText("   Object name");
				ivjJLabel1.setComponentOrientation(java.awt.ComponentOrientation.LEFT_TO_RIGHT);
				ivjJLabel1.setBounds(10, 0, 1, 1);
				ivjJLabel1.setForeground(java.awt.SystemColor.controlText);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabel1;
	}
	/**
	 * Return the JLabel2 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabel2() {
		if (ivjJLabel2 == null) {
			try {
				ivjJLabel2 = new javax.swing.JLabel();
				ivjJLabel2.setName("JLabel2");
				ivjJLabel2.setDisplayedMnemonic('E');
				ivjJLabel2.setText("Enter the name of the RemoteAccess class:");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabel2;
	}
	/**
	 * Return the JMenu2 property value.
	 * @return javax.swing.JMenu
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenu getJMenu2() {
		if (ivjJMenu2 == null) {
			try {
				ivjJMenu2 = new javax.swing.JMenu() {
					// hyatagai : 11-Nov-2009
					// Because JMenu, contrary to my expectation, does not
					// call actionPerformed when it opens, I reluctantly 
					// do like this.
					@Override
					public void setPopupMenuVisible(boolean b) {
						if (b) {
							ActionEvent ae = new ActionEvent(this, 0, null);
							connEtoC5(ae);
						}
						super.setPopupMenuVisible(b);
					}
				};
				ivjJMenu2.setName("JMenu2");
				ivjJMenu2.setMnemonic('V');
				ivjJMenu2.setText("View");
				ivjJMenu2.add(getJCheckBoxMenuItem1());
				ivjJMenu2.add(getJCheckBoxMenuItem2());
				ivjJMenu2.add(getdebugCheckBox());
				ivjJMenu2.add(getConfirmationCheckBox());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJMenu2;
	}
	/**
	 * Return the JMenuItem1 property value.
	 * @return javax.swing.JMenuItem
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenuItem getJMenuItem1() {
		if (ivjJMenuItem1 == null) {
			try {
				ivjJMenuItem1 = new javax.swing.JMenuItem();
				ivjJMenuItem1.setName("JMenuItem1");
				ivjJMenuItem1.setMnemonic('x');
				ivjJMenuItem1.setText("Exit");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJMenuItem1;
	}
	/**
	 * Return the JPanel1 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanel1() {
		if (ivjJPanel1 == null) {
			try {
				ivjJPanel1 = new javax.swing.JPanel();
				ivjJPanel1.setName("JPanel1");
				ivjJPanel1.setLayout(null);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanel1;
	}
	/**
	 * Return the JPanel2 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanel2() {
		if (ivjJPanel2 == null) {
			try {
				ivjJPanel2 = new javax.swing.JPanel();
				ivjJPanel2.setName("JPanel2");
				ivjJPanel2.setLayout(new java.awt.GridBagLayout());
				
				java.awt.GridBagConstraints constraintsJScrollPane1 = new java.awt.GridBagConstraints();
				constraintsJScrollPane1.gridx = 0; constraintsJScrollPane1.gridy = 1;
				constraintsJScrollPane1.fill = java.awt.GridBagConstraints.BOTH;
				constraintsJScrollPane1.weightx = 4.0;
				constraintsJScrollPane1.weighty = 1.0;
				getJPanel2().add(getJScrollPane1(), constraintsJScrollPane1);
				
				java.awt.GridBagConstraints constraintsJButton1 = new java.awt.GridBagConstraints();
				constraintsJButton1.gridx = 0; constraintsJButton1.gridy = 0;
				constraintsJButton1.fill = java.awt.GridBagConstraints.BOTH;
				getJPanel2().add(getJButton1(), constraintsJButton1);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanel2;
	}
	/**
	 * Return the JScrollPane1 property value.
	 * @return javax.swing.JScrollPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JScrollPane getJScrollPane1() {
		if (ivjJScrollPane1 == null) {
			try {
				ivjJScrollPane1 = new javax.swing.JScrollPane();
				ivjJScrollPane1.setName("JScrollPane1");
				getJScrollPane1().setViewportView(getOETree1());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJScrollPane1;
	}
	/**
	 * Return the JScrollPane4 property value.
	 * @return javax.swing.JScrollPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JScrollPane getJScrollPane4() {
		if (ivjJScrollPane4 == null) {
			try {
				ivjJScrollPane4 = new javax.swing.JScrollPane();
				ivjJScrollPane4.setName("JScrollPane4");
				getJScrollPane4().setViewportView(getSmartTextArea3());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJScrollPane4;
	}
	/**
	 * Return the JScrollPane5 property value.
	 * @return javax.swing.JScrollPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JScrollPane getJScrollPane5() {
		if (ivjJScrollPane5 == null) {
			try {
				ivjJScrollPane5 = new javax.swing.JScrollPane();
				ivjJScrollPane5.setName("JScrollPane5");
				getJScrollPane5().setViewportView(getSmartTextArea2());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJScrollPane5;
	}
	/**
	 * Return the JSeparator1 property value.
	 * @return javax.swing.JSeparator
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSeparator getJSeparator1() {
		if (ivjJSeparator1 == null) {
			try {
				ivjJSeparator1 = new javax.swing.JSeparator();
				ivjJSeparator1.setName("JSeparator1");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSeparator1;
	}
	/**
	 * Return the JSeparator2 property value.
	 * @return javax.swing.JSeparator
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSeparator getJSeparator2() {
		if (ivjJSeparator2 == null) {
			try {
				ivjJSeparator2 = new javax.swing.JSeparator();
				ivjJSeparator2.setName("JSeparator2");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSeparator2;
	}
	/**
	 * Return the JSplitPane1 property value.
	 * @return javax.swing.JSplitPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSplitPane getJSplitPane1() {
		if (ivjJSplitPane1 == null) {
			try {
				ivjJSplitPane1 = new javax.swing.JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT);
				ivjJSplitPane1.setName("JSplitPane1");
				ivjJSplitPane1.setDividerLocation(200);
				getJSplitPane1().add(getJTabbedPaneTreesContainer(), "left"); //Changed by rbertoncelj from panel2 to tabbed pane.
				getJSplitPane1().add(getJPanel1(), "right");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSplitPane1;
	}
	/**
	 * Return the JSplitPane2 property value.
	 * @return javax.swing.JSplitPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSplitPane getJSplitPane2() {
		if (ivjJSplitPane2 == null) {
			try {
				ivjJSplitPane2 = new javax.swing.JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT);
				ivjJSplitPane2.setName("JSplitPane2");
				ivjJSplitPane2.setDividerLocation(350);
				getJSplitPane2().add(getMessages(), "left");
				getJSplitPane2().add(getResults(), "right");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSplitPane2;
	}
	/**
	 * Return the JSplitPane3 property value.
	 * @return javax.swing.JSplitPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSplitPane getJSplitPane3() {
		if (ivjJSplitPane3 == null) {
			try {
				ivjJSplitPane3 = new javax.swing.JSplitPane(javax.swing.JSplitPane.VERTICAL_SPLIT);
				ivjJSplitPane3.setName("JSplitPane3");
				ivjJSplitPane3.setDividerSize(8);
				getJSplitPane3().add(getJSplitPane1(), "top");
				getJSplitPane3().add(getJSplitPane2(), "bottom");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSplitPane3;
	}
	/**
	 * Return the JTextField1 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextField1() {
		if (ivjJTextField1 == null) {
			try {
				ivjJTextField1 = new javax.swing.JTextField();
				ivjJTextField1.setName("JTextField1");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextField1;
	}
	/**
	 * Return the Messages property value.
	 * @return si.ijs.acs.objectexplorer.SmartPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private SmartPanel getMessages() {
		if (ivjMessages == null) {
			try {
				ivjMessages = new SmartPanel();
				ivjMessages.setName("Messages");
				ivjMessages.setLayout(new java.awt.CardLayout());
				getMessages().add(getJScrollPane5(), getJScrollPane5().getName());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjMessages;
	}
	/**
	 * Return the NotificationBean1 property value.
	 * @return si.ijs.acs.objectexplorer.NotificationBean
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private NotificationBean getNotificationBean1() {
		if (ivjNotificationBean1 == null) {
			try {
				ivjNotificationBean1 = new si.ijs.acs.objectexplorer.NotificationBean();
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjNotificationBean1;
	}
	/**
	 * Return the ObjectExplorerJMenuBar property value.
	 * @return javax.swing.JMenuBar
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JMenuBar getObjectExplorerJMenuBar() {
		if (ivjObjectExplorerJMenuBar == null) {
			try {
				ivjObjectExplorerJMenuBar = new javax.swing.JMenuBar();
				ivjObjectExplorerJMenuBar.setName("ObjectExplorerJMenuBar");
				ivjObjectExplorerJMenuBar.add(getFile());
				ivjObjectExplorerJMenuBar.add(getJMenu2());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjObjectExplorerJMenuBar;
	}
	/**
	 * Return the ObjectExplorerPane property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getObjectExplorerPane() {
		if (ivjObjectExplorerPane == null) {
			try {
				ivjObjectExplorerPane = new javax.swing.JPanel();
				ivjObjectExplorerPane.setName("ObjectExplorerPane");
				ivjObjectExplorerPane.setLayout(new java.awt.GridBagLayout());
				
				java.awt.GridBagConstraints constraintsJSplitPane3 = new java.awt.GridBagConstraints();
				constraintsJSplitPane3.gridx = 0; constraintsJSplitPane3.gridy = 0;
				constraintsJSplitPane3.fill = java.awt.GridBagConstraints.BOTH;
				constraintsJSplitPane3.weightx = 1.0;
				constraintsJSplitPane3.weighty = 1.0;
				constraintsJSplitPane3.insets = new java.awt.Insets(4, 4, 4, 4);
				getObjectExplorerPane().add(getJSplitPane3(), constraintsJSplitPane3);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjObjectExplorerPane;
	}
	/**
	 * Return the OETree1 property value.
	 * @return si.ijs.acs.objectexplorer.OETree
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private OETree getOETree1() {
		if (ivjOETree1 == null) {
			try {
				ivjOETree1 = new si.ijs.acs.objectexplorer.OETree();
				ivjOETree1.setName("OETree1");
				ivjOETree1.setBounds(0, 0, 600, 266);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjOETree1;
	}
	/**
	 * Return the oeTreePopup property value.
	 * @return javax.swing.JPopupMenu
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPopupMenu getoeTreePopup() {
		if (ivjoeTreePopup == null) {
			try {
				ivjoeTreePopup = new javax.swing.JPopupMenu();
				ivjoeTreePopup.setName("oeTreePopup");
				ivjoeTreePopup.setBackground(java.awt.SystemColor.control);
				ivjoeTreePopup.setForeground(java.awt.SystemColor.controlText);
				getoeTreePopup().add(getJLabel1(), getJLabel1().getName());
				ivjoeTreePopup.add(getJSeparator2());
				ivjoeTreePopup.add(getdisconnectMenuItem());
				ivjoeTreePopup.add(getconnectMenuItem());
				// user code begin {1}
				ivjoeTreePopup.add(getconverterMenu());
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjoeTreePopup;
	}
	/**
	 * Return the JDialog1 property value.
	 * @return javax.swing.JDialog
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JDialog getOtherRemoteAccessDialog() {
		if (ivjOtherRemoteAccessDialog == null) {
			try {
				ivjOtherRemoteAccessDialog = new javax.swing.JDialog();
				ivjOtherRemoteAccessDialog.setName("OtherRemoteAccessDialog");
				ivjOtherRemoteAccessDialog.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
				ivjOtherRemoteAccessDialog.setTitle("Other Remote Access Type");
				ivjOtherRemoteAccessDialog.setBounds(487, 37, 310, 124);
				ivjOtherRemoteAccessDialog.setModal(true);
				ivjOtherRemoteAccessDialog.setResizable(false);
				getOtherRemoteAccessDialog().setContentPane(getJDialogContentPane());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjOtherRemoteAccessDialog;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/27/2001 5:27:40 PM)
	 */
	public ReporterBean getReporter() {
		return getReporterBean();	
	}
	/**
	 * Return the ReporterBean1 property value.
	 * @return si.ijs.acs.objectexplorer.ReporterBean
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private ReporterBean getReporterBean() {
		if (ivjReporterBean == null) {
			try {
				ivjReporterBean = new si.ijs.acs.objectexplorer.ReporterBean();
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjReporterBean;
	}
	/**
	 * Return the SmartPanel1 property value.
	 * @return si.ijs.acs.objectexplorer.SmartPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private SmartPanel getResults() {
		if (ivjResults == null) {
			try {
				ivjResults = new SmartPanel();
				ivjResults.setName("Results");
				ivjResults.setLayout(new java.awt.BorderLayout());
				getResults().add(getJScrollPane4(), "Center");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjResults;
	}
	/**
	 * Return the SmartTextArea2 property value.
	 * @return com.cosylab.gui.components.SmartTextPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private SmartTextPane getSmartTextArea2() {
		if (ivjSmartTextArea2 == null) {
			try {
				ivjSmartTextArea2 = new SmartTextPane();
				ivjSmartTextArea2.setName("SmartTextArea2");
				ivjSmartTextArea2.setBounds(0, 0, 131, 72);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjSmartTextArea2;
	}
	/**
	 * Return the SmartTextArea3 property value.
	 * @return com.cosylab.gui.components.SmartTextArea
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private SmartTextPane getSmartTextArea3() {
		if (ivjSmartTextArea3 == null) {
			try {
				ivjSmartTextArea3 = new SmartTextPane();
				ivjSmartTextArea3.setName("SmartTextArea3");
				ivjSmartTextArea3.setBounds(0, 0, 160, 120);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjSmartTextArea3;
	}
	/**
	 * Return the TreeHandlerBean1 property value.
	 * @return si.ijs.acs.objectexplorer.TreeHandlerBean
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private TreeHandlerBean getTreeHandlerBean1() {
		if (ivjTreeHandlerBean1 == null) {
			try {
				ivjTreeHandlerBean1 = new si.ijs.acs.objectexplorer.TreeHandlerBean(devices, getOETree1(), getOETreeByName());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjTreeHandlerBean1;
	}
	/**
	 * Called whenever the part throws an exception.
	 * @param exception java.lang.Throwable
	 */
	private void handleException(Throwable exception) {
		
		/* Uncomment the following lines to print uncaught exceptions to stdout */
		System.out.println("--------- UNCAUGHT EXCEPTION in Object Explorer ---------");
		exception.printStackTrace(System.out);
	}
	/**
	 * Initializes connections
	 * @exception java.lang.Exception The exception description.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initConnections() throws java.lang.Exception {
		// user code begin {1}
		// user code end
		getJButton1().addActionListener(ivjEventHandler);
		getJButtonSearchTreeByName().addActionListener(ivjEventHandler);
		getOETree1().addOETreeEventListener(ivjEventHandler);
		getOETreeByName().addOETreeEventListener(ivjEventHandler);
		this.addWindowListener(ivjEventHandler);
		getJCheckBoxMenuItem1().addActionListener(ivjEventHandler);
		getJCheckBoxMenuItem2().addActionListener(ivjEventHandler);
		getdebugCheckBox().addActionListener(ivjEventHandler);
		getConfirmationCheckBox().addActionListener(ivjEventHandler);
		getOETree1().addMouseListener(ivjEventHandler);
		getOETreeByName().addMouseListener(ivjEventHandler);
		getdisconnectMenuItem().addActionListener(ivjEventHandler);
		getconnectMenuItem().addActionListener(ivjEventHandler);
		getJMenuItem1().addActionListener(ivjEventHandler);
		getOETree1().addTreeSelectionListener(ivjEventHandler);
		getOETreeByName().addTreeSelectionListener(ivjEventHandler);
		getJSplitPane3().addPropertyChangeListener(ivjEventHandler);
		getJSplitPane1().addPropertyChangeListener(ivjEventHandler);
		getJSplitPane2().addPropertyChangeListener(ivjEventHandler);
		getConnectMenu().addActionListener(ivjEventHandler);
		getJButton3().addActionListener(ivjEventHandler);
		getJButton2().addActionListener(ivjEventHandler);
		connPtoP2SetTarget();
		connPtoP1SetTarget();
		connPtoP14SetTarget();
		connPtoP7SetTarget();
		connPtoP3SetTarget();
		connPtoP10SetTarget();
		connPtoP4SetTarget();
		connPtoP5SetTarget();
		connPtoP11SetTarget();
		connPtoP13SetTarget();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9.4.2002 17:46:00)
	 * @param param java.lang.String[]
	 */
	private void initEngines(String[] param) {
		if (param==null) return;
		for (int i=0; i<param.length;i++) {
			JRadioButtonMenuItem radio= new JRadioButtonMenuItem();
			radio.setActionCommand(param[i]);
			radio.setName(param[i]);
			radio.setText(param[i]);
			radio.setSelected(false);
			radio.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent a){
					startConnect(((JRadioButtonMenuItem)a.getSource()).getName());
				}
			});
			getConnectMenu().add(radio);
		}
		
		getConnectMenu().add(new JSeparator());
		JMenuItem radio= new JMenuItem();
		radio.setActionCommand("Other");
		radio.setName("Other");
		radio.setText("Other...");
		radio.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent a){
				getOtherRemoteAccessDialog().show();
			}
		});
		getConnectMenu().add(radio);
		
		if (param.length>0) startConnect(param[0]);
	}
	/**
	 * Initialize the class.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initialize() {
		try {
			// user code begin {1}
			// user code end
			setName("ObjectExplorer");
			setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
			setJMenuBar(getObjectExplorerJMenuBar());
			setBounds(50,50,50,50);
			setSize(760, 655);
			setTitle("Object Explorer");
			setContentPane(getJFrameContentPane());
			initConnections();
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
		// user code begin {2}
		setGlassPane(new InterceptorPane(this));	
		// user code end
	}
	
	
//	----- getters for manually added components -----
	
	private JTabbedPane getJTabbedPaneTreesContainer() {
		if (jTabbedPaneTreesContainer == null) {
			try {
				jTabbedPaneTreesContainer = new JTabbedPane();
				jTabbedPaneTreesContainer.addTab("By type", getJPanel2());
				jTabbedPaneTreesContainer.addTab("By device", getJPanelTreeByName());
			} catch (java.lang.Throwable ivjExc) {
				handleException(ivjExc);
			}
		}
		return jTabbedPaneTreesContainer;
	}
	
	private javax.swing.JPanel getJPanelTreeByName() {
		if (jPanelTreeByName == null) {
			try {
				jPanelTreeByName = new javax.swing.JPanel();
				jPanelTreeByName.setLayout(new java.awt.GridBagLayout());
				
				java.awt.GridBagConstraints constraintsJScrollPane1 = new java.awt.GridBagConstraints();
				constraintsJScrollPane1.gridx = 0; constraintsJScrollPane1.gridy = 1;
				constraintsJScrollPane1.fill = java.awt.GridBagConstraints.BOTH;
				constraintsJScrollPane1.weightx = 4.0;
				constraintsJScrollPane1.weighty = 1.0;
				jPanelTreeByName.add(getJScrollPaneTreeByName(), constraintsJScrollPane1);
				
				java.awt.GridBagConstraints constraintsJButton1 = new java.awt.GridBagConstraints();
				constraintsJButton1.gridx = 0; constraintsJButton1.gridy = 0;
				constraintsJButton1.fill = java.awt.GridBagConstraints.BOTH;
				jPanelTreeByName.add(getJButtonSearchTreeByName(), constraintsJButton1);
			} catch (java.lang.Throwable ivjExc) {
				handleException(ivjExc);
			}
		}
		return jPanelTreeByName;
	}
	
	private javax.swing.JScrollPane getJScrollPaneTreeByName() {
		if (jScrollPaneTreeByName == null) {
			try {
				jScrollPaneTreeByName = new javax.swing.JScrollPane();
				getJScrollPaneTreeByName().setViewportView(getOETreeByName());
			} catch (java.lang.Throwable ivjExc) {
				handleException(ivjExc);
			}
		}
		return jScrollPaneTreeByName;
	}
	
	private OETree getOETreeByName() {
		if (oeTreeByName == null) {
			try {
				oeTreeByName = new si.ijs.acs.objectexplorer.OETree();
				oeTreeByName.setBounds(0, 0, 600, 266);
				oeTreeByName.setName("treeByName");
			} catch (java.lang.Throwable ivjExc) {
				handleException(ivjExc);
			}
		}
		return oeTreeByName;
	}
	
	private JButton getJButtonSearchTreeByName() {
		if (jButtonSearchTreeByName == null) {
			jButtonSearchTreeByName = new javax.swing.JButton("Search");
			jButtonSearchTreeByName.setMnemonic('S');
			jButtonSearchTreeByName.setPreferredSize(new java.awt.Dimension(150, 25));
			jButtonSearchTreeByName.setEnabled(false);
			jButtonSearchTreeByName.setMinimumSize(new java.awt.Dimension(150, 25));
		}
		return jButtonSearchTreeByName;
	}
	
//	----- * by rbertoncelj
	
//	----- Additional methods needed for new tree hierarchy -----
	
	
	public void oeTreeByName_MouseClicked(java.awt.event.MouseEvent mouseEvent) {
		if (SwingUtilities.isRightMouseButton(mouseEvent)) {
			TreePath clickedPath=getOETreeByName().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
			Object clicked=null;
			if (clickedPath != null) clicked=clickedPath.getLastPathComponent();
			if (clicked instanceof Introspectable) {
				Introspectable node=(Introspectable)clicked;
				
				getconnectMenuItem().setEnabled(!node.isConnected());
				getdisconnectMenuItem().setEnabled(node.isConnected());
				getJLabel1().setText(node.toString());
				getTreeHandlerBean1().setClicked(node);//TODO is this ok?
				
				// disable/enable converters
				Converter currentConverter = ObjectExplorer.getConverter(node);
				int len = getconverterMenu().getItemCount();
				for (int i = 0; i < len; i++)
				{
					JMenuItem item = getconverterMenu().getItem(i);
					if (item != null &&
							item.getActionListeners() != null &&
							item.getActionListeners().length == 1 &&
							item.getActionListeners()[0] instanceof SetConverterActionListener)
					{
						SetConverterActionListener scal = (SetConverterActionListener)item.getActionListeners()[0];
						if (scal.getConverter() == currentConverter)
							item.setEnabled(false);
						else
							item.setEnabled(true);
					}
				}
				getoeTreePopup().show(getOETreeByName(), mouseEvent.getX(), mouseEvent.getY());
			}
		}
		return;	
	}
	
//	----- * by rbertoncelj
	
	
	/**
	 * Comment
	 */
	public void jMenuItem1_Accelerator(javax.swing.KeyStroke arg1) {
		System.exit(0);
	}
	/**
	 * Starts the application.
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		try {
			//System.out.println("DEBUG / si.ijs.acs.objectexplorer.ObjectExplorer.main(...) / Started TEST_24");
			/* Create the frame */
			ObjectExplorer aObjectExplorer = new ObjectExplorer();
			/* Add a windowListener for the windowClosingEvent */
			aObjectExplorer.addWindowListener(new java.awt.event.WindowAdapter() {
				public void windowClosing(java.awt.event.WindowEvent e) {
					System.exit(0);
				};
			});
			aObjectExplorer.setVisible(true);
			if (args.length>0) {
				aObjectExplorer.initEngines(args);
			}
		} catch (Throwable exception) {
			System.err.println("Exception occurred in main() of VajApplicationCreationWizard");
			exception.printStackTrace(System.out);
		}
	}
	/**
	 * Comment
	 */
	public void oETree1_MouseClicked(java.awt.event.MouseEvent mouseEvent) {
		//TODO ?!?!?!?!?!?!?
		if (SwingUtilities.isRightMouseButton(mouseEvent)) {
			TreePath clickedPath=getOETree1().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
			Object clicked=null;
			if (clickedPath != null) clicked=clickedPath.getLastPathComponent();
			if (clicked instanceof Introspectable) {
				Introspectable node=(Introspectable)clicked;
				
				getconnectMenuItem().setEnabled(!node.isConnected());
				getdisconnectMenuItem().setEnabled(node.isConnected() && !node.isNonSticky());
				getJLabel1().setText(node.toString());
				getTreeHandlerBean1().setClicked(node);
				
				// disable/enable converters
				Converter currentConverter = ObjectExplorer.getConverter(node);
				int len = getconverterMenu().getItemCount();
				for (int i = 0; i < len; i++)
				{
					JMenuItem item = getconverterMenu().getItem(i);
					if (item != null &&
							item.getActionListeners() != null &&
							item.getActionListeners().length == 1 &&
							item.getActionListeners()[0] instanceof SetConverterActionListener)
					{
						SetConverterActionListener scal = (SetConverterActionListener)item.getActionListeners()[0];
						if (scal.getConverter() == currentConverter)
							item.setEnabled(false);
						else
							item.setEnabled(true);
					}
				}
				getoeTreePopup().show(getOETree1(), mouseEvent.getX(), mouseEvent.getY());
			}
		}
		return;	
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (13.5.2001 16:19:53)
	 */
	public void removeEngineMenu() {
		if (eMenu != null) {
			getObjectExplorerJMenuBar().remove(eMenu);	
			getObjectExplorerJMenuBar().revalidate();
		}
		eMenu=null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (13.5.2001 13:58:02)
	 */
	public void setDetailsPanel(JPanel panel) {
		getJSplitPane1().setBottomComponent(panel);
		if (getJSplitPane1().getDividerLocation()>getJSplitPane1().getWidth()-20) getJSplitPane1().setDividerLocation(300);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (13.5.2001 13:58:02)
	 */
	public void setEnabled(boolean en) {
		getOETree1().setEnabled(en);
		getJSplitPane1().setEnabled(en);
		getJButton1().setEnabled(en);
		getJButtonSearchTreeByName().setEnabled(en);
		repaint();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9.4.2002 17:47:22)
	 * @param param javax.swing.JRadioButtonMenuItem
	 */
	private void startConnect(String name) {
		java.awt.Component[] c= getConnectMenu().getMenuComponents();
		boolean sel=false;
		for (int i=0; i<c.length;i++) {
			if (c[i] instanceof JRadioButtonMenuItem) {
				((JRadioButtonMenuItem)c[i]).setSelected(((JRadioButtonMenuItem)c[i]).getName().equals(name));
				sel=sel||((JRadioButtonMenuItem)c[i]).isSelected();
			}
		}
		if(!sel) {
			JRadioButtonMenuItem radio= new JRadioButtonMenuItem();
			radio.setActionCommand(name);
			radio.setName(name);
			radio.setText(name);
			radio.setSelected(true);
			radio.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent a){
					startConnect(((JRadioButtonMenuItem)a.getSource()).getName());
				}
			});
			getConnectMenu().insert(radio,getConnectMenu().getMenuComponentCount()-2);
		}
		//TODO: finish this
		getTreeHandlerBean1().setAccess(name);
		getOETree1().clearTree();
		//getOETreeByName().clearTree();
	}
	/**
	 * Comment
	 */
	public void systemExit() {
		getTreeHandlerBean1().destroy();
		dispose();
		System.exit(0);
	}
}
