/*
 * SingleFilterItem.java
 *
 * Created on March 17, 2003, 3:31 PM
 */

package cern.laser.guiplatform.windows.filter;

import java.beans.IntrospectionException;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;

import org.apache.log4j.Logger;

import cern.laser.client.LaserException;
import cern.laser.client.services.selection.Filter;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;

//import javax.swing.plaf.basic.BasicComboBoxEditor;

/**
 * This window allows user to create new filter
 *
 * @author  pawlowsk
 */
public class SingleFilterItem extends javax.swing.JPanel {
    
    /** Creates new form SingleFilterItem */
    public SingleFilterItem() {
        //NetBeans generated method
        initComponents();

        // my internal method
        initializeComponents();
        
        // my internal method
        postInit();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        name = new javax.swing.JComboBox();
        operator = new javax.swing.JComboBox();
        value = new javax.swing.JTextField();
        nameLabel = new javax.swing.JLabel();
        operatorLabel = new javax.swing.JLabel();
        valueLabel = new javax.swing.JLabel();
        addButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EtchedBorder());
        setPreferredSize(new java.awt.Dimension(450, 110));
        name.setEditable(true);
        name.setPreferredSize(new java.awt.Dimension(140, 26));
        name.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 2, 6, 6);
        add(name, gridBagConstraints);

        operator.setPreferredSize(new java.awt.Dimension(140, 26));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 2, 6, 6);
        add(operator, gridBagConstraints);

        value.setPreferredSize(new java.awt.Dimension(140, 26));
        value.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                valueKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 2, 6, 2);
        add(value, gridBagConstraints);

        nameLabel.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 2, 0);
        add(nameLabel, gridBagConstraints);

        operatorLabel.setText("Operator");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 2, 0);
        add(operatorLabel, gridBagConstraints);

        valueLabel.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 2, 0);
        add(valueLabel, gridBagConstraints);

        addButton.setText("Add Filter");
        addButton.setPreferredSize(new java.awt.Dimension(105, 30));
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 6, 6);
        add(addButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void valueKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_valueKeyReleased
        // Add your handling code here:
        if ( enableAddButton() ) addButton.setEnabled(true);
        else addButton.setEnabled(false);
    }//GEN-LAST:event_valueKeyReleased
    
    private void nameKeyReleased(java.awt.event.KeyEvent evt) {
        // Add your handling code here:        
        JTextField textField = (JTextField)name.getEditor().getEditorComponent();
        
        if ( textField.getText().length() != 0 &&
             //((String)operator.getSelectedItem()).length() != 0 &&
             value.getText().length() != 0 )  
            addButton.setEnabled(true);
        else addButton.setEnabled(false);
    }

    
    private void nameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameActionPerformed
        // Add your handling code here:

        // this is probably uselass in new version
        /*
        operator.setModel(
            new DefaultComboBoxModel(
                (Vector)FilterHandler.getOperatorsForName(
                    (String)((JComboBox)evt.getSource()).getSelectedItem()
                )
            )
        );
        */
        
        operator.setModel(
            new DefaultComboBoxModel(Filter.operators));
        
        
        
        if ( enableAddButton() )
            addButton.setEnabled(true);
    }//GEN-LAST:event_nameActionPerformed

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        // Add your handling code here:
        logger.debug("user wants to add new filter");
        
        // add filter to filter list
        if ( filterExplorer == null )
            throw new NullPointerException("FilterExplorer is null");
        
        try {
            if ( !isInUpdateMode ) {
                Filter filter = Filter.create((String)name.getSelectedItem(), 
                                 (String)operator.getSelectedItem(),
                                 value.getText());
                try {
                    filter.validate();
                    filterExplorer.addFilter(filter);
                    cern.laser.guiplatform.util.AppRegister.getInstance().notifyConfigurationChange();
                } catch (LaserException le) {
                    logger.warn("Fitler: " + filter.getProperty() +
                            filter.getOperator() + filter.getValue() + " is not valid");
                    AcWindowManager.notifyError("This filter is not valid");
                }
            } else {
                Filter filter = Filter.create((String)name.getSelectedItem(), 
                                 (String)operator.getSelectedItem(),
                                 value.getText());
                try {
                    filter.validate();
                    filterExplorer.removeFilter(oldName, oldOperator, oldValue);
                    filterExplorer.addFilter(filter);
                    cern.laser.guiplatform.util.AppRegister.getInstance().notifyConfigurationChange();
                } catch (LaserException le) {
                    logger.warn("Fitler: " + filter.getProperty() +
                            filter.getOperator() + filter.getValue() + " is not valid");
                    AcWindowManager.notifyError("This filter is not valid");
                }
            }
        } catch (IntrospectionException e) { 
            logger.error(e, e.fillInStackTrace());
        }

        
        // reset combo boxes and text field
        resetPanel();
    }//GEN-LAST:event_addButtonActionPerformed
   
    /** 
     * This method initializes components, that is fills combo boxes, 
     * fill ListTableExplorer, etc
     */
    private void initializeComponents() {
        // by default add button is disabled
        addButton.setEnabled(false);
        
        name.setModel(new DefaultComboBoxModel(Filter.properties));
        
        operator.setModel(new DefaultComboBoxModel(Filter.operators));
    }

    /**
     * This method checks if add button can be enabled
     *
     * @return true if button can be enbled or false if can not
     */
    private boolean enableAddButton() {
        /*if ( ((String)((JComboBox)evt.getSource()).getSelectedItem()).length() != 0 &&
            ((String)((JComboBox)evt.getSource()).getSelectedItem()).length() != 0 &&
            value.getText().length() != 0 )
         */
        if ( ((String)name.getSelectedItem()).length() != 0 &&
             //((String)operator.getSelectedItem()).length() != 0 &&
             value.getText().length() != 0 )
            return true;
        return false;
    }
    
    /** 
     * This method does post-initialization, for all components.
     * This method is used instead of NetBeans post-init, because is easier to 
     * use.
     *
     */
    private void postInit() {
        // BArtek
        name.getEditor().getEditorComponent().addKeyListener(
            new java.awt.event.KeyAdapter() {
                public void keyReleased(java.awt.event.KeyEvent evt) {
                    nameKeyReleased(evt);
                }
            }
        );
    }
    
    /**
     * This method resets this panel, that is, clears text filed and 
     * selects default items on chechboxes and disables add button
     */
    public void resetPanel() {
        value.setText("");
        name.setSelectedIndex(0);
        operator.setSelectedIndex(0);
        addButton.setEnabled(false);
        addButton.setText("Add Filter");
        isInUpdateMode = false;
    }

    /** This sets explorer. 
     * 
     * @param explorer <code>CreatedFiltersExplorer</code> object, which stores
     *              list with created filters
     */
    public void setFitlerExplorer(CreatedFiltersExplorer explorer) {
        filterExplorer = explorer;
    }

    /**
     * This method reloads combo boxes and text field using new value
     *
     * @param name name
     * @param operator operator
     * @param value value
     * @param buttonName name for button
     */
    public void reload(String name, String operator, String value, String buttonName) {
        logger.debug(getClass().getName() + " reload " + name  + " " +
                            operator + " " + value + " button name " + buttonName);

        this.name.setSelectedItem(name);
        this.operator.setSelectedItem(operator);
        this.value.setText(value);
        this.addButton.setText(buttonName);
    }
    
    /**
     * This method sets this component in  Update Filter mode
     * (used when user wants to edit filter)
     *
     * @param name name
     * @param operator operator
     * @param value value
     * @param buttonName name for button
     */
    public void setInUpdateMode(String name, String operator, String value, 
                                String buttonName) {
        this.name.setSelectedItem(name);
        this.operator.setSelectedItem(operator);
        this.value.setText(value);
        this.addButton.setText(buttonName);
        this.addButton.setEnabled(true);
        
        oldName = name;
        oldOperator = operator;
        oldValue = value;
        isInUpdateMode = true;
    }

    /**
     * This method reset SingleFilterItem if fitler is edited and 
     * was deleted. Situation when user choose filter to edit and next deleted
     * it. If deleted fitler is exactly this, which is currently edited
     * SingleFilterItem is reset.
     *
     * @param name name from filter which should be deleted
     * @param operator operator from filter which should be deleted
     * @param value value from filter which should be deleted
     */
    public void setMode(String name, String operator, String value) {

        if ( oldName.equals(name) && oldOperator.equals(operator) &&
             oldValue.equals(value) )
            resetPanel();


    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JComboBox name;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JComboBox operator;
    private javax.swing.JLabel operatorLabel;
    private javax.swing.JTextField value;
    private javax.swing.JLabel valueLabel;
    // End of variables declaration//GEN-END:variables
    
    /** old name */
    private String oldName = "";
    private String oldOperator = "";
    private String oldValue = "";
    private boolean isInUpdateMode = false;
    
    /** logger */
    static final Logger logger = 
        LogFactory.getLogger(SingleFilterItem.class.getName());
    
    /** created filters explorer, this variable is used when user wants to add
     * new filter to created filters list*/
    private CreatedFiltersExplorer filterExplorer = null;
    
    
}
