package cern.laser.guiplatform.windows.configuration;

import java.awt.Dimension;
import java.beans.IntrospectionException;
import java.util.List;

import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.filter.CreateFiltersPanel;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 * This is console configuration window, here user can choose category,
 * load configuration, etc.....
 *
 * @author pawlowsk
 */
public class ConsoleConfigurationWindow extends TopComponent /* or CloneableTopComponent */ {
        
    /** logger*/
    private static Logger logger = LogFactory.getLogger(ConsoleConfigurationWindow.class.getName());
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    /*
     *
     * this is main configuration window.
     * this window consists of three tabbed panes. first is category,
     * second for filters and third for configuration (i. e. bahaviour)
     * 
     * @param user user, who is this configuration window created for
     * @param configuration, configuration which should be shown to the user
     *
     */
    public ConsoleConfigurationWindow(User user, Configuration configuration)
        throws LaserException {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        // Display name of this window (not needed if you use the DataObject constructor):
        setName(NbBundle.getMessage(ConsoleConfigurationWindow.class, 
                                "LBL_ConsoleConfigurationWindow_component_name"));
        // You may set the icon, but often it is better to set the icon for an associated mode instead:
        // setIcon(Utilities.loadImage("cern/laser/guiplatform/windows/configuration/ConsoleConfigurationWindowIcon.gif", true));
        // Use the Component Inspector to set tool-tip text. This will be saved
        // automatically. Other JComponent properties you may need to save yuorself.
        // At any time you can affect the node selection:
        // setActivatedNodes(new Node[] {...});
        
        
        // do not serialize
        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");
        
        this.user = user;
        this.configuration = configuration;
        
        postInitComponents();
        
    }
    
    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConsoleConfigurationWindow.class);
    }
     */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new ConsoleConfigurationWindow();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

    }//GEN-END:initComponents

    /**
     */
    //private void 
    
    /**
     * post Init components
     */   
    private void postInitComponents() throws LaserException {
        loadConfigurationPanel = new LoadConfigurationPanel(this, user);
        configurationPanel = new ConsoleConfigurationPanel(this, configuration);

        setLayout(new java.awt.BorderLayout());

        add(loadConfigurationPanel, java.awt.BorderLayout.WEST);
        add(configurationPanel, java.awt.BorderLayout.CENTER);        
    } 
    
    
    //
    // -- mediator methods -----------------------------------------
    //
    /**
     * This method removes filter from defined list explorer
     * @param node node to be removed
     */
    public void removeFilter(GPNode node) {
        ((ConsoleConfigurationPanel) configurationPanel).removeFilter(node);
    } 
    
    /**
     * This method removes all filter from defined list explorer
     */
    public void removeAllFilters() {
        ((ConsoleConfigurationPanel) configurationPanel).removeAllFilters();
    }

    /**
     * This method sets this component in  Update Filter mode
     * (used when user wants to edit filter)
     *
     * @param name name
     * @param operator operator
     * @param value value
     * @param buttonName name for button
     */
    public void setInUpdateMode(String name, String operator, String value, 
                                String buttonName) {
     
        ((ConsoleConfigurationPanel) configurationPanel).setInUpdateMode(name, 
                                                                         operator, 
                                                                         value, 
                                                                         buttonName);
    }
    public void updateCategoryTreeExplorer() 
        throws IntrospectionException, CloneNotSupportedException{
        ((ConsoleConfigurationPanel) configurationPanel).updateCategoryTreeExplorer();
    }
    public void loadAllCategoriesInTreeExplorer() 
        throws IntrospectionException, CloneNotSupportedException{
        ((ConsoleConfigurationPanel) configurationPanel).loadAllCategoriesInTreeExplorer();
    }
    /**
     * This method adds category to choosen category explorer
     * @param node category to be added
     */
    public void addCategory(GPNode node) 
        throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel) configurationPanel).addCategory(node);
    }
    public void addCategoryWithoutChildren(GPNode node) 
        throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel) configurationPanel).addCategoryWithoutChildren(node);
    }    
    public void addSubCategories(GPNode node) 
        throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel) configurationPanel).addSubCategories(node);
    }      
    public void removeCategoryWithoutChildren(GPNode node) 
        throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel) configurationPanel).removeCategoryWithoutChildren(node);
    }     
    public void removeSubCategories(GPNode node) 
        throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel) configurationPanel).removeSubCategories(node);
    }
    public void removeCategory(GPNode node) {
        ((ConsoleConfigurationPanel) configurationPanel).removeCategory(node);
    }

    /**
     * This method remove all categories from ChoosenCategoryExplorer
     */
    public void removeAllCategories() {
        ((ConsoleConfigurationPanel) configurationPanel).removeAllCategories();
    }

    /**
     * This method gets configurations from JList from LoadConfigurationPanel
     *
     * @return DefaultListModel with configurations names as <code>String</code>
     */
    /*
    public DefaultListModel getDefinedConfigurations() {
                                                                                                                                     
        //return ((LoadCategoryPanel)loadCategoryPanel).getDefinedConfigurationNames();
        // TODO: impelement this method
        return null;
    }
    */

    /**
     * This method adds new cofiguration to JList in LoadConfigurationPanel
     *
     *
     */
    public void addConfigurationToList(ConfigurationBean configuration)
        throws java.beans.IntrospectionException {
                                                                                                                                     
        ((LoadConfigurationPanel) loadConfigurationPanel).addNewConfiguration(configuration);
    }

    /**
     * This method removes configuration from UserExplorer
     * @param node
     */
    public void removeConfiguration(GPNode node) {
        ((LoadConfigurationPanel) loadConfigurationPanel).removeConfiguration(node);
    }

    /**
     * Returns list with given user configurations names
     * @param user users, 
     */
    public List getDefinedConfigurations(User user) throws LaserConsoleException {
        return ((LoadConfigurationPanel) loadConfigurationPanel).getDefinedConfigurationNames(user);
    }

    /**
     * Updates configuration panel, when user wants to load configuration
     * (ConfigurationLoad action)
     *
     * @param configuration configuration to be loaded
     */
    public void updateConfigurationPanel(Configuration configuration, String ownerLogin) throws LaserConsoleException {
        ((ConsoleConfigurationPanel) configurationPanel).updateConfiguration(
                                                                 configuration, ownerLogin);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    private javax.swing.JPanel configurationPanel;
    private javax.swing.JPanel loadConfigurationPanel;
    
    /** user */
    User user = null;
    /** configuraton */
    Configuration configuration = null;

    /** filters panel */
    private CreateFiltersPanel filtersPanel = null;

    /** default configuration window dimension */ 
    private final static Dimension defaultDimension = new Dimension(
            (int) (WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 1.5),  
            (int) (WindowManager.getDefault().getCurrentWorkspace().getBounds().height / 1.2));

    /** */
    public final static Dimension defaultLoadConfigurationPanelDimension = 
            new Dimension(defaultDimension.width/4, defaultDimension.height);
    
    
    
    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String ConsoleConfigurationWindow_MODE = "ConsoleConfigurationWindow";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(ConsoleConfigurationWindow_MODE);
        if (m == null) {
            try {
                m = ws.createMode(ConsoleConfigurationWindow_MODE, // code name
                                   NbBundle.getMessage(ConsoleConfigurationWindow.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/configuration/ConsoleConfigurationWindowIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return defaultDimension;
    }
     
    /**
     * WARNING: In final product this method should be removed
     */ 
    protected void componentClosed() {
       AppRegister.getInstance().clearConfigurationChangeListeners(); 
    }




    /*
    // If you want it to open on a specific workspace:
    public static final String ConsoleConfigurationWindow_WORKSPACE = NbBundle.getMessage(ConsoleConfigurationWindow.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(ConsoleConfigurationWindow_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(ConsoleConfigurationWindow_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static ConsoleConfigurationWindow theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
    
}
